/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component.space;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.dashboard.webui.component.DashboardParent;
import org.exoplatform.dashboard.webui.component.UIDashboard;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import social.portal.webui.component.space.UIHomeSpaceControlArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/portal/webui/space/UIHomeSpacePortlet.gtmpl")
public class UIHomeSpacePortlet
extends UIPortletApplication
implements DashboardParent {
    public UIHomeSpacePortlet() throws Exception {
        this.addChild(UIHomeSpaceControlArea.class, null, null);
        this.addChild(UIDashboard.class, null, null);
    }

    public boolean canEdit() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        String remoteUser = context.getRemoteUser();
        OrganizationService orgSrc = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        MembershipHandler memberShipHandler = orgSrc.getMembershipHandler();
        String spaceName = this.getSpaceNameCleaned();
        try {
            if (memberShipHandler.findMembershipByUserGroupAndType(remoteUser, "/spaces/" + spaceName, "manager") != null) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<PageNode> getApps() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        String spaceName = this.getSpaceNameCleaned();
        int spaceNav = ("group::spaces/" + spaceName).hashCode();
        PageNavigation pageNav = uiPortal.getPageNavigation(spaceNav);
        PageNode homeNode = pageNav.getNode(spaceName);
        ArrayList list = homeNode.getChildren();
        if (list == null) {
            list = new ArrayList();
        }
        return list;
    }

    public String getSpaceNameCleaned() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        HttpServletRequest request = pcontext.getRequest();
        String url = request.getRequestURL().toString();
        String spaceName = url.substring(url.lastIndexOf("/") + 1);
        return spaceName;
    }

    public String getDashboardOwner() {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }
}

