/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.webui.page.UIPageNodeForm2;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceAttachment;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceListAccess;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.social.webui.UISpaceSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import social.portal.webui.component.UIManageMySpaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/portal/webui/component/UIManageMySpaces.gtmpl", events={@EventConfig(listeners={EditSpaceActionListener.class}), @EventConfig(listeners={EditSpaceNavigationActionListener.class}), @EventConfig(listeners={DeleteSpaceActionListener.class}, confirm="UIManageMySpace.msg.confirm_space_delete"), @EventConfig(listeners={LeaveSpaceActionListener.class}), @EventConfig(listeners={AddSpaceActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIPageNodeForm2.class, lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={UIPageNodeForm2.SaveActionListener.class}), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm2.SwitchPublicationDateActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm2.ClearPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIPageNodeForm2.CreatePageActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIManageMySpaces
extends UIContainer {
    private static final String MSG_WARNING_LEAVE_SPACE = "UIManageMySpaces.msg.warning_leave_space";
    private static final String MSG_ERROR_LEAVE_SPACE = "UIManageMySpaces.msg.error_leave_space";
    private static final String MSG_ERROR_DELETE_SPACE = "UIManageMySpaces.msg.error_delete_space";
    private static final Integer LEADER = 1;
    private static final Integer MEMBER = 2;
    private static final String SPACE_DELETED_INFO = "UIManageMySpaces.msg.DeletedInfo";
    private static final String MEMBERSHIP_REMOVED_INFO = "UIManageMySpaces.msg.MemberShipRemovedInfo";
    private final String POPUP_ADD_SPACE = "UIPopupAddSpace";
    private UIPageIterator iterator;
    private final Integer SPACES_PER_PAGE = 4;
    private final String ITERATOR_ID = "UIIteratorMySpaces";
    private SpaceService spaceService = null;
    private String userId = null;
    private List<PageNavigation> navigations;
    private PageNavigation selectedNavigation;
    private List<Space> spaces_;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");

    public UIManageMySpaces() throws Exception {
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorMySpaces");
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAddSpace");
        uiPopup.setShow(false);
        uiPopup.setWindowSize(400, 0);
        this.addChild((UIComponent)uiPopup);
    }

    public UIPageIterator getMySpacesUIPageIterator() {
        return this.iterator;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    private void loadNavigations() throws Exception {
        this.navigations = new ArrayList();
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Query query = new Query("group", null, PageNavigation.class);
        List navis = dataStorage.find(query, (Comparator)new /* Unavailable Anonymous Inner Class!! */).getAll();
        for (PageNavigation ele : navis) {
            if (!userACL.hasEditPermission(ele)) continue;
            this.navigations.add(ele);
        }
    }

    public List<Space> getAllUserSpaces() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        List userSpaces = spaceService.getAccessibleSpaces(userId);
        SpaceUtils.reloadNavigation();
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    public PageNavigation getSelectedNavigation() {
        return this.selectedNavigation;
    }

    public void setSelectedNavigation(PageNavigation navigation) {
        this.selectedNavigation = navigation;
    }

    public List<Space> getUserSpaces() throws Exception {
        List listSpace = this.getMySpace();
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getAllMySpaceNames());
        return this.getDisplayMySpace(listSpace, this.iterator);
    }

    public int getRole(String spaceId) throws SpaceException {
        String userId;
        SpaceService spaceService = this.getSpaceService();
        if (spaceService.hasEditPermission(spaceId, userId = this.getUserId())) {
            return LEADER;
        }
        return MEMBER;
    }

    public boolean hasMembership(String spaceId) throws SpaceException {
        String userId;
        SpaceService spaceService = this.getSpaceService();
        return spaceService.isMember(spaceId, userId = this.getUserId());
    }

    public void setSpaces_(List<Space> spaces_) {
        this.spaces_ = spaces_;
    }

    public List<Space> getSpaces_() {
        return this.spaces_;
    }

    private List<Space> getMySpace() throws Exception {
        List spaceList = this.getSpaces_();
        List allUserSpace = this.getAllUserSpaces();
        ArrayList<Space> mySpaces = new ArrayList<Space>();
        if (allUserSpace.size() == 0) {
            return allUserSpace;
        }
        if (spaceList != null) {
            block0: for (Space space : spaceList) {
                for (Space userSpace : allUserSpace) {
                    if (!space.getName().equalsIgnoreCase(userSpace.getName())) continue;
                    mySpaces.add(userSpace);
                    continue block0;
                }
            }
            return mySpaces;
        }
        return allUserSpace;
    }

    private List<Space> getDisplayMySpace(List<Space> spaces_, UIPageIterator pageIterator_) throws Exception {
        int currentPage = pageIterator_.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new SpaceListAccess(spaces_), this.SPACES_PER_PAGE.intValue());
        pageIterator_.setPageList((PageList)pageList);
        int pageCount = pageIterator_.getAvailablePage();
        if (pageCount >= currentPage) {
            pageIterator_.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            pageIterator_.setCurrentPage(currentPage - 1);
        }
        return pageIterator_.getCurrentPageData();
    }

    public String getImageSource(Space space) throws Exception {
        SpaceAttachment spaceAtt = space.getSpaceAttachment();
        if (spaceAtt != null) {
            return "/" + this.getPortalName() + "/rest/jcr/" + this.getRepository() + "/" + spaceAtt.getWorkspace() + spaceAtt.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private List<String> getAllMySpaceNames() throws Exception {
        List allSpaces = this.getAllUserSpaces();
        ArrayList<String> allSpacesNames = new ArrayList<String>();
        for (Space space : allSpaces) {
            allSpacesNames.add(space.getName());
        }
        return allSpacesNames;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    static /* synthetic */ void access$000(UIManageMySpaces x0) throws Exception {
        x0.loadNavigations();
    }

    static /* synthetic */ SpaceService access$100(UIManageMySpaces x0) {
        return x0.getSpaceService();
    }

    static /* synthetic */ String access$200(UIManageMySpaces x0) {
        return x0.getUserId();
    }
}

