/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceAttachment;
import org.exoplatform.social.space.SpaceException;
import org.exoplatform.social.space.SpaceListAccess;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.space.SpaceUtils;
import org.exoplatform.social.webui.UISpaceSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import social.portal.webui.component.UIManagePendingSpaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/portal/webui/component/UIManagePendingSpaces.gtmpl", events={@EventConfig(listeners={RevokePendingActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIManagePendingSpaces
extends UIContainer {
    private static final String MSG_ERROR_REVOKE_PENDING = "UIManagePendingSpaces.msg.error_revoke_pending";
    private static final String SPACE_DELETED_INFO = "UIManagePendingSpaces.msg.DeletedInfo";
    SpaceService spaceService = null;
    String userId = null;
    private UIPageIterator iterator;
    private final String ITERATOR_ID = "UIIteratorPendingSpaces";
    private final Integer SPACES_PER_PAGE = 4;
    private List<Space> spaces_;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");

    public UIManagePendingSpaces() throws Exception {
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorPendingSpaces");
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public List<Space> getAllPendingSpaces() throws SpaceException {
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        List userSpaces = spaceService.getPendingSpaces(userId);
        return SpaceUtils.getOrderedSpaces((List)userSpaces);
    }

    private List<Space> getSpaceList() throws Exception {
        List spaceList = this.getSpaces_();
        List allPendingSpace = this.getAllPendingSpaces();
        if (allPendingSpace.size() == 0) {
            return allPendingSpace;
        }
        ArrayList<Space> pendingSpaces = new ArrayList<Space>();
        if (spaceList != null) {
            block0: for (Space space : spaceList) {
                for (Space pendingSpace : allPendingSpace) {
                    if (!space.getName().equals(pendingSpace.getName())) continue;
                    pendingSpaces.add(pendingSpace);
                    continue block0;
                }
            }
            return pendingSpaces;
        }
        return allPendingSpace;
    }

    public List<Space> getPendingSpaces() throws Exception {
        List listSpace = this.getSpaceList();
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getPendingSpaceNames());
        return this.getDisplayPendingSpaces(listSpace, this.iterator);
    }

    public String getImageSource(Space space) throws Exception {
        SpaceAttachment spaceAtt = space.getSpaceAttachment();
        if (spaceAtt != null) {
            return "/" + this.getPortalName() + "/rest/jcr/" + this.getRepository() + "/" + spaceAtt.getWorkspace() + spaceAtt.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    private List<String> getPendingSpaceNames() throws SpaceException {
        List pendingSpaces = this.getAllPendingSpaces();
        ArrayList<String> pendingSpaceNames = new ArrayList<String>();
        for (Space space : pendingSpaces) {
            pendingSpaceNames.add(space.getName());
        }
        return pendingSpaceNames;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private List<Space> getDisplayPendingSpaces(List<Space> spaces, UIPageIterator iterator) throws Exception {
        int currentPage = iterator.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new SpaceListAccess(spaces), this.SPACES_PER_PAGE.intValue());
        iterator.setPageList((PageList)pageList);
        int pageCount = iterator.getAvailablePage();
        if (pageCount >= currentPage) {
            iterator.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            iterator.setCurrentPage(currentPage - 1);
        }
        return iterator.getCurrentPageData();
    }

    public void setSpaces_(List<Space> spaces_) {
        this.spaces_ = spaces_;
    }

    public List<Space> getSpaces_() {
        return this.spaces_;
    }

    static /* synthetic */ SpaceService access$000(UIManagePendingSpaces x0) {
        return x0.getSpaceService();
    }

    static /* synthetic */ String access$100(UIManagePendingSpaces x0) {
        return x0.getUserId();
    }
}

