/*
 * Decompiled with CFR 0.152.
 */
package social.portal.webui.component;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.space.Space;
import org.exoplatform.social.space.SpaceAttachment;
import org.exoplatform.social.space.SpaceListAccess;
import org.exoplatform.social.space.SpaceService;
import org.exoplatform.social.webui.UISpaceSearch;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import social.portal.webui.component.UIManagePublicSpaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/portal/webui/component/UIManagePublicSpaces.gtmpl", events={@EventConfig(listeners={RequestJoinActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIManagePublicSpaces
extends UIContainer {
    private static final String SPACE_DELETED_INFO = "UIPublicSpacePortlet.msg.DeletedInfo";
    private static final String MSG_ERROR_REQUEST_JOIN = "UIManagePublicSpaces.msg.error_request_join";
    private SpaceService spaceService = null;
    private String userId = null;
    private UIPageIterator iterator;
    private final String ITERATOR_ID = "UIIteratorPublicSpaces";
    private final Integer SPACES_PER_PAGE = 4;
    private List<Space> spaces;
    private UISpaceSearch uiSpaceSearch = (UISpaceSearch)this.createUIComponent(UISpaceSearch.class, null, "UISpaceSearch");

    public UIManagePublicSpaces() throws Exception {
        this.addChild((UIComponent)this.uiSpaceSearch);
        this.iterator = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UIIteratorPublicSpaces");
    }

    public UIPageIterator getUIPageIterator() {
        return this.iterator;
    }

    public List<Space> getAllPublicSpaces() throws Exception {
        UserACL userACL;
        SpaceService spaceService = this.getSpaceService();
        String userId = this.getUserId();
        if (userId.equals((userACL = (UserACL)this.getApplicationComponent(UserACL.class)).getSuperUser())) {
            return new ArrayList<Space>();
        }
        return spaceService.getPublicSpaces(userId);
    }

    public boolean hasEditPermission(Space space) throws Exception {
        SpaceService spaceService = this.getSpaceService();
        return spaceService.hasEditPermission(space, this.getUserId());
    }

    public List<Space> getPublicSpaces() throws Exception {
        List spaceList = this.getSpaceList();
        this.uiSpaceSearch.setSpaceNameForAutoSuggest(this.getPublicSpaceNames());
        return this.getDisplayPublicSpaces(spaceList, this.iterator);
    }

    public String getImageSource(Space space) throws Exception {
        SpaceAttachment spaceAtt = space.getSpaceAttachment();
        if (spaceAtt != null) {
            return "/" + this.getRestContext() + "/jcr/" + this.getRepository() + "/" + spaceAtt.getWorkspace() + spaceAtt.getDataPath() + "/?rnd=" + System.currentTimeMillis();
        }
        return null;
    }

    public void setSpaces(List<Space> spaces) {
        this.spaces = spaces;
    }

    public List<Space> getSpaces() {
        return this.spaces;
    }

    private String getUserId() {
        if (this.userId == null) {
            this.userId = Util.getPortalRequestContext().getRemoteUser();
        }
        return this.userId;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private List<Space> getSpaceList() throws Exception {
        List spaceList = this.getSpaces();
        List allPublicSpace = this.getAllPublicSpaces();
        if (allPublicSpace.size() == 0) {
            return allPublicSpace;
        }
        ArrayList<Space> publicSpaces = new ArrayList<Space>();
        if (spaceList != null) {
            block0: for (Space space : spaceList) {
                for (Space publicSpace : allPublicSpace) {
                    if (!space.getName().equals(publicSpace.getName())) continue;
                    publicSpaces.add(publicSpace);
                    continue block0;
                }
            }
            return publicSpaces;
        }
        return allPublicSpace;
    }

    private List<String> getPublicSpaceNames() throws Exception {
        List publicSpaces = this.getAllPublicSpaces();
        ArrayList<String> publicSpaceNames = new ArrayList<String>();
        for (Space space : publicSpaces) {
            publicSpaceNames.add(space.getName());
        }
        return publicSpaceNames;
    }

    private String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getRestContext() {
        return PortalContainer.getInstance().getRestContextName();
    }

    private List<Space> getDisplayPublicSpaces(List<Space> spaces, UIPageIterator iterator) throws Exception {
        int currentPage = iterator.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new SpaceListAccess(spaces), this.SPACES_PER_PAGE.intValue());
        iterator.setPageList((PageList)pageList);
        int pageCount = iterator.getAvailablePage();
        if (pageCount >= currentPage) {
            iterator.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            iterator.setCurrentPage(currentPage - 1);
        }
        return iterator.getCurrentPageData();
    }

    static /* synthetic */ SpaceService access$000(UIManagePublicSpaces x0) {
        return x0.getSpaceService();
    }

    static /* synthetic */ String access$100(UIManagePublicSpaces x0) {
        return x0.getUserId();
    }
}

