/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.portlet.UIProfileNavigationPortlet;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UIProfileNavigationPortlet.gtmpl", events={@EventConfig(listeners={AddContactActionListener.class}), @EventConfig(listeners={AcceptContactActionListener.class}), @EventConfig(listeners={DenyContactActionListener.class})})
public class UIProfileNavigationPortlet
extends UIPortletApplication {
    private static final String INVITATION_REVOKED_INFO = "UIProfileNavigationPortlet.label.RevokedInfo";
    private static final String INVITATION_ESTABLISHED_INFO = "UIProfileNavigationPortlet.label.InvitationEstablishedInfo";
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;

    public String getSelectedNode() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestUrl = pcontext.getRequestURI();
        String[] split = requestUrl.split("/");
        if (split.length == 6) {
            return split[split.length - 2];
        }
        if (split.length == 7) {
            return split[split.length - 3];
        }
        return split[split.length - 1];
    }

    public boolean isMe() {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        if (currentViewer == null) {
            return true;
        }
        return currentUserName.equals(currentViewer);
    }

    public Relationship.Type getContactStatus() throws Exception {
        Identity viewerIdentity = this.getCurrentViewerIdentity();
        if (viewerIdentity.getId().equals(this.getCurrentIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager rm = this.getRelationshipManager();
        Relationship rl = rm.getRelationship(viewerIdentity, this.getCurrentIdentity());
        return rm.getRelationshipStatus(rl, this.getCurrentIdentity());
    }

    protected String getImageSource() throws Exception {
        Identity currIdentity = Utils.getCurrentIdentity();
        return currIdentity.getProfile().getAvatarImageSource();
    }

    private String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private String getRestContext() {
        return PortalContainer.getInstance().getRestContextName();
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getOrCreateIdentity("organization", this.getCurrentUserName());
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getOrCreateIdentity("organization", this.getCurrentViewerUserName());
    }

    private String getCurrentViewerUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            PortalContainer container = PortalContainer.getInstance();
            this.relationshipManager = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    static /* synthetic */ RelationshipManager access$000(UIProfileNavigationPortlet x0) {
        return x0.getRelationshipManager();
    }
}

