/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.portlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.webui.navigation.PageNavigationUtils;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/groovy/social/portlet/UISocialUserToolBarGroupPortlet.gtmpl")
public class UISocialUserToolBarGroupPortlet
extends UIPortletApplication {
    SpaceService spaceService;

    public List<PageNavigation> getGroupNavigations() throws Exception {
        String remoteUser = Util.getPortalRequestContext().getRemoteUser();
        List allNavigations = Util.getUIPortalApplication().getNavigations();
        ArrayList<PageNavigation> navigations = new ArrayList<PageNavigation>();
        SpaceService spaceSrv = this.getSpaceService();
        List spaces = spaceSrv.getAllSpaces();
        for (PageNavigation navigation : allNavigations) {
            if (!navigation.getOwnerType().equals("group")) continue;
            navigations.add(PageNavigationUtils.filter((PageNavigation)navigation, (String)remoteUser));
        }
        block1: for (Space space : spaces) {
            for (PageNavigation navigation : navigations) {
                if (!navigation.getOwnerId().equals(space.getGroupId())) continue;
                navigations.remove(navigation);
                continue block1;
            }
        }
        for (PageNavigation navi : navigations) {
            ArrayList nodes = navi.getNodes();
            for (PageNode node : nodes) {
                if (this.isRender(node)) continue;
                node.setVisibility(Visibility.HIDDEN);
            }
        }
        return navigations;
    }

    public PageNode getSelectedPageNode() throws Exception {
        return Util.getUIPortal().getSelectedNode();
    }

    protected void localizePageNavigation(PageNavigation nav) {
        Locale locale = Util.getUIPortalApplication().getLocale();
        ResourceBundleManager mgr = (ResourceBundleManager)this.getApplicationComponent(ResourceBundleManager.class);
        if (nav.getOwnerType().equals("user")) {
            return;
        }
        ResourceBundle res = mgr.getNavigationResourceBundle(locale.getLanguage(), nav.getOwnerType(), nav.getOwnerId());
        for (PageNode node : nav.getNodes()) {
            this.resolveLabel(res, node);
        }
    }

    private void resolveLabel(ResourceBundle res, PageNode node) {
        node.setResolvedLabel(res);
        if (node.getChildren() == null) {
            return;
        }
        for (PageNode childNode : node.getChildren()) {
            this.resolveLabel(res, childNode);
        }
    }

    private boolean isRender(PageNode node) throws SpaceException {
        SpaceService spaceSrv = this.getSpaceService();
        List spaces = spaceSrv.getAllSpaces();
        for (Space space : spaces) {
            if (!space.getDisplayName().equals(node.getUri())) continue;
            return false;
        }
        return true;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }
}

