/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.api.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.model.Model;
import org.exoplatform.social.client.api.model.RestActivityStream;
import org.exoplatform.social.client.api.model.RestComment;
import org.exoplatform.social.client.api.model.RestIdentity;
import org.exoplatform.social.client.api.net.SocialHttpClient;
import org.exoplatform.social.client.api.net.SocialHttpClientException;
import org.exoplatform.social.client.api.service.ActivityService;
import org.exoplatform.social.client.api.service.IdentityService;
import org.exoplatform.social.client.api.service.QueryParams;
import org.exoplatform.social.client.api.service.ServiceException;
import org.exoplatform.social.client.api.util.SocialHttpClientSupport;
import org.exoplatform.social.client.api.util.SocialJSONDecodingSupport;
import org.exoplatform.social.client.core.ClientServiceFactoryHelper;
import org.exoplatform.social.client.core.service.QueryParamsImpl;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestActivity
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestActivity.class);
    public static final String DOC_ACTIVITY_TYPE = "DOC_ACTIVITY";
    public static final String DEFAULT_ACTIVITY_TYPE = "DEFAULT_ACTIVITY";
    public static final String LINK_ACTIVITY_TYPE = "LINK_ACTIVITY";

    public String getId() {
        return this.getFieldAsString(Field.ID.toString());
    }

    public void setId(String id) {
        this.setField(Field.ID.toString(), id);
    }

    public String getTitle() {
        return this.getFieldAsString(Field.TITLE.toString());
    }

    public void setTitle(String title) {
        this.setField(Field.TITLE.toString(), title);
    }

    public String getTitleId() {
        return this.getFieldAsString(Field.TITLE_ID.toString());
    }

    public void setBody(String body) {
        this.setField(Field.BODY.toString(), body);
    }

    public String getBody() {
        return this.getFieldAsString(Field.BODY.toString());
    }

    public void setTitleId(String titleId) {
        this.setField(Field.TITLE_ID.toString(), titleId);
    }

    public String getAppId() {
        return this.getFieldAsString(Field.APP_ID.toString());
    }

    public void setAppId(String appId) {
        this.setField(Field.APP_ID.toString(), appId);
    }

    public String getType() {
        return this.getFieldAsString(Field.TYPE.toString());
    }

    public void setType(String type) {
        this.setField(Field.TYPE.toString(), type);
    }

    public Long getPostedTime() {
        return (Long)this.getField(Field.POSTED_TIME.toString());
    }

    public Long getLastUpdated() {
        return (Long)this.getField(Field.LAST_UPDATED.toString());
    }

    public void setPostedTime(Long postedTime) {
        this.setField(Field.POSTED_TIME.toString(), postedTime);
    }

    public void setLastUpdated(Long lastUpdated) {
        this.setField(Field.LAST_UPDATED.toString(), lastUpdated);
    }

    public Double getPriority() {
        return (Double)this.getField(Field.PRIORITY.toString());
    }

    public void setPriority(Double priority) {
        this.setField(Field.PRIORITY.toString(), priority);
    }

    public Map<String, String> getTemplateParams() {
        return this.getFieldAsMap(Field.TEMPLATE_PARAMS.toString());
    }

    public void setTemplateParams(Map<String, String> templateParams) {
        this.setField(Field.TEMPLATE_PARAMS.toString(), templateParams);
    }

    public String getIdentityId() {
        return this.getFieldAsString(Field.IDENTITY_ID.toString());
    }

    public void setIdentityId(String identityId) {
        this.setField(Field.IDENTITY_ID.toString(), identityId);
    }

    public boolean isLiked() {
        return Boolean.parseBoolean(this.getFieldAsString(Field.LIKED.toString()));
    }

    public RestIdentity getPosterIdentity() throws SocialClientLibException {
        String posterIdentityString = this.getFieldAsString(Field.POSTER_IDENTITY.toString());
        RestIdentity restIdentity = null;
        if (posterIdentityString != null && posterIdentityString.length() > 2) {
            try {
                restIdentity = SocialJSONDecodingSupport.parser(RestIdentity.class, posterIdentityString);
            }
            catch (Exception e) {
                throw new ServiceException(ActivityService.class, e.getMessage(), e);
            }
        } else {
            IdentityService service = ClientServiceFactoryHelper.getClientServiceFactory().createIdentityService();
            restIdentity = (RestIdentity)service.get(this.getIdentityId());
        }
        return restIdentity;
    }

    public List<RestComment> getAvailableComments() {
        try {
            String commentsJSON = this.getFieldAsString(Field.COMMENTS.toString());
            List<RestComment> comments = SocialJSONDecodingSupport.JSONArrayObjectParser(RestComment.class, commentsJSON);
            return comments;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
    }

    public List<RestIdentity> getAvailableLikes() {
        try {
            String likedByIdentitiesJSON = this.getFieldAsString(Field.LIKED_BY_IDENTITIES.toString());
            List<RestIdentity> likedByIdentities = SocialJSONDecodingSupport.JSONArrayObjectParser(RestIdentity.class, likedByIdentitiesJSON);
            return likedByIdentities;
        }
        catch (Exception e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
    }

    public void setAvailableComments(List<RestComment> restCommentList) {
    }

    public int getTotalNumberOfComments() {
        return Integer.parseInt(this.getFieldAsString(Field.TOTAL_NUMBER_OF_COMMENTS.toString()));
    }

    public List<RestComment> getTotalComments() throws SocialClientLibException {
        String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + "/comments.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            SocialHttpClientSupport.handleError(response);
            String responseContent = SocialHttpClientSupport.getContent(response);
            List<RestComment> comments = SocialJSONDecodingSupport.JSONArrayObjectParser(RestComment.class, responseContent);
            return comments;
        }
        catch (IOException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
    }

    public int getTotalNumberOfLikes() {
        return Integer.parseInt(this.getFieldAsString(Field.TOTAL_NUMBER_OF_LIKES.toString()));
    }

    public List<RestIdentity> getTotalLikes() throws SocialClientLibException {
        String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + "/likes.json";
        try {
            HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
            String responseContent = SocialHttpClientSupport.getContent(response);
            SocialHttpClientSupport.handleError(response);
            List<RestIdentity> likedByIdentities = SocialJSONDecodingSupport.JSONArrayObjectParser(RestIdentity.class, responseContent);
            return likedByIdentities;
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
    }

    public RestActivityStream getActivityStream() throws SocialClientLibException {
        String activityStreamJSON = this.getFieldAsString(Field.ACTIVITY_STREAM.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("activityStreamJSON: " + activityStreamJSON);
        }
        RestActivityStream restActivityStream = null;
        try {
            if (activityStreamJSON != null && activityStreamJSON.length() > 2) {
                restActivityStream = SocialJSONDecodingSupport.parser(RestActivityStream.class, activityStreamJSON);
            } else {
                QueryParams queryParamBuilder = new QueryParamsImpl().append(QueryParams.ACTIVITY_STREAM_PARAM.setValue("t"));
                String GET_ACTIVITY_REQUEST_URL = SocialHttpClientSupport.buildCommonRestPathFromContext(true) + "activity/" + this.getId() + ".json?" + queryParamBuilder.buildQuery();
                HttpResponse response = SocialHttpClientSupport.executeGet(GET_ACTIVITY_REQUEST_URL, SocialHttpClient.POLICY.BASIC_AUTH);
                SocialHttpClientSupport.handleError(response);
                RestActivity activity = SocialJSONDecodingSupport.parser(RestActivity.class, response);
                restActivityStream = activity.getActivityStream();
                this.setField(Field.ACTIVITY_STREAM.toString(), activity.getFieldAsString(Field.ACTIVITY_STREAM.toString()));
            }
        }
        catch (SocialHttpClientException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
        catch (ParseException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ServiceException(ActivityService.class, e.getMessage(), e);
        }
        return restActivityStream;
    }

    public String getTemplateParameter(String name) {
        Map<String, String> templateParams = this.getTemplateParams();
        if (templateParams != null) {
            return templateParams.get(name);
        }
        return null;
    }

    public void addTemplateParameter(String name, String value) {
        Map<String, String> templateParams = this.getTemplateParams();
        if (templateParams == null) {
            templateParams = new HashMap<String, String>();
        }
        templateParams.put(name, value);
        this.setTemplateParams(templateParams);
    }

    public static enum Field {
        ID("id"),
        TITLE("title"),
        BODY("body"),
        APP_ID("appId"),
        TYPE("type"),
        POSTED_TIME("postedTime"),
        LAST_UPDATED("lastUpdated"),
        POSTER_IDENTITY("posterIdentity"),
        CREATED_AT("createdAt"),
        PRIORITY("priority"),
        TEMPLATE_PARAMS("templateParams"),
        TITLE_ID("titleId"),
        IDENTITY_ID("identityId"),
        LIKED("liked"),
        LIKED_BY_IDENTITIES("likedByIdentities"),
        COMMENTS("comments"),
        TOTAL_NUMBER_OF_COMMENTS("totalNumberOfComments"),
        TOTAL_NUMBER_OF_LIKES("totalNumberOfLikes"),
        ACTIVITY_STREAM("activityStream");

        private final String jsonString;

        private Field(String jsonString) {
            this.jsonString = jsonString;
        }

        public String toString() {
            return this.jsonString;
        }
    }
}

