/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.social.client.core;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.IsEqual.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;

import org.exoplatform.social.client.api.ClientServiceFactory;
import org.exoplatform.social.client.api.SocialClientContext;
import org.exoplatform.social.client.api.SocialClientContext.SupportedVersion;
import org.exoplatform.social.client.api.SocialClientLibException;
import org.exoplatform.social.client.api.service.ActivityService;
import org.exoplatform.social.client.api.service.IdentityService;
import org.exoplatform.social.client.api.service.SpaceService;
import org.exoplatform.social.client.core.service.ActivityServiceImplV1Alpha1;
import org.exoplatform.social.client.core.service.ActivityServiceImplV1Alpha2;
import org.exoplatform.social.client.core.service.ActivityServiceImplV1Alpha3;
import org.exoplatform.social.client.core.service.IdentityServiceImplV1Alpha1;
import org.exoplatform.social.client.core.service.IdentityServiceImplV1Alpha2;
import org.exoplatform.social.client.core.service.IdentityServiceImplV1Alpha3;
import org.exoplatform.social.client.core.service.SpaceServiceImplV1Alpha3;
import org.testng.annotations.Test;

/**
 * Uni test for {@link ClientServiceFactoryHelper}.
 * 
 * @author <a href="http://hoatle.net">hoatle (hoatlevan at gmail dot com)</a>
 * @since Jul 1, 2011
 */
public class ClientServiceFactoryHelperTest {

  @Test
  public void shouldSupportLatest() {
    ClientServiceFactory clientServiceFactory = ClientServiceFactoryHelper.getClientServiceFactory();
    assertThat("clientServiceFactory must not be null", clientServiceFactory, notNullValue());
  }

  @Test
  public void shouldSupportV1Alpha3() {
    SocialClientContext.setRestVersion(SupportedVersion.V1_ALPHA3.toString());
    ClientServiceFactory clientServiceFactory = ClientServiceFactoryHelper.getClientServiceFactory();
    ActivityService activityService = clientServiceFactory.createActivityService();
    assertThat("activityService must be instance of ActivityServiceImplV1Alpha3",
               activityService instanceof ActivityServiceImplV1Alpha3,
               equalTo(true));
    IdentityService identityService = clientServiceFactory.createIdentityService();
    assertThat("identityService must be instance of IdentityServiceImplV1Alpha3",
               identityService instanceof IdentityServiceImplV1Alpha3,
               equalTo(true));

    SpaceService spaceService = null;
    try {
      spaceService = clientServiceFactory.createSpaceService();
    } catch (SocialClientLibException e) {
    }
    assertThat("spaceService must be instance of SpaceServiceImplV1Alpha3",
               spaceService instanceof SpaceServiceImplV1Alpha3,
               equalTo(true));
  }

  @Test
  public void shouldSupportV1Alpha2() {
    SocialClientContext.setRestVersion(SupportedVersion.V1_ALPHA2.toString());
    ClientServiceFactory clientServiceFactory = ClientServiceFactoryHelper.getClientServiceFactory();
    ActivityService activityService = clientServiceFactory.createActivityService();
    assertThat("activityService must be instance of ActivityServiceImplV1Alpha2",
               activityService instanceof ActivityServiceImplV1Alpha2,
               equalTo(true));
    IdentityService identityService = clientServiceFactory.createIdentityService();
    assertThat("identityService must be instance of IdentityServiceImplV1Alpha2",
               identityService instanceof IdentityServiceImplV1Alpha2,
               equalTo(true));

    SpaceService spaceService = null;
    try {
      spaceService = clientServiceFactory.createSpaceService();
    } catch (SocialClientLibException e) {
    }
    assertThat("spaceService must be null because it is not supported in v1-alpha2", spaceService == null, equalTo(true));
  }

  @Test
  public void shouldSupportV1Alpha1() {
    SocialClientContext.setRestVersion(SupportedVersion.V1_ALPHA1.toString());
    ClientServiceFactory clientServiceFactory = ClientServiceFactoryHelper.getClientServiceFactory();
    ActivityService activityService = clientServiceFactory.createActivityService();
    assertThat("activityService must be instance of ActivityServiceImplV1Alpha1",
               activityService instanceof ActivityServiceImplV1Alpha1,
               equalTo(true));
    IdentityService identityService = clientServiceFactory.createIdentityService();
    assertThat("identityService must be instance of IdentityServiceImplV1Alpha1",
               identityService instanceof IdentityServiceImplV1Alpha1,
               equalTo(true));

    SpaceService spaceService = null;
    try {
      spaceService = clientServiceFactory.createSpaceService();
    } catch (SocialClientLibException e) {
    }
    assertThat("spaceService must be null because it is not supported in v1-alpha1", spaceService == null, equalTo(true));
  }

}
