/*
 * Copyright (C) 2003-2011 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.social.client.api.event;

/**
 * Interface defining a listener for significant events (including "model
 * create, update, delete operation) generated by a component that implements
 * the CRUDLifecycle interface.
 * 
 * @author thanh_vucong
 * @param <M> The type which implements Model interface
 */
public interface CRUDLifecycleListener<M> {

  /**
   * Broadcasts the event to the CRUDLifecycleListener.
   * 
   * @param event the event is broadcasted.
   */
  public void broadcast(CRUDLifecycleEvent<M> event);
}
