/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.api;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.exoplatform.social.client.api.UnsupportedRestVersionException;

public class SocialClientContext {
    public static List<String> supportedVersionList = new ArrayList<String>();
    private static String host;
    private static int port;
    private static String protocol;
    private static String portalContainerName;
    private static String restContextName;
    private static String restVersion;
    private static String username;
    private static String password;
    private static boolean isDeveloping;
    private Context currentContext;

    public static String getHost() {
        return host;
    }

    public static void setHost(String newHost) {
        host = newHost;
    }

    public static int getPort() {
        return port;
    }

    public static void setPort(int newPort) {
        port = newPort;
    }

    public static String getPortalContainerName() {
        return portalContainerName;
    }

    public static void setPortalContainerName(String newPortalContainerName) {
        portalContainerName = newPortalContainerName;
    }

    public static String getRestContextName() {
        return restContextName;
    }

    public static void setRestContextName(String newRestContextName) {
        restContextName = newRestContextName;
    }

    public static String getRestVersion() {
        return restVersion;
    }

    public static void setRestVersion(String newRestVersion) throws UnsupportedRestVersionException {
        if (!supportedVersionList.contains(newRestVersion)) {
            throw new UnsupportedRestVersionException(newRestVersion + " is not supported.");
        }
        restVersion = newRestVersion;
    }

    public static String getUsername() {
        return username;
    }

    public static void setUsername(String newUsername) {
        username = newUsername;
    }

    public static String getPassword() {
        return password;
    }

    public static void setPassword(String newPassword) {
        password = newPassword;
    }

    public static String getProtocol() {
        return protocol;
    }

    public static void setProtocol(String protocol) {
        SocialClientContext.protocol = protocol;
    }

    public Context getCurrentContext() {
        return this.currentContext;
    }

    public static boolean isDeveloping() {
        return isDeveloping;
    }

    public static void setIsDeveloping(boolean isDevelopingMode) {
        isDeveloping = isDevelopingMode;
    }

    public void setCurrentContext(Context currentContext) {
        this.currentContext = currentContext;
    }

    static {
        supportedVersionList.add(SupportedVersion.V1_ALPHA3.toString());
        supportedVersionList.add(SupportedVersion.V1_ALPHA2.toString());
        supportedVersionList.add(SupportedVersion.V1_ALPHA1.toString());
        protocol = "http";
        restVersion = supportedVersionList.get(0);
        isDeveloping = false;
    }

    public class Context {
        private HttpRequest request;
        private HttpResponse response;

        public Context(HttpRequest request, HttpResponse response) {
            this.request = request;
            this.response = response;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }
    }

    public static enum SupportedVersion {
        V1_ALPHA3("v1-alpha3"),
        V1_ALPHA2("v1-alpha2"),
        V1_ALPHA1("v1-alpha1");

        private final String version;

        private SupportedVersion(String version) {
            this.version = version;
        }

        public String toString() {
            return this.version;
        }
    }
}

