/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.client.api.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.exoplatform.social.client.api.model.Model;
import org.exoplatform.social.client.api.net.SocialHttpClientException;
import org.exoplatform.social.client.api.util.SocialHttpClientSupport;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class SocialJSONDecodingSupport {
    public static <T extends Model> T parser(final Class<T> clazz, String jsonContent) throws ParseException {
        JSONParser parser = new JSONParser();
        ContainerFactory containerFactory = new ContainerFactory(){

            public List<T> creatArrayContainer() {
                return new LinkedList();
            }

            public T createObjectContainer() {
                try {
                    return (Model)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    return null;
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }
        };
        return (T)((Model)parser.parse(jsonContent, containerFactory));
    }

    public static <T extends Model> T parser(Class<T> clazz, HttpResponse response) throws IOException, ParseException {
        HttpEntity entity = SocialHttpClientSupport.processContent(response);
        if (entity.getContentLength() != -1L) {
            String jsonContent = EntityUtils.toString((HttpEntity)entity);
            SocialHttpClientSupport.consume(entity);
            return SocialJSONDecodingSupport.parser(clazz, jsonContent);
        }
        return null;
    }

    public static Map parser(String jsonContent) throws ParseException {
        JSONParser parser = new JSONParser();
        ContainerFactory containerFactory = new ContainerFactory(){

            public List creatArrayContainer() {
                return new LinkedList();
            }

            public Map createObjectContainer() {
                return new LinkedHashMap();
            }
        };
        return (Map)parser.parse(jsonContent, containerFactory);
    }

    public static Map parser(HttpResponse response) throws ParseException {
        String jsonContent = null;
        try {
            jsonContent = SocialHttpClientSupport.getContent(response);
        }
        catch (SocialHttpClientException e) {
            throw new ParseException(0);
        }
        return SocialJSONDecodingSupport.parser(jsonContent);
    }

    public static <T extends Model> List<T> JSONArrayObjectParser(Class<T> clazz, HttpResponse response) throws IOException, ParseException {
        HttpEntity entity = SocialHttpClientSupport.processContent(response);
        if (entity.getContentLength() != -1L) {
            String jsonContent = EntityUtils.toString((HttpEntity)entity);
            SocialHttpClientSupport.consume(entity);
            return SocialJSONDecodingSupport.JSONArrayObjectParser(clazz, jsonContent);
        }
        return null;
    }

    public static <T extends Model> List<T> JSONArrayObjectParser(Class<T> clazz, String jsonArrayContent) throws IOException, ParseException {
        JSONArray jsonResultArray = (JSONArray)JSONValue.parse((String)jsonArrayContent);
        ArrayList<T> result = new ArrayList<T>();
        for (Object jsonObject : jsonResultArray) {
            String jsonString = jsonObject.toString();
            result.add(SocialJSONDecodingSupport.parser(clazz, jsonString));
        }
        return result;
    }
}

