/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.deprecation;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.deprecation.DeprecatedAPI;
import org.exoplatform.deprecation.DeprecatedAPIException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Aspect
public class DeprecatedAPIAspect {
    private static final Log LOG = ExoLogger.getLogger(DeprecatedAPIAspect.class);
    private static final boolean IS_DEVELOPING = PropertyManager.isDevelopping();
    private static final Map<String, Boolean> LOGGED_METHODS = new ConcurrentHashMap<String, Boolean>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ DeprecatedAPIAspect ajc$perSingletonInstance;

    @Around(value="execution(* *(..)) && @annotation(org.exoplatform.deprecation.DeprecatedAPI)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature;
        if (DeprecatedAPIAspect.IS_DEVELOPING && (signature = (MethodSignature)point.getSignature()) != null) {
            String className = signature.getDeclaringType().getName();
            Method method = signature.getMethod();
            String methodName = method.getName();
            String fullMethodName = className + "#" + methodName;
            DeprecatedAPI annotation = method.getAnnotation(DeprecatedAPI.class);
            String message = annotation.value();
            boolean insist = annotation.insist();
            if (insist || !LOGGED_METHODS.containsKey(fullMethodName)) {
                LOGGED_METHODS.put(fullMethodName, true);
                LOG.warn("'{}#{}' has been deprecated. Please take time to cleanup code.", new Object[]{className, methodName, new DeprecatedAPIException(message, signature.getDeclaringType(), methodName)});
            }
        }
        return point.proceed();
    }

    static {
        try {
            DeprecatedAPIAspect.ajc$perSingletonInstance = new DeprecatedAPIAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static DeprecatedAPIAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("org.exoplatform.deprecation.DeprecatedAPIAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

