/*
 * Copyright (C) 2003-2013 eXo Platform SAS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.exoplatform.social.common.service.utils;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ConsoleUtils {
  
  private static final Log LOG = ExoLogger.getLogger(ConsoleUtils.class);

  public static void consoleProgBar(int percent) {
   
    System.out.print("\n" + process(percent));
  }
  
  public static void logProgBar(int percent) {
    
    LOG.info(process(percent));
  }
  
  private static String process(int percent) {
    StringBuilder bar = new StringBuilder("[");

    for (int i = 0; i < 50; i++) {
      if (i < (percent / 2)) {
        bar.append("=");
      } else if (i == (percent / 2)) {
        bar.append(">");
      } else {
        bar.append(" ");
      }
    }

    bar.append("]   " + percent + "%     ");
    return bar.toString();
  }

}
