/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.utils;

import java.util.concurrent.CountDownLatch;
import org.exoplatform.social.common.service.AsyncCallback;
import org.exoplatform.social.common.service.AsyncProcessor;
import org.exoplatform.social.common.service.ProcessContext;

public class AsyncProcessorTool {
    public static void process(final AsyncProcessor processor, ProcessContext processContext) throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        processor.start(processContext);
        ProcessContext got = processor.process(processContext, new AsyncCallback(){

            @Override
            public void done(ProcessContext processContext) {
                if (!processContext.isFailed()) {
                    latch.countDown();
                }
            }

            public String toString() {
                return "Done " + processor;
            }
        });
        if (got.isInProgress()) {
            latch.await();
        }
        processor.end(processContext);
    }
}

