/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.lifecycle;

import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.container.xml.InitParams;

public class SocialChromatticLifeCycle
extends ChromatticLifeCycle {
    private static final ThreadLocal<ChromatticSession> session = new ThreadLocal();
    private final ThreadLocal providerRoot = new ThreadLocal();
    private final ThreadLocal spaceRoot = new ThreadLocal();
    public static final String SOCIAL_LIFECYCLE_NAME = "soc";

    public ChromatticSession getSession() {
        if (session.get() != null && session.get().getJCRSession().isLive() && !session.get().isClosed()) {
            return session.get();
        }
        try {
            this.onOpenSession(this.openContext());
        }
        catch (IllegalStateException e) {
            this.closeContext(false);
            this.onOpenSession(this.openContext());
        }
        this.providerRoot.set(null);
        this.spaceRoot.set(null);
        return this.getSession();
    }

    public SocialChromatticLifeCycle(InitParams params) {
        super(params);
    }

    protected void onOpenSession(SessionContext context) {
        session.set(context.getSession());
        super.onOpenSession(context);
    }

    protected void onCloseSession(SessionContext context) {
        super.onCloseSession(context);
        session.get().close();
        session.remove();
        this.providerRoot.set(null);
        this.spaceRoot.set(null);
    }

    public ThreadLocal getProviderRoot() {
        return this.providerRoot;
    }

    public ThreadLocal getSpaceRoot() {
        return this.spaceRoot;
    }
}

