/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.social.common.service.utils.TraceElement;

public class TraceList {
    private final Map<String, TraceElement> traceGroups = new ConcurrentHashMap<String, TraceElement>();

    public static TraceList getInstance() {
        return new TraceList();
    }

    public TraceElement addElement(String groupName, String processName) {
        TraceElement parent = null;
        if (this.traceGroups.containsKey(groupName)) {
            parent = this.traceGroups.get(groupName);
        }
        if (parent == null) {
            parent = TraceElement.getInstance(groupName);
        }
        parent.addChild(processName);
        this.traceGroups.put(groupName, parent);
        return parent;
    }

    public int size() {
        return this.traceGroups.size();
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        for (Map.Entry<String, TraceElement> e : this.traceGroups.entrySet()) {
            out.append(e.getValue().toString()).append("::");
        }
        return out.append("\n").toString();
    }

    public String toReport() {
        StringBuffer out = new StringBuffer();
        for (Map.Entry<String, TraceElement> e : this.traceGroups.entrySet()) {
            out.append(e.getValue().toReport()).append("\n");
        }
        return out.toString();
    }
}

