/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityMentionPlugin
extends BaseNotificationPlugin {
    public static final String ID = "ActivityMentionPlugin";

    public ActivityMentionPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        Set<String> receivers = new HashSet<String>();
        if (activity.getMentionedIds().length > 0) {
            Utils.sendToMentioners(receivers, activity.getMentionedIds(), activity.getPosterId());
        } else {
            receivers = Utils.getMentioners((String)activity.getTemplateParams().get("comment"), activity.getPosterId());
        }
        return NotificationInfo.instance().key(this.getKey()).to(new ArrayList<String>(receivers)).with(SocialNotificationUtils.POSTER.getKey(), Utils.getUserId(activity.getPosterId())).with(SocialNotificationUtils.ACTIVITY_ID.getKey(), activity.getId()).end();
    }

    public boolean isValid(NotificationContext ctx) {
        ExoSocialActivity activity = (ExoSocialActivity)ctx.value(SocialNotificationUtils.ACTIVITY);
        if (activity.getMentionedIds().length > 0) {
            return true;
        }
        String commentLinkActivity = (String)activity.getTemplateParams().get("comment");
        return commentLinkActivity != null && commentLinkActivity.length() > 0 && Utils.getMentioners(commentLinkActivity, activity.getPosterId()).size() > 0;
    }
}

