/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class MfaAdminRevocationRequestPlugin
extends BaseNotificationPlugin {
    public static final String ID = "MfaAdminRevocationRequestPlugin";
    private static final Log LOGGER = ExoLogger.getExoLogger(MfaAdminRevocationRequestPlugin.class);
    private OrganizationService organizationService;
    private UserACL userACL;

    public MfaAdminRevocationRequestPlugin(InitParams initParams, OrganizationService organizationService, UserACL userACL) {
        super(initParams);
        this.organizationService = organizationService;
        this.userACL = userACL;
    }

    public String getId() {
        return ID;
    }

    public NotificationInfo makeNotification(NotificationContext ctx) {
        String userId = (String)ctx.value(SocialNotificationUtils.MFA_REVOCATION_REQUEST_REQUESTER);
        try {
            List<String> recipients = this.getRecipients();
            recipients.remove(userId);
            return NotificationInfo.instance().key(this.getId()).with("username", userId).to(recipients);
        }
        catch (Exception e) {
            ctx.setException((Throwable)e);
            return null;
        }
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    private List<String> getRecipients() {
        ArrayList<String> members = new ArrayList<String>();
        try {
            ListAccess administrators = this.organizationService.getUserHandler().findUsersByGroupId(this.userACL.getAdminGroups());
            int totalAdminGroupMembersSize = administrators.getSize();
            User[] users = (User[])administrators.load(0, totalAdminGroupMembersSize);
            return Arrays.stream(users).map(User::getUserName).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error when getting Admin group members");
            return members;
        }
    }
}

