/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel;

import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.TemplateProvider;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.social.notification.AbstractCoreTest;
import org.exoplatform.social.notification.channel.template.WebTemplateProvider;
import org.exoplatform.social.notification.mock.MockWebTemplateProvider;

public class WebTemplateProviderTest
extends AbstractCoreTest {
    private ChannelManager manager;
    private InitParams initParams;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
        this.initParams = new InitParams();
        ValueParam valueParam = new ValueParam();
        valueParam.setName("channel-id");
        valueParam.setValue("WEB_CHANNEL");
        this.initParams.addParameter((Parameter)valueParam);
        this.manager.registerOverrideTemplateProvider((TemplateProvider)new WebTemplateProvider(this.initParams));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.manager.registerOverrideTemplateProvider((TemplateProvider)new MockWebTemplateProvider(this.initParams));
    }

    public void testChannelSize() throws Exception {
        WebTemplateProviderTest.assertTrue((this.manager.sizeChannels() > 0 ? 1 : 0) != 0);
    }

    public void testWebTemplateProvider() throws Exception {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        WebTemplateProviderTest.assertTrue((channel != null ? 1 : 0) != 0);
        String actual = channel.getTemplateFilePath(PluginKey.key((String)"ActivityCommentPlugin"));
        String expected = "war:/intranet-notification/templates/ActivityCommentPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"ActivityReplyToCommentPlugin"));
        expected = "war:/intranet-notification/templates/ActivityReplyToCommentPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"ActivityMentionPlugin"));
        expected = "war:/intranet-notification/templates/ActivityMentionPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"LikePlugin"));
        expected = "war:/intranet-notification/templates/LikePlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"EditCommentPlugin"));
        expected = "war:/intranet-notification/templates/EditCommentPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"EditActivityPlugin"));
        expected = "war:/intranet-notification/templates/EditActivityPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"LikeCommentPlugin"));
        expected = "war:/intranet-notification/templates/LikeCommentPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"NewUserPlugin"));
        expected = "war:/intranet-notification/templates/NewUserPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"PostActivityPlugin"));
        expected = "war:/intranet-notification/templates/PostActivityPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"PostActivitySpaceStreamPlugin"));
        expected = "war:/intranet-notification/templates/PostActivitySpaceStreamPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"RelationshipReceivedRequestPlugin"));
        expected = "war:/intranet-notification/templates/RelationshipReceivedRequestPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"RequestJoinSpacePlugin"));
        expected = "war:/intranet-notification/templates/RequestJoinSpacePlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"SpaceInvitationPlugin"));
        expected = "war:/intranet-notification/templates/SpaceInvitationPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"DlpUserDetectedItemPlugin"));
        expected = "war:/intranet-notification/templates/DlpUserDetectedItemPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"DlpAdminDetectedItemPlugin"));
        expected = "war:/intranet-notification/templates/DlpAdminDetectedItemPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"DlpUserRestoredItemPlugin"));
        expected = "war:/intranet-notification/templates/DlpUserRestoredItemPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
        actual = channel.getTemplateFilePath(PluginKey.key((String)"MalwareDetectionPlugin"));
        expected = "war:/intranet-notification/templates/MalwareDetectionPlugin.gtmpl";
        WebTemplateProviderTest.assertEquals((String)expected, (String)actual);
    }

    public void testWebTemplateBuilder() throws Exception {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        WebTemplateProviderTest.assertTrue((channel != null ? 1 : 0) != 0);
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityCommentPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityReplyToCommentPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"ActivityMentionPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"LikePlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"EditCommentPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"EditActivityPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"NewUserPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"PostActivityPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"PostActivitySpaceStreamPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"RelationshipReceivedRequestPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"RequestJoinSpacePlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"SpaceInvitationPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"DlpUserDetectedItemPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"DlpAdminDetectedItemPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"DlpUserRestoredItemPlugin")));
        WebTemplateProviderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"MalwareDetectionPlugin")));
    }
}

