/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.notification.AbstractPluginTest;

public class MalwareDetectionWebBuilderTest
extends AbstractPluginTest {
    public static final String INFECTED_ITEM_NAME = "infectedItemName";
    public static final ArgumentLiteral<String> INFECTED_ITEM_NAME_ARGUMENT = new ArgumentLiteral(String.class, "infectedItemName");
    public static final String INFECTED_ITEM_LAST_MODIFIER = "infectedItemLastModifier";
    public static final ArgumentLiteral<String> INFECTED_ITEM_LAST_MODIFIER_ARGUMENT = new ArgumentLiteral(String.class, "infectedItemLastModifier");
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        MalwareDetectionWebBuilderTest.assertNotNull((Object)channel);
        MalwareDetectionWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"MalwareDetectionPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"MalwareDetectionPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"MalwareDetectionPlugin"));
    }

    public void testSimpleCase() {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(INFECTED_ITEM_NAME_ARGUMENT, (Object)"test.docx");
        ctx.append(INFECTED_ITEM_LAST_MODIFIER_ARGUMENT, (Object)this.maryIdentity.getRemoteId());
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"MalwareDetectionPlugin"))).execute(ctx);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.maryIdentity.getRemoteId(), 1);
        ctx.setNotificationInfo(list.get(0).setTo(this.rootIdentity.getRemoteId()));
        MessageInfo message = this.buildMessageInfo(ctx);
        this.assertBody(message, "has been detected as a malware. So the file is no longer available.");
        this.notificationService.clearAll();
    }
}

