/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification;

import java.util.HashMap;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.notification.AbstractCoreTest;
import org.exoplatform.social.notification.LinkProviderUtils;

public class LinkProviderUtilsTest
extends AbstractCoreTest {
    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testGetInviteToConnectUrl() {
        String receiverId = "demo";
        String senderId = "root";
        String expected = "http://exoplatform.com/rest/social/notifications/inviteToConnect/demo/root";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getInviteToConnectUrl((String)receiverId, (String)senderId));
    }

    public void testGetConfirmInvitationToConnectUrl() {
        String receiverId = "demo";
        String senderId = "root";
        String expected = "http://exoplatform.com/portal/login?initialURI=/portal/rest/social/notifications/confirmInvitationToConnect/root/demo";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getConfirmInvitationToConnectUrl((String)senderId, (String)receiverId));
    }

    public void testGetIgnoreInvitationToConnectUrl() {
        String receiverId = "demo";
        String senderId = "root";
        String expected = "http://exoplatform.com/portal/login?initialURI=/portal/rest/social/notifications/ignoreInvitationToConnect/root/demo";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getIgnoreInvitationToConnectUrl((String)senderId, (String)receiverId));
    }

    public void testGetAcceptInvitationToJoinSpaceUrl() {
        String spaceId = "5fc9eef07f000101";
        String userId = "root";
        String expected = "http://exoplatform.com/portal/login?initialURI=/portal/rest/social/notifications/acceptInvitationToJoinSpace/5fc9eef07f000101/root";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getAcceptInvitationToJoinSpaceUrl((String)spaceId, (String)userId));
    }

    public void testGetIgnoreInvitationToJoinSpaceUrl() {
        String spaceId = "5fc9eef07f000101";
        String userId = "root";
        String expected = "http://exoplatform.com/portal/login?initialURI=/portal/rest/social/notifications/ignoreInvitationToJoinSpace/5fc9eef07f000101/root";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getIgnoreInvitationToJoinSpaceUrl((String)spaceId, (String)userId));
    }

    public void testGetValidateRequestToJoinSpaceUrl() {
        String spaceId = "5fc9eef07f000101";
        String userId = "root";
        String expected = "http://exoplatform.com/portal/login?initialURI=/portal/rest/social/notifications/validateRequestToJoinSpace/5fc9eef07f000101/root";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getValidateRequestToJoinSpaceUrl((String)spaceId, (String)userId));
    }

    public void testGetRefuseRequestToJoinSpaceUrl() {
        String spaceId = "5fc9eef07f000101";
        String userId = "root";
        String expected = "http://exoplatform.com/portal/login?initialURI=/portal/rest/social/notifications/refuseRequestToJoinSpace/5fc9eef07f000101/root";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getRefuseRequestToJoinSpaceUrl((String)spaceId, (String)userId));
    }

    public void testGetRedirectUrl() {
        String type = "activity";
        String objectId = "5fc9eef07f000101";
        String expected = "http://exoplatform.com/rest/social/notifications/redirectUrl/activity/5fc9eef07f000101";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getRedirectUrl((String)type, (String)objectId));
    }

    public void testGetRestUrl() {
        String objectId1 = "openspace";
        String objectId2 = "spaceId";
        String expected = "http://exoplatform.com/rest/social/openspace/spaceId";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getRestUrl((String)"social", (String)objectId1, (String)objectId2));
    }

    public void testGetBaseRestUrl() {
        LinkProviderUtilsTest.assertEquals((String)"http://exoplatform.com/rest", (String)LinkProviderUtils.getBaseRestUrl());
    }

    public void testGetUserAvatarUrl() {
        LinkProviderUtilsTest.assertEquals((String)"http://exoplatform.com/eXoSkin/skin/images/avatar/DefaultUserAvatar.png", (String)LinkProviderUtils.getUserAvatarUrl(null));
        Profile profile = new Profile(new Identity("demo"));
        profile.setAvatarUrl("/rest/social/user/avatar/demo");
        String expected = "http://exoplatform.com/rest/social/user/avatar/demo";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getUserAvatarUrl((Profile)profile));
    }

    public void testGetSpaceAvatarUrl() {
        String expected = "http://exoplatform.com/eXoSkin/skin/images/system/SpaceAvtDefault.png";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getSpaceAvatarUrl(null));
        Space space = new Space();
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getSpaceAvatarUrl((Space)space));
        space.setAvatarUrl("/rest/social/space/avatar/space_test");
        expected = "http://exoplatform.com/rest/social/space/avatar/space_test";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getSpaceAvatarUrl((Space)space));
    }

    public void testGetOpenLinkAnswer() {
        String expected = "http://exoplatform.com/intranet/answers?questionId=test";
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("question");
        activity.setUserId(this.rootIdentity.getId());
        activity.setType("ks-answer:spaces");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Link", expected);
        activity.setTemplateParams(params);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add(activity);
        ExoSocialActivityImpl comment1 = new ExoSocialActivityImpl();
        comment1.setTitle("comment1");
        comment1.setUserId(this.rootIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment1);
        String openUrl1 = LinkProviderUtils.getOpenLink((ExoSocialActivity)comment1);
        LinkProviderUtilsTest.assertEquals((String)expected, (String)openUrl1);
        ExoSocialActivityImpl comment2 = new ExoSocialActivityImpl();
        comment2.setTitle("comment2");
        comment2.setType("ks-answer:spaces");
        comment2.setUserId(this.rootIdentity.getId());
        this.activityManager.saveComment((ExoSocialActivity)activity, (ExoSocialActivity)comment2);
        String openUrl2 = LinkProviderUtils.getOpenLink((ExoSocialActivity)comment2);
        LinkProviderUtilsTest.assertEquals((String)expected, (String)openUrl2);
    }

    public void testGetWebNotificationRestUrl() {
        String object1 = "demo";
        String object2 = "root";
        String expected = "/rest/notification/demo/root";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getWebNotificationRestUrl((String)"notification", (String)object1, (String)object2));
    }

    public void testGetWebNotificationRestUrlWithJsonFile() {
        String object1 = "demo";
        String object2 = "root";
        String notifificationId = "12";
        String jsonFile = "jsonFile";
        String expected = "/rest/notification/demo/root/12/jsonFile";
        LinkProviderUtilsTest.assertEquals((String)expected, (String)LinkProviderUtils.getWebNotificationRestUrl((String)"notification", (String)object1, (String)object2, (String)notifificationId, (String)jsonFile));
    }
}

