/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.channel.template;

import java.io.StringWriter;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.notification.AbstractPluginTest;

public class LikeMailBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"MAIL_CHANNEL"));
        LikeMailBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        LikeMailBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"LikePlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"LikePlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"LikePlugin"));
    }

    public void testSimpleCase() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        this.activityManager.saveLike(activity, this.demoIdentity);
        this.assertMadeMailDigestNotifications(1);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo likeNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(likeNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, this.getFullName("demo") + " likes one of your activities");
        this.assertBody(info, "New like on your activity stream");
    }

    public void testDigest() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        this.activityManager.saveLike(activity, this.maryIdentity);
        this.activityManager.saveLike(activity, this.demoIdentity);
        this.activityManager.saveLike(activity, this.johnIdentity);
        this.assertMadeMailDigestNotifications(3);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 3);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("mary") + ", " + this.getFullName("demo") + ", " + this.getFullName("john") + " like your activity: root post an activity");
    }

    public void testLikeLinkActivity() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("Link Activity");
        activity.setType("LINK_ACTIVITY");
        LinkedHashMap<String, String> tempParams = new LinkedHashMap<String, String>();
        tempParams.put("link", "link");
        tempParams.put("title", "link title");
        tempParams.put("comment", "message activity");
        tempParams.put("description", "description of activity");
        activity.setTemplateParams(tempParams);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        this.tearDownActivityList.add(activity);
        this.activityManager.saveLike((ExoSocialActivity)activity, this.maryIdentity);
        this.assertMadeMailDigestNotifications(1);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo likeNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(likeNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertSubject(info, this.getFullName("mary") + " likes one of your activities");
        this.assertBody(info, "New like on your activity stream");
        this.assertBody(info, "link title");
        this.assertBody(info, "message activity");
        this.assertBody(info, "description of activity");
    }

    public void testDigestWithUnLike() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        this.notificationService.clearAll();
        this.assertMadeMailDigestNotifications(0);
        List<NotificationInfo> list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 0);
        this.activityManager.saveLike(activity, this.demoIdentity);
        this.activityManager.saveLike(activity, this.johnIdentity);
        this.assertMadeMailDigestNotifications(2);
        list = this.assertMadeMailDigestNotifications(this.rootIdentity.getRemoteId(), 2);
        this.activityManager.deleteLike(activity, this.johnIdentity);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        list.set(0, list.get(0).setTo(this.rootIdentity.getRemoteId()));
        ctx.setNotificationInfos(list);
        StringWriter writer = new StringWriter();
        this.buildDigest(ctx, writer);
        this.assertDigest(writer, this.getFullName("demo") + " likes your activity: root post an activity");
    }
}

