/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.exoplatform.social.notification.impl.SpaceWebNotificationServiceImpl;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.plugin.SpaceWebNotificationPlugin;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SpaceWebNotificationServiceTest {
    private static final String METADATA_TYPE_NAME = "unread";
    private static final String activityId = "activityId";
    private static final String METADATA_OBJECT_TYPE = "activity";
    private static final long userIdentityId = 15L;
    private static final long spaceId = 12L;
    @Mock
    private MetadataService metadataService;
    @Mock
    private ListenerService listenerService;
    @Mock
    private PluginSettingService pluginSettingService;
    private static SpaceWebNotificationServiceImpl spaceWebNotificationService;

    @Before
    public void setUp() throws Exception {
        spaceWebNotificationService = new SpaceWebNotificationServiceImpl(PortalContainer.getInstance(), this.metadataService, this.pluginSettingService, this.listenerService);
    }

    @Test
    public void testMarkAsUnread() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(null));
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 12L);
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(15L), 15L);
        MetadataObject metadataObject = new MetadataObject(METADATA_OBJECT_TYPE, activityId, null, 12L);
        spaceWebNotificationService = new SpaceWebNotificationServiceImpl(PortalContainer.getInstance(), this.metadataService, this.pluginSettingService, this.listenerService);
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(null));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(new SpaceWebNotificationItem(null, "itemId", 15L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(new SpaceWebNotificationItem("appName", null, 15L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(new SpaceWebNotificationItem("appName", "itemId", 0L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsUnread(new SpaceWebNotificationItem("appName", "itemId", 15L, 0L)));
        spaceWebNotificationService.markAsUnread(spaceWebNotificationItem);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.eq((Object)metadataObject), (MetadataKey)ArgumentMatchers.eq((Object)metadataKey), (Map)ArgumentMatchers.any(), ArgumentMatchers.eq((long)15L));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.unread.item", (Object)spaceWebNotificationItem, (Object)15L);
    }

    @Test
    public void testDispatchNotification() throws Exception {
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 0L);
        SpaceWebNotificationPlugin spaceWebNotificationPlugin = (SpaceWebNotificationPlugin)Mockito.mock(SpaceWebNotificationPlugin.class);
        spaceWebNotificationService.addPlugin(spaceWebNotificationPlugin);
        String username = "testuser";
        NotificationInfo notificationInfo = (NotificationInfo)Mockito.mock(NotificationInfo.class);
        BaseNotificationPlugin notificationPlugin = (BaseNotificationPlugin)Mockito.mock(BaseNotificationPlugin.class);
        Mockito.when((Object)notificationPlugin.getId()).thenReturn((Object)"notificationPlugin");
        PluginKey pluginKey = new PluginKey(notificationPlugin);
        Mockito.when((Object)notificationInfo.getKey()).thenReturn((Object)pluginKey);
        Mockito.when((Object)spaceWebNotificationPlugin.getSpaceApplicationItem(notificationInfo, username)).thenReturn((Object)spaceWebNotificationItem);
        Mockito.when((Object)spaceWebNotificationPlugin.isManagedPlugin(pluginKey)).thenReturn((Object)true);
        spaceWebNotificationService.dispatch(notificationInfo, username);
        ((SpaceWebNotificationPlugin)Mockito.verify((Object)spaceWebNotificationPlugin, (VerificationMode)Mockito.times((int)1))).getSpaceApplicationItem(notificationInfo, username);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadataService, this.listenerService});
        spaceWebNotificationItem.setSpaceId(12L);
        spaceWebNotificationService.dispatch(notificationInfo, username);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.any(), (MetadataKey)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.unread.item", (Object)spaceWebNotificationItem, (Object)15L);
    }

    @Test
    public void testMarkAsUnreadWithSubItems() throws Exception {
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 12L);
        final String itemId1 = "subItem1";
        spaceWebNotificationItem.addApplicationSubItem(itemId1);
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(15L), 15L);
        MetadataObject metadataObject = new MetadataObject(METADATA_OBJECT_TYPE, activityId, null, 12L);
        spaceWebNotificationService.markAsUnread(spaceWebNotificationItem);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.eq((Object)metadataObject), (MetadataKey)ArgumentMatchers.eq((Object)metadataKey), (Map)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Map<String, String>>(){

            public boolean matches(Map<String, String> properties) {
                return properties != null && properties.size() == 1 && itemId1.equals(properties.values().iterator().next());
            }
        }), ArgumentMatchers.eq((long)15L));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.unread.item", (Object)spaceWebNotificationItem, (Object)15L);
    }

    @Test
    public void testMarkAsUnreadWithExistingSubItems() throws Exception {
        final String itemId1 = "subItem1";
        Map<String, String> properties = Collections.singletonMap("applicationSubItemIds", itemId1);
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(15L), 15L);
        MetadataObject metadataObject = new MetadataObject(METADATA_OBJECT_TYPE, activityId, null, 12L);
        MetadataItem metadataItem = new MetadataItem(1L, this.newMetadata(), metadataObject, 15L, 12L, properties);
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject)).thenReturn(Collections.singletonList(metadataItem));
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 12L);
        final String itemId2 = "subItem2";
        spaceWebNotificationItem.addApplicationSubItem(itemId2);
        spaceWebNotificationService.markAsUnread(spaceWebNotificationItem);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).createMetadataItem((MetadataObject)ArgumentMatchers.eq((Object)metadataObject), (MetadataKey)ArgumentMatchers.eq((Object)metadataKey), (Map)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Map<String, String>>(){

            public boolean matches(Map<String, String> properties) {
                return properties != null && properties.size() == 1 && (itemId1 + "," + itemId2).equals(properties.values().iterator().next());
            }
        }), ArgumentMatchers.eq((long)15L));
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.unread.item", (Object)spaceWebNotificationItem, (Object)15L);
    }

    private Metadata newMetadata() {
        return new Metadata(7L, new MetadataType(6L, METADATA_TYPE_NAME), METADATA_OBJECT_TYPE, 12L, 15L, System.currentTimeMillis(), null);
    }

    @Test
    public void testMarkAllAsRead() throws Exception {
        spaceWebNotificationService.markAllAsRead(15L, 12L);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).deleteByMetadataTypeAndSpaceIdAndCreatorId(METADATA_TYPE_NAME, 12L, 15L);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.read.allItems", (Object)new SpaceWebNotificationItem(null, null, 15L, 12L), (Object)15L);
    }

    @Test
    public void testCountUnreadItemsByApplication() throws Exception {
        Map<String, Long> expectedResult = Collections.singletonMap(METADATA_OBJECT_TYPE, 5L);
        Mockito.when((Object)this.metadataService.countMetadataItemsByMetadataTypeAndAudienceId(METADATA_TYPE_NAME, 15L, 12L)).thenReturn(expectedResult);
        Map result = spaceWebNotificationService.countUnreadItemsByApplication(15L, 12L);
        Assert.assertEquals(expectedResult, (Object)result);
    }

    @Test
    public void testMarkAsRead() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(null));
        SpaceWebNotificationItem spaceWebNotificationItem = new SpaceWebNotificationItem(METADATA_OBJECT_TYPE, activityId, 15L, 12L);
        MetadataKey metadataKey = new MetadataKey(METADATA_TYPE_NAME, String.valueOf(15L), 15L);
        MetadataObject metadataObject = new MetadataObject(METADATA_OBJECT_TYPE, activityId, null, 12L);
        Metadata metadata = this.newMetadata();
        long metadataItemId = 5L;
        Mockito.when((Object)this.metadataService.getMetadataItemsByMetadataAndObject(metadataKey, metadataObject)).thenReturn(Arrays.asList(new MetadataItem(metadataItemId, metadata, metadataObject, 15L, System.currentTimeMillis(), null)));
        spaceWebNotificationService = new SpaceWebNotificationServiceImpl(PortalContainer.getInstance(), this.metadataService, this.pluginSettingService, this.listenerService);
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(null));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(new SpaceWebNotificationItem(null, "itemId", 15L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(new SpaceWebNotificationItem("appName", null, 15L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(new SpaceWebNotificationItem("appName", "itemId", 0L, 12L)));
        Assert.assertThrows(IllegalArgumentException.class, () -> spaceWebNotificationService.markAsRead(new SpaceWebNotificationItem("appName", "itemId", 15L, 0L)));
        spaceWebNotificationService.markAsRead(spaceWebNotificationItem);
        ((MetadataService)Mockito.verify((Object)this.metadataService, (VerificationMode)Mockito.times((int)1))).deleteMetadataItem(metadataItemId, true);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("notification.read.item", (Object)spaceWebNotificationItem, (Object)15L);
    }
}

