/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class ActivityCommentReplyWebBuilderTest
extends AbstractPluginTest {
    private static final String ACTIVITY_TITLE = "my activity title post today.";
    private static final String COMMENT_TITLE = "my comment title add today.";
    private static final String SUB_COMMENT_TITLE = "my comment reply title add today.";

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        return null;
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"ActivityReplyToCommentPlugin"));
    }

    public void testSimpleCase() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.maryIdentity, ACTIVITY_TITLE);
        this.assertMadeWebNotifications(1);
        this.notificationService.clearAll();
        ExoSocialActivity comment = this.makeComment(activity, this.rootIdentity, COMMENT_TITLE);
        this.makeCommentReply(activity, this.demoIdentity, SUB_COMMENT_TITLE, comment.getId());
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo commentReplyNotification = list.get(0);
        ActivityCommentReplyWebBuilderTest.assertEquals((String)"ActivityReplyToCommentPlugin", (String)commentReplyNotification.getKey().getId());
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(commentReplyNotification.setTo(this.rootIdentity.getRemoteId()));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, ACTIVITY_TITLE);
        this.assertBody(info, "New reply on your comment");
    }
}

