/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.notification.AbstractPluginTest;

public class PostActivityWebBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        PostActivityWebBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        PostActivityWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"PostActivityPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"PostActivityPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"PostActivityPlugin"));
    }

    public void testSimpleCase() throws Exception {
        this.makeActivity(this.demoIdentity, "demo post activity on activity stream of root");
        this.assertMadeWebNotifications(1);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo postActivityNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(postActivityNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "has posted on your activity stream");
    }
}

