/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.web.template;

import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.channel.template.AbstractTemplateBuilder;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.notification.AbstractPluginTest;

public class EditCommentWebBuilderTest
extends AbstractPluginTest {
    private ChannelManager manager;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.manager = this.getService(ChannelManager.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    public AbstractTemplateBuilder getTemplateBuilder() {
        AbstractChannel channel = this.manager.getChannel(ChannelKey.key((String)"WEB_CHANNEL"));
        EditCommentWebBuilderTest.assertTrue((channel != null ? 1 : 0) != 0);
        EditCommentWebBuilderTest.assertTrue((boolean)channel.hasTemplateBuilder(PluginKey.key((String)"EditCommentPlugin")));
        return channel.getTemplateBuilder(PluginKey.key((String)"EditCommentPlugin"));
    }

    @Override
    public BaseNotificationPlugin getPlugin() {
        return this.pluginService.getPlugin(PluginKey.key((String)"EditCommentPlugin"));
    }

    public void testEditComment() throws Exception {
        ExoSocialActivity activity = this.makeActivity(this.rootIdentity, "root post an activity");
        ExoSocialActivity comment = this.makeComment(activity, this.demoIdentity, "comment");
        comment.setTitle("edited comment");
        this.activityManager.saveComment(activity, comment);
        this.assertMadeWebNotifications(1);
        List<NotificationInfo> list = this.assertMadeWebNotifications(this.rootIdentity.getRemoteId(), 1);
        NotificationInfo editNotification = list.get(0);
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(editNotification.setTo("root"));
        MessageInfo info = this.buildMessageInfo(ctx);
        this.assertBody(info, "edited comment");
        this.assertBody(info, "data-link=\"/portal/classic/activity?id=" + activity.getId() + "#comment-" + comment.getId() + "\"");
    }
}

