/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.notification.net.WebNotificationSender;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.relationship.RelationshipEvent;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class RelationshipNotificationImpl
extends RelationshipListenerPlugin {
    private WebNotificationService webNotificationService;
    private static final Log LOG = ExoLogger.getLogger(RelationshipNotificationImpl.class);

    public void confirmed(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        String receiverId = relationship.getReceiver().getRemoteId();
        String senderId = relationship.getSender().getRemoteId();
        this.markAllInvitationNotificationsAsAccepted(senderId, receiverId);
    }

    public void requested(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        try {
            NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.RELATIONSHIP, (Object)relationship);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"RelationshipReceivedRequestPlugin"))).execute(ctx);
        }
        catch (Exception e) {
            LOG.warn((Object)("Failed to get invite to connect information of " + String.valueOf(event) + ": " + e.getMessage()));
        }
    }

    public void denied(RelationshipEvent event) {
        Relationship relationship = (Relationship)event.getPayload();
        String receiverId = relationship.getReceiver().getRemoteId();
        String senderId = relationship.getSender().getRemoteId();
        this.removeAllDeniedInvitationsNotifications(senderId, receiverId);
    }

    private void markAllInvitationNotificationsAsAccepted(String senderId, String receiverId) {
        WebNotificationFilter webNotificationFilter = new WebNotificationFilter(receiverId);
        webNotificationFilter.setParameter("sender", senderId);
        webNotificationFilter.setPluginKey(new PluginKey("RelationshipReceivedRequestPlugin"));
        List webNotifs = this.getWebNotificationService().getNotificationInfos(webNotificationFilter, 0, -1);
        NotificationInfo info = (NotificationInfo)webNotifs.get(0);
        info.setRead(true);
        info.setOwnerParameter(new HashMap(info.getOwnerParameter()));
        info.getOwnerParameter().put("status", "accepted");
        this.updateNotification(info);
        webNotifs.remove(0);
        for (NotificationInfo notificationInfo : webNotifs) {
            this.getWebNotificationService().remove(notificationInfo.getId());
        }
    }

    private void removeAllDeniedInvitationsNotifications(String senderId, String receiverId) {
        WebNotificationFilter webNotificationFilter = new WebNotificationFilter(receiverId);
        webNotificationFilter.setParameter("sender", senderId);
        PluginKey pluginKey = new PluginKey("RelationshipReceivedRequestPlugin");
        webNotificationFilter.setPluginKey(pluginKey);
        List webNotifs = this.getWebNotificationService().getNotificationInfos(webNotificationFilter, 0, -1);
        for (NotificationInfo notificationInfo : webNotifs) {
            this.getWebNotificationService().remove(notificationInfo.getId());
        }
    }

    private WebNotificationService getWebNotificationService() {
        if (this.webNotificationService == null) {
            this.webNotificationService = (WebNotificationService)CommonsUtils.getService(WebNotificationService.class);
        }
        return this.webNotificationService;
    }

    private void updateNotification(NotificationInfo notification) {
        NotificationContext nCtx = NotificationContextImpl.cloneInstance().setNotificationInfo(notification);
        BaseNotificationPlugin plugin = nCtx.getPluginContainer().getPlugin(notification.getKey());
        if (plugin != null) {
            try {
                notification.setRead(false);
                notification.setOnPopOver(true);
                this.getWebNotificationService().save(notification);
                WebNotificationSender.sendJsonMessage((String)notification.getTo(), (MessageInfo)new MessageInfo());
            }
            catch (Exception e) {
                LOG.error("Can not update relationship notification.", new Object[]{e.getMessage()});
            }
        }
    }
}

