/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.plugin.child;

import java.util.Locale;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.AbstractNotificationChildPlugin;
import org.exoplatform.commons.api.notification.service.template.TemplateContext;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.utils.MentionUtils;
import org.exoplatform.social.notification.Utils;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class DefaultActivityChildPlugin
extends AbstractNotificationChildPlugin {
    public static final String ID = "DEFAULT_ACTIVITY";

    public DefaultActivityChildPlugin(InitParams initParams) {
        super(initParams);
    }

    public String makeContent(NotificationContext ctx) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String language = this.getLanguage(notification);
        TemplateContext templateContext = new TemplateContext(ID, language);
        String activityId = notification.getValueOwnerParameter(SocialNotificationUtils.ACTIVITY_ID.getKey());
        ExoSocialActivity activity = Utils.getActivityManager().getActivity(activityId);
        if (activity.isComment()) {
            activity = Utils.getActivityManager().getParentActivity(activity);
        }
        templateContext.put((Object)"ACTIVITY", (Object)this.processBody(Utils.getActivityManager().getActivityTitle(activity), language));
        return TemplateUtils.processGroovy((TemplateContext)templateContext);
    }

    public String getId() {
        return ID;
    }

    public boolean isValid(NotificationContext ctx) {
        return false;
    }

    private String processBody(String message, String language) {
        message = MentionUtils.substituteRoleWithLocale((String)message, (Locale)Locale.forLanguageTag(language));
        return NotificationUtils.processLinkTitle((String)message);
    }
}

