/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.map.HashedMap;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.SpaceListAccess;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.SpaceRest;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.RouterConfigException;
import org.exoplatform.web.controller.router.URIWriter;

@Path(value="{portalName}/social/spaces")
public class SpacesRestService
implements ResourceContainer {
    private SpaceService _spaceService;
    private IdentityManager _identityManager;
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String PENDING_STATUS = "pending";
    private static final String INCOMING_STATUS = "incoming";
    private static final String ALL_SPACES_STATUS = "all_spaces";
    private String portalContainerName;
    private static final QualifiedName PATH = QualifiedName.create((String)"gtn", (String)"path");
    private static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    private static final QualifiedName REQUEST_SITE_TYPE = QualifiedName.create((String)"gtn", (String)"sitetype");
    private static final QualifiedName REQUEST_HANDLER = QualifiedName.create((String)"gtn", (String)"handler");
    private static final QualifiedName REQUEST_SITE_NAME = QualifiedName.create((String)"gtn", (String)"sitename");

    private SpaceList showMySpaceList(String userId) {
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        List mySpaces = null;
        ArrayList<SpaceRest> mySpacesRest = new ArrayList<SpaceRest>();
        try {
            mySpaces = this._spaceService.getSpaces(userId);
            for (Space space : mySpaces) {
                SpaceRest spaceRest = new SpaceRest(space);
                mySpacesRest.add(spaceRest);
            }
            Router router = this.getRouter(this.getConfigurationPath());
            this.fillSpacesURI(mySpacesRest, router);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(mySpacesRest);
        return spaceList;
    }

    private SpaceList showPendingSpaceList(String userId) {
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        ArrayList<SpaceRest> pendingSpacesRest = new ArrayList<SpaceRest>();
        try {
            List pendingSpaces = this._spaceService.getPendingSpaces(userId);
            for (Space space : pendingSpaces) {
                SpaceRest spaceRest = new SpaceRest(space);
                pendingSpacesRest.add(spaceRest);
            }
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(pendingSpacesRest);
        return spaceList;
    }

    private void fillUrlAllSpaces(SpaceList spaceList, String portalOwner) {
        try {
            Router router = this.getRouter(this.getConfigurationPath());
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put(REQUEST_HANDLER, "portal");
            qualifiedName.put(REQUEST_SITE_TYPE, "portal");
            qualifiedName.put(LANG, "");
            StringBuilder urlBuilder = new StringBuilder();
            UserPortalConfig userPortalConfig = SpaceUtils.getUserPortalConfig();
            qualifiedName.put(REQUEST_SITE_NAME, userPortalConfig.getPortalName());
            if (portalOwner.equals("socialdemo")) {
                qualifiedName.put(PATH, "all-spaces");
            } else {
                qualifiedName.put(PATH, "spaces");
            }
            router.render((Map)qualifiedName, new URIWriter((Appendable)urlBuilder));
            spaceList.setMoreSpacesUrl(urlBuilder.toString());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="mySpaces/show.{format}")
    public Response showMySpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        Identity identity;
        MediaType mediaType = Util.getMediaType(format);
        ConversationState state = ConversationState.getCurrent();
        this.portalContainerName = portalName;
        String userId = null;
        if (state != null) {
            userId = state.getIdentity().getUserId();
        }
        if ((identity = this.getIdentityManager().getOrCreateIdentity("organization", userId, false)) == null) {
            userId = Util.getViewerId(uriInfo);
        }
        SpaceList mySpaceList = this.showMySpaceList(userId);
        this.fillUrlAllSpaces(mySpaceList, portalName);
        return Util.getResponse(mySpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="pendingSpaces/show.{format}")
    public Response showPendingSpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        this.portalContainerName = portalName;
        if (!userId.equals(Util.getViewerId(uriInfo))) {
            return null;
        }
        SpaceList pendingSpaceList = this.showPendingSpaceList(userId);
        return Util.getResponse(pendingSpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="suggest.{format}")
    public Response suggestSpacenames(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @QueryParam(value="conditionToSearch") String conditionToSearch, @QueryParam(value="typeOfRelation") String typeOfRelation, @QueryParam(value="currentUser") String userId, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        SpaceNameList nameList = new SpaceNameList();
        this.portalContainerName = portalName;
        SpaceService spaceSrv = this.getSpaceService();
        SpaceListAccess listAccess = spaceSrv.getVisibleSpacesWithListAccess(userId, new SpaceFilter(conditionToSearch));
        List<Space> spaces = Arrays.asList(listAccess.load(0, 10));
        for (Space space : spaces) {
            if (ALL_SPACES_STATUS.equals(typeOfRelation)) {
                nameList.addName(space.getDisplayName());
                continue;
            }
            if (PENDING_STATUS.equals(typeOfRelation) && spaceSrv.isPending(space, userId)) {
                nameList.addName(space.getDisplayName());
                continue;
            }
            if (INCOMING_STATUS.equals(typeOfRelation) && spaceSrv.isInvited(space, userId)) {
                nameList.addName(space.getDisplayName());
                continue;
            }
            if (!CONFIRMED_STATUS.equals(typeOfRelation) || !spaceSrv.isMember(space, userId)) continue;
            nameList.addName(space.getDisplayName());
        }
        return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
    }

    private SpaceService getSpaceService() {
        return (SpaceService)this.getPortalContainer().getComponentInstanceOfType(SpaceService.class);
    }

    private IdentityManager getIdentityManager() {
        if (this._identityManager == null) {
            this._identityManager = (IdentityManager)this.getPortalContainer().getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    private PortalContainer getPortalContainer() {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalContainerName);
    }

    private void fillSpacesURI(List<SpaceRest> mySpaces, Router router) {
        try {
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put(REQUEST_HANDLER, "portal");
            qualifiedName.put(REQUEST_SITE_TYPE, "group");
            for (SpaceRest space : mySpaces) {
                StringBuilder urlBuilder = new StringBuilder();
                qualifiedName.put(REQUEST_SITE_NAME, space.getGroupId());
                qualifiedName.put(PATH, space.getUrl());
                router.render((Map)qualifiedName, new URIWriter((Appendable)urlBuilder));
                space.setSpaceUrl(urlBuilder.toString());
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getConfigurationPath() {
        PortalContainer portalContainer = this.getPortalContainer();
        WebAppController webAppController = (WebAppController)portalContainer.getComponentInstanceOfType(WebAppController.class);
        return webAppController.getConfigurationPath();
    }

    private Router getRouter(String path) throws IOException, RouterConfigException {
        File f = new File(path);
        if (!f.exists()) {
            throw new MalformedURLException("Could not resolve path " + path);
        }
        if (!f.isFile()) {
            throw new MalformedURLException("Could not resolve path " + path + " to a valid file");
        }
        return this.getRouter(f.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Router getRouter(URL url) throws RouterConfigException, IOException {
        InputStream in = url.openStream();
        try {
            ControllerDescriptor routerDesc = new DescriptorBuilder().build(in);
            Router router = new Router(routerDesc);
            return router;
        }
        finally {
            Safe.close((Closeable)in);
        }
    }

    @XmlRootElement
    public static class SpaceNameList {
        private List<String> _names;

        public void setNames(List<String> names) {
            this._names = names;
        }

        public List<String> getNames() {
            return this._names;
        }

        public void addName(String name) {
            if (this._names == null) {
                this._names = new ArrayList<String>();
            }
            this._names.add(name);
        }
    }

    @XmlRootElement
    public static class SpaceList {
        private String moreSpacesUrl;
        private List<SpaceRest> _spaces;

        public void setSpaces(List<SpaceRest> spaces) {
            this._spaces = spaces;
        }

        public List<SpaceRest> getSpaces() {
            return this._spaces;
        }

        public void addSpace(SpaceRest space) {
            if (this._spaces == null) {
                this._spaces = new ArrayList<SpaceRest>();
            }
            this._spaces.add(space);
        }

        public String getMoreSpacesUrl() {
            return this.moreSpacesUrl;
        }

        public void setMoreSpacesUrl(String allSpacesUrl) {
            this.moreSpacesUrl = allSpacesUrl;
        }
    }
}

