/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.api;

import org.exoplatform.services.rest.impl.ApplicationContextImpl;

public abstract class AbstractSocialRestService {
    public static final int DEFAULT_LIMIT = 20;
    public static final int HARD_LIMIT = 50;

    protected String getPathParam(String name) {
        return (String)ApplicationContextImpl.getCurrent().getPathParameters().getFirst((Object)name);
    }

    protected String getQueryParam(String name) {
        return (String)ApplicationContextImpl.getCurrent().getQueryParameters().getFirst((Object)name);
    }

    protected int getQueryValueLimit() {
        Integer limit = this.getIntegerValue("limit");
        return limit != null && limit > 0 ? Math.min(50, limit) : 20;
    }

    protected int getQueryValueOffset() {
        Integer offset = this.getIntegerValue("offset");
        return offset != null ? offset : 0;
    }

    protected Integer getIntegerValue(String name) {
        String value = this.getQueryParam(name);
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected boolean getQueryValueReturnSize() {
        return Boolean.parseBoolean(this.getQueryParam("returnSize"));
    }
}

