/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.activity;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.ActivityRestResources;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;

@Path(value="v1/social/activities")
@Api(tags={"v1/social/activities"}, value="v1/social/activities", description="Managing activities together with comments and likes")
public class ActivityRestResourcesV1
implements ActivityRestResources {
    private static final String SPACE_PREFIX = "/spaces/";
    private static final String TYPE = "space";

    @Override
    @GET
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets all activities", httpMethod="GET", response=Response.class, notes="This returns an activity in the list in the following cases: <br/><ul><li>the authenticated user is the super user, so he can see all the activities</li><li>this is a user activity and the owner of the activity is the authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getActivitiesOfCurrentUser(@Context UriInfo uriInfo, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of activities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        RealtimeListAccess listAccess = activityManager.getActivityFeedWithListAccess(currentUser);
        List activities = listAccess.loadAsList(offset, limit);
        ArrayList<DataEntity> activityEntities = new ArrayList<DataEntity>();
        for (ExoSocialActivity activity : activities) {
            DataEntity as = EntityBuilder.getActivityStream(activity, currentUser);
            if (as == null && !this.hasMention(currentUser, activity)) continue;
            ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, uriInfo.getPath(), expand);
            activityEntity.setActivityStream(as);
            activityEntities.add(activityEntity.getDataEntity());
        }
        CollectionEntity collectionActivity = new CollectionEntity(activityEntities, "activities", offset, limit);
        if (returnSize) {
            collectionActivity.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionActivity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific activity by id", httpMethod="GET", response=Response.class, notes="This returns the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getActivityById(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        DataEntity as = EntityBuilder.getActivityStream(activity.isComment() ? activityManager.getParentActivity(activity) : activity, currentUser);
        if (as == null && !this.hasMention(currentUser, activity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, uriInfo.getPath(), expand);
        if (!activity.isComment()) {
            activityEntity.setActivityStream(as);
        }
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific activity by id", httpMethod="PUT", response=Response.class, notes="This updates the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateActivityById(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Activity object to be updated, ex: <br/>{<br/>\"title\" : \"My activity\"<br/>}", required=true) ActivityEntity model) throws Exception {
        if (model == null || model.getTitle() == null || model.getTitle().length() == 0) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.checkPermissionToModifyActivity(activity, currentUser);
        activity.setTitle(model.getTitle());
        activityManager.updateActivity(activity);
        DataEntity as = EntityBuilder.getActivityStream(activity, currentUser);
        ActivityEntity activityInfo = EntityBuilder.buildEntityFromActivity(activity, uriInfo.getPath(), expand);
        activityInfo.setActivityStream(as);
        return EntityBuilder.getResponse(activityInfo.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific activity by id", httpMethod="DELETE", response=Response.class, notes="This deletes the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user</li><li>the authenticated user is the super user</li></ul>")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteActivityById(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.checkPermissionToModifyActivity(activity, currentUser);
        DataEntity as = EntityBuilder.getActivityStream(activity, currentUser);
        ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, uriInfo.getPath(), expand);
        activityEntity.setActivityStream(as);
        activityManager.deleteActivity(activity);
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/comments")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets comments of a specific activity", httpMethod="GET", response=Response.class, notes="This returns a list of comments if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getCommentsOfActivity(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of activities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (EntityBuilder.getActivityStream(activity, currentUser) == null && !this.hasMention(currentUser, activity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ArrayList<DataEntity> commentsEntity = new ArrayList<DataEntity>();
        RealtimeListAccess listAccess = activityManager.getCommentsWithListAccess(activity);
        List comments = listAccess.loadAsList(offset, limit);
        for (ExoSocialActivity comment : comments) {
            CommentEntity commentInfo = EntityBuilder.buildEntityFromComment(comment, uriInfo.getPath(), expand, true);
            commentsEntity.add(commentInfo.getDataEntity());
        }
        CollectionEntity collectionComment = new CollectionEntity(commentsEntity, "comments", offset, limit);
        if (returnSize) {
            collectionComment.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionComment, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @Path(value="{id}/comments")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Posts a comment on a specific activity", httpMethod="POST", response=Response.class, notes="This posts the comment if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response postComment(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Comment object to be posted, ex: <br/>{<br/>\"title\" : \"My comment\"<br/>}", required=true) CommentEntity model) throws Exception {
        if (model == null || model.getTitle() == null || model.getTitle().length() == 0) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (EntityBuilder.getActivityStream(activity, currentUser) == null && !this.hasMention(currentUser, activity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        comment.setTitle(model.getTitle());
        comment.setUserId(currentUser.getId());
        activityManager.saveComment(activity, (ExoSocialActivity)comment);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromActivity(activityManager.getActivity(comment.getId()), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/likes")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets likes of a specific activity", httpMethod="GET", response=Response.class, notes="This returns a list of likes if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getLikesOfActivity(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (EntityBuilder.getActivityStream(activity, currentUser) == null && !this.hasMention(currentUser, activity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<DataEntity> likesEntity = EntityBuilder.buildEntityFromLike(activity, uriInfo.getPath(), expand, offset, limit);
        CollectionEntity collectionLike = new CollectionEntity(likesEntity, "likes", offset, limit);
        return EntityBuilder.getResponse(collectionLike, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @Path(value="{id}/likes")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Adds a like to a specific activity", httpMethod="POST", response=Response.class, notes="This adds the like if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response addLike(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (EntityBuilder.getActivityStream(activity, currentUser) == null && !this.hasMention(currentUser, activity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ArrayList<String> likerIds = new ArrayList<String>(Arrays.asList(activity.getLikeIdentityIds()));
        if (!likerIds.contains(currentUser.getId())) {
            likerIds.add(currentUser.getId());
            String[] identityIds = new String[likerIds.size()];
            activity.setLikeIdentityIds(likerIds.toArray(identityIds));
            activityManager.updateActivity(activity);
        }
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromActivity(activityManager.getActivity(id), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/likes/{username}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a like of a specific user for a given activity", httpMethod="GET", response=Response.class, notes="This returns the like if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getLikesActivityOfUser(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="User name", required=true) @PathParam(value="username") String username, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity userToGetLike = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", username, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<String> likerIds = Arrays.asList(activity.getLikeIdentityIds());
        ArrayList<DataEntity> likesEntity = new ArrayList<DataEntity>();
        if (likerIds.contains(userToGetLike.getId())) {
            likesEntity.add(EntityBuilder.buildEntityProfile(username, uriInfo.getPath(), expand).getDataEntity());
        }
        CollectionEntity collectionLike = new CollectionEntity(likesEntity, "likes", 0, 1);
        return EntityBuilder.getResponse(collectionLike, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @DELETE
    @Path(value="{id}/likes/{username}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a like of a specific user for a given activity", httpMethod="DELETE", response=Response.class, notes="This deletes the like if the authenticated user is the given user or the super user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Invalid query input")})
    public Response deleteLike(@Context UriInfo uriInfo, @ApiParam(value="Activity id", required=true) @PathParam(value="id") String id, @ApiParam(value="User name", required=true) @PathParam(value="username") String username, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!authenticatedUser.equals(username)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity currentUser = ((IdentityManager)CommonsUtils.getService(IdentityManager.class)).getOrCreateIdentity("organization", authenticatedUser, true);
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        ExoSocialActivity activity = activityManager.getActivity(id);
        if (activity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ArrayList<String> likerIds = new ArrayList<String>(Arrays.asList(activity.getLikeIdentityIds()));
        if (likerIds.contains(currentUser.getId())) {
            likerIds.remove(currentUser.getId());
            String[] identityIds = new String[likerIds.size()];
            activity.setLikeIdentityIds(likerIds.toArray(identityIds));
            activityManager.updateActivity(activity);
        }
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromActivity(activityManager.getActivity(id), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    private void checkPermissionToModifyActivity(ExoSocialActivity activity, Identity currentUser) {
        if (activity.getActivityStream().getType().toString().equalsIgnoreCase(TYPE)) {
            String spaceGroupId;
            SpaceService spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(spaceGroupId = SPACE_PREFIX + activity.getActivityStream().getPrettyId());
            if (space == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            if (!activity.getPosterId().equals(currentUser.getId()) && !spaceService.isManager(space, currentUser.getRemoteId())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        } else if (!activity.getPosterId().equals(currentUser.getId())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private boolean hasMention(Identity currentUser, ExoSocialActivity activity) {
        String[] mentionerIds;
        for (String id : mentionerIds = activity.getMentionedIds()) {
            if (!id.startsWith(currentUser.getId())) continue;
            return true;
        }
        return false;
    }
}

