/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacetemplates;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.SocialRest;

@Path(value="v1/social/spaceTemplates")
@Api(tags={"v1/social/spaceTemplates"}, value="v1/social/spaceTemplates", description="Managing Spaces Templates")
public class SpaceTemplatesRestResourcesV1
implements SocialRest {
    private SpaceTemplateService spaceTemplateService;

    public SpaceTemplatesRestResourcesV1(SpaceTemplateService spaceTemplateService) {
        this.spaceTemplateService = spaceTemplateService;
    }

    @GET
    @Path(value="templates")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets all spaces templates", httpMethod="GET", response=Response.class, notes="This returns space templates details")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAllTemplates(@Context UriInfo uriInfo) {
        return EntityBuilder.getResponse(this.spaceTemplateService.getSpaceTemplates(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }
}

