/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.Safe;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.RestChecker;
import org.exoplatform.social.service.rest.SpaceRest;
import org.exoplatform.social.service.rest.Util;
import org.exoplatform.social.service.rest.api.models.IdentityNameList;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.router.Router;
import org.exoplatform.web.controller.router.RouterConfigException;
import org.exoplatform.web.controller.router.URIWriter;

@Path(value="{portalName}/social/spaces")
public class SpacesRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(SpacesRestService.class);
    private SpaceService _spaceService;
    private IdentityManager _identityManager;
    private static final String CONFIRMED_STATUS = "confirmed";
    private static final String PENDING_STATUS = "pending";
    private static final String INCOMING_STATUS = "incoming";
    private static final String ALL_SPACES_STATUS = "all_spaces";
    private String portalContainerName;
    private static final QualifiedName PATH = QualifiedName.create((String)"gtn", (String)"path");
    private static final QualifiedName LANG = QualifiedName.create((String)"gtn", (String)"lang");
    private static final QualifiedName REQUEST_SITE_TYPE = QualifiedName.create((String)"gtn", (String)"sitetype");
    private static final QualifiedName REQUEST_HANDLER = QualifiedName.create((String)"gtn", (String)"handler");
    private static final QualifiedName REQUEST_SITE_NAME = QualifiedName.create((String)"gtn", (String)"sitename");
    private static final String ALL_SPACES = "all-spaces";
    private static final String JSON = "json";

    @GET
    @Path(value="mySpaces/show.{format}")
    public Response showMySpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        ConversationState state = ConversationState.getCurrent();
        this.portalContainerName = portalName;
        String userId = null;
        if (state != null) {
            userId = state.getIdentity().getUserId();
        }
        SpaceList mySpaceList = this.showMySpaceList(userId);
        this.fillUrlAllSpaces(mySpaceList, portalName);
        return Util.getResponse(mySpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="lastVisitedSpace/list.{format}")
    public Response getLastVisitedSpace(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format, @QueryParam(value="appId") String appId, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) throws Exception {
        RestChecker.checkAuthenticatedRequest();
        MediaType mediaType = Util.getMediaType(format, new String[]{format});
        ConversationState state = ConversationState.getCurrent();
        this.portalContainerName = portalName;
        String userId = null;
        if (state != null) {
            userId = state.getIdentity().getUserId();
        }
        int newLimit = Math.min(limit, 100);
        int newOffset = 0;
        newOffset = offset > 0 ? Math.min(offset, newLimit) : 0;
        String newAppId = null;
        if (appId != null && appId.trim().length() > 0) {
            newAppId = appId;
        }
        SpaceList mySpaceList = this.getLastVisitedSpace(userId, newAppId, newOffset, newLimit);
        return Util.getResponse(mySpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @Path(value="spaceInfo")
    public Response getSpaceInfo(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @QueryParam(value="spaceName") String spaceName) throws Exception {
        RestChecker.checkAuthenticatedRequest();
        MediaType mediaType = Util.getMediaType(JSON, new String[]{JSON});
        this.portalContainerName = portalName;
        Space space = this.getSpaceService().getSpaceByPrettyName(spaceName);
        if (space == null && StringUtils.isNotBlank((CharSequence)spaceName)) {
            space = this.getSpaceService().getSpaceByGroupId("/spaces/" + spaceName);
        }
        if (space == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        HashMap<String, String> spaceInfo = new HashMap<String, String>();
        spaceInfo.put("displayName", space.getDisplayName());
        spaceInfo.put("url", this.buildSpaceUrl(space.getUrl()));
        spaceInfo.put("imageSource", space.getAvatarUrl() != null ? space.getAvatarUrl() : "/eXoSkin/skin/images/system/SpaceAvtDefault.png");
        return Util.getResponse(spaceInfo, uriInfo, mediaType, Response.Status.OK);
    }

    private String buildSpaceUrl(String spaceUrl) {
        return "/" + this.portalContainerName + "/g/:spaces:" + spaceUrl + "/" + spaceUrl;
    }

    @GET
    @Path(value="pendingSpaces/show.{format}")
    public Response showPendingSpaceList(@Context UriInfo uriInfo, @PathParam(value="portalName") String portalName, @PathParam(value="format") String format) throws Exception {
        MediaType mediaType = Util.getMediaType(format);
        String userId = ConversationState.getCurrent().getIdentity().getUserId();
        this.portalContainerName = portalName;
        SpaceList pendingSpaceList = this.showPendingSpaceList(userId);
        return Util.getResponse(pendingSpaceList, uriInfo, mediaType, Response.Status.OK);
    }

    @GET
    @RolesAllowed(value={"users"})
    @Path(value="suggest.{format}")
    public Response suggestSpacenames(@Context UriInfo uriInfo, @Context HttpServletRequest request, @PathParam(value="portalName") String portalName, @QueryParam(value="conditionToSearch") String conditionToSearch, @QueryParam(value="typeOfRelation") String typeOfRelation, @QueryParam(value="currentUser") String userId, @PathParam(value="format") String format) throws Exception {
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!userId.equals(request.getRemoteUser())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        MediaType mediaType = Util.getMediaType(format);
        this.portalContainerName = portalName;
        SpaceService spaceSrv = this.getSpaceService();
        IdentityNameList nameList = new IdentityNameList();
        if (ALL_SPACES_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = spaceSrv.getAccessibleSpacesByFilter(userId, new SpaceFilter(conditionToSearch));
            List<Object> spaces = Arrays.asList(listAccess.load(0, 10));
            this.addSpaceNames(nameList, spaces);
        } else if (PENDING_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = spaceSrv.getPendingSpacesByFilter(userId, new SpaceFilter(conditionToSearch));
            List<Object> spaces = Arrays.asList(listAccess.load(0, 10));
            this.addSpaceNames(nameList, spaces);
        } else if (INCOMING_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = spaceSrv.getInvitedSpacesByFilter(userId, new SpaceFilter(conditionToSearch));
            List<Object> spaces = Arrays.asList(listAccess.load(0, 10));
            this.addSpaceNames(nameList, spaces);
        } else if (CONFIRMED_STATUS.equals(typeOfRelation)) {
            ListAccess listAccess = spaceSrv.getMemberSpacesByFilter(userId, new SpaceFilter(conditionToSearch));
            List<Object> spaces = Arrays.asList(listAccess.load(0, 10));
            this.addSpaceNames(nameList, spaces);
        }
        return Util.getResponse(nameList, uriInfo, mediaType, Response.Status.OK);
    }

    private void addSpaceNames(IdentityNameList nameList, List<Space> spaces) {
        int i = 1;
        for (Space space : spaces) {
            IdentityNameList.Option opt = new IdentityNameList.Option();
            opt.setType("space");
            opt.setInvalid(false);
            opt.setOrder(i++);
            opt.setText(space.getDisplayName());
            opt.setValue(space.getPrettyName());
            opt.setAvatarUrl(space.getAvatarUrl());
            nameList.addOption(opt);
        }
    }

    private SpaceList showMySpaceList(String userId) {
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        List mySpaces = null;
        ArrayList<SpaceRest> mySpacesRest = new ArrayList<SpaceRest>();
        try {
            mySpaces = this._spaceService.getSpaces(userId);
            for (Space space : mySpaces) {
                SpaceRest spaceRest = new SpaceRest(space);
                mySpacesRest.add(spaceRest);
            }
            Router router = this.getRouter(this.getConfigurationPath());
            this.fillSpacesURI(mySpacesRest, router);
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(mySpacesRest);
        return spaceList;
    }

    private SpaceList getLastVisitedSpace(String userId, String appId, int offset, int limit) {
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        List mySpaces = null;
        try {
            mySpaces = this._spaceService.getLastAccessedSpace(userId, appId, offset, limit);
            for (Space space : mySpaces) {
                SpaceRest spaceRest = new SpaceRest(space);
                spaceList.addSpace(spaceRest);
            }
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        return spaceList;
    }

    private SpaceList showPendingSpaceList(String userId) {
        SpaceList spaceList = new SpaceList();
        this._spaceService = this.getSpaceService();
        ArrayList<SpaceRest> pendingSpacesRest = new ArrayList<SpaceRest>();
        try {
            List pendingSpaces = this._spaceService.getPendingSpaces(userId);
            for (Space space : pendingSpaces) {
                SpaceRest spaceRest = new SpaceRest(space);
                pendingSpacesRest.add(spaceRest);
            }
        }
        catch (SpaceException e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        spaceList.setSpaces(pendingSpacesRest);
        return spaceList;
    }

    private void fillUrlAllSpaces(SpaceList spaceList, String portalOwner) {
        try {
            Router router = this.getRouter(this.getConfigurationPath());
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put(REQUEST_HANDLER, "portal");
            qualifiedName.put(REQUEST_SITE_TYPE, "portal");
            qualifiedName.put(LANG, "");
            StringBuilder urlBuilder = new StringBuilder();
            qualifiedName.put(REQUEST_SITE_NAME, portalOwner);
            qualifiedName.put(PATH, ALL_SPACES);
            router.render((Map)qualifiedName, new URIWriter((Appendable)urlBuilder));
            spaceList.setMoreSpacesUrl(urlBuilder.toString());
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private SpaceService getSpaceService() {
        return (SpaceService)this.getPortalContainer().getComponentInstanceOfType(SpaceService.class);
    }

    private IdentityManager getIdentityManager() {
        if (this._identityManager == null) {
            this._identityManager = (IdentityManager)this.getPortalContainer().getComponentInstanceOfType(IdentityManager.class);
        }
        return this._identityManager;
    }

    private PortalContainer getPortalContainer() {
        return (PortalContainer)ExoContainerContext.getContainerByName((String)this.portalContainerName);
    }

    private void fillSpacesURI(List<SpaceRest> mySpaces, Router router) {
        try {
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put(REQUEST_HANDLER, "portal");
            qualifiedName.put(REQUEST_SITE_TYPE, "group");
            for (SpaceRest space : mySpaces) {
                StringBuilder urlBuilder = new StringBuilder();
                qualifiedName.put(REQUEST_SITE_NAME, space.getGroupId());
                qualifiedName.put(PATH, space.getUrl());
                router.render((Map)qualifiedName, new URIWriter((Appendable)urlBuilder));
                space.setSpaceUrl(urlBuilder.toString());
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private String getConfigurationPath() {
        PortalContainer portalContainer = this.getPortalContainer();
        WebAppController webAppController = (WebAppController)portalContainer.getComponentInstanceOfType(WebAppController.class);
        return webAppController.getConfigurationPath();
    }

    private Router getRouter(String path) throws IOException, RouterConfigException {
        File f = new File(path);
        if (!f.exists()) {
            throw new MalformedURLException("Could not resolve path " + path);
        }
        if (!f.isFile()) {
            throw new MalformedURLException("Could not resolve path " + path + " to a valid file");
        }
        return this.getRouter(f.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Router getRouter(URL url) throws RouterConfigException, IOException {
        InputStream in = url.openStream();
        try {
            ControllerDescriptor routerDesc = new DescriptorBuilder().build(in);
            Router router = new Router(routerDesc);
            return router;
        }
        finally {
            Safe.close((Closeable)in);
        }
    }

    @XmlRootElement
    public static class SpaceList {
        private String moreSpacesUrl;
        private List<SpaceRest> _spaces;

        public void setSpaces(List<SpaceRest> spaces) {
            this._spaces = spaces;
        }

        public List<SpaceRest> getSpaces() {
            return this._spaces;
        }

        public void addSpace(SpaceRest space) {
            if (this._spaces == null) {
                this._spaces = new LinkedList<SpaceRest>();
            }
            this._spaces.add(space);
        }

        public String getMoreSpacesUrl() {
            return this.moreSpacesUrl;
        }

        public void setMoreSpacesUrl(String allSpacesUrl) {
            this.moreSpacesUrl = allSpacesUrl;
        }
    }
}

