/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.activity;

import java.util.ArrayList;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class ActivityRestResourcesTest
extends AbstractResourceTest {
    private ActivityRestResourcesV1 activityRestResourcesV1;
    private IdentityStorage identityStorage;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private Identity testSpaceIdentity;
    private final Logger log = LoggerFactory.getLogger(ActivityRestResourcesTest.class);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        this.identityStorage.saveIdentity(this.maryIdentity);
        this.identityStorage.saveIdentity(this.demoIdentity);
        this.activityRestResourcesV1 = new ActivityRestResourcesV1();
        this.registry(this.activityRestResourcesV1);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(this.activityRestResourcesV1.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSpaceActivity() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        try {
            ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
            testSpaceActivity.setTitle("Test space activity");
            this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
            ActivityRestResourcesTest.assertNotNull((Object)this.testSpaceIdentity.getId());
            ContainerResponse response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            ActivityEntity activityEntity = this.getBaseEntity((DataEntity)response.getEntity(), ActivityEntity.class);
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity);
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity.getOwner());
            ActivityRestResourcesTest.assertTrue((boolean)activityEntity.getOwner().contains("/social/spaces/" + space.getId()));
            ExoSocialActivityImpl testComment = new ExoSocialActivityImpl();
            testComment.setTitle("Test Comment");
            this.activityManager.saveComment((ExoSocialActivity)testSpaceActivity, (ExoSocialActivity)testComment);
            response = this.service("GET", "/v1/social/activities/comment" + testComment.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            CommentEntity commentEntity = this.getBaseEntity((DataEntity)response.getEntity(), CommentEntity.class);
            ActivityRestResourcesTest.assertNotNull((Object)commentEntity);
            ActivityRestResourcesTest.assertNotNull((Object)commentEntity.getTitle());
            ActivityRestResourcesTest.assertEquals((String)commentEntity.getTitle(), (String)"Test Comment");
            response = this.service("GET", "/v1/social/activities/comment" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
            this.startSessionAs("John");
            response = this.service("GET", "/v1/social/activities/comment" + testComment.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
            response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
            this.startSessionAs("root");
            this.activityManager.deleteActivity((ExoSocialActivity)testSpaceActivity);
            response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        }
        catch (Exception exc) {
            this.log.error((Object)exc);
        }
        finally {
            if (space != null) {
                this.spaceService.deleteSpace(space);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetSpaceActivityWithBody() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance("test", "root");
        this.testSpaceIdentity = new Identity("space", "test");
        this.identityStorage.saveIdentity(this.testSpaceIdentity);
        try {
            ExoSocialActivityImpl testSpaceActivity = new ExoSocialActivityImpl();
            testSpaceActivity.setTitle("Test space activity title");
            testSpaceActivity.setBody("test space activity body");
            this.activityManager.saveActivityNoReturn(this.testSpaceIdentity, (ExoSocialActivity)testSpaceActivity);
            ActivityRestResourcesTest.assertNotNull((Object)this.testSpaceIdentity.getId());
            ContainerResponse response = this.service("GET", "/v1/social/activities/" + testSpaceActivity.getId(), "", null, null);
            ActivityRestResourcesTest.assertNotNull((Object)response);
            ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            ActivityEntity activityEntity = this.getBaseEntity((DataEntity)response.getEntity(), ActivityEntity.class);
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity);
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity.getBody());
            ActivityRestResourcesTest.assertEquals((String)"Test space activity title", (String)activityEntity.getTitle());
            ActivityRestResourcesTest.assertEquals((String)"test space activity body", (String)activityEntity.getBody());
            ActivityRestResourcesTest.assertNotNull((Object)activityEntity.getOwner());
            ActivityRestResourcesTest.assertTrue((boolean)activityEntity.getOwner().contains("/social/spaces/" + space.getId()));
        }
        finally {
            if (space != null) {
                this.spaceService.deleteSpace(space);
            }
        }
    }

    public void testGetActivitiesOfCurrentUser() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl maryActivity = new ExoSocialActivityImpl();
        maryActivity.setTitle("mary activity");
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)maryActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities?limit=5&offset=0", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        ArrayList<String> activitiesTitle = new ArrayList<String>(2);
        ActivityEntity entity = this.getBaseEntity(collections.getEntities().get(0), ActivityEntity.class);
        activitiesTitle.add(entity.getTitle());
        entity = this.getBaseEntity(collections.getEntities().get(1), ActivityEntity.class);
        activitiesTitle.add(entity.getTitle());
        ActivityRestResourcesTest.assertTrue((boolean)activitiesTitle.contains("root activity"));
        ActivityRestResourcesTest.assertTrue((boolean)activitiesTitle.contains("demo activity"));
    }

    public void testGetUpdatedDeletedActivityById() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + demoActivity.getId(), "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ActivityEntity result = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)result.getTitle(), (String)"demo activity");
        String input = "{\"title\":updated}";
        response = this.getResponse("PUT", "/v1/social/activities/" + demoActivity.getId(), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.startSessionAs("demo");
        response = this.getResponse("PUT", "/v1/social/activities/" + demoActivity.getId(), input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        result = this.getBaseEntity(response.getEntity(), ActivityEntity.class);
        ActivityRestResourcesTest.assertEquals((String)result.getTitle(), (String)"updated");
        response = this.service("DELETE", "/v1/social/activities/" + demoActivity.getId(), "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ActivityRestResourcesTest.assertNull((Object)this.activityManager.getActivity(demoActivity.getId()));
    }

    public void testGetComments() throws Exception {
        this.startSessionAs("root");
        int nbComments = 5;
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        for (int i = 0; i < nbComments; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)rootActivity, (ExoSocialActivity)comment);
        }
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        this.startSessionAs("demo");
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testGetCommentsWithReplies() throws Exception {
        this.startSessionAs("root");
        int nbComments = 5;
        int nbReplies = 5;
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        for (int i = 0; i < nbComments; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(this.rootIdentity.getId());
            this.activityManager.saveComment((ExoSocialActivity)rootActivity, (ExoSocialActivity)comment);
            for (int j = 0; j < nbReplies; ++j) {
                ExoSocialActivityImpl commentReply = new ExoSocialActivityImpl();
                commentReply.setTitle("comment reply " + i + " - " + j);
                commentReply.setUserId(this.maryIdentity.getId());
                commentReply.setParentCommentId(comment.getId());
                this.activityManager.saveComment((ExoSocialActivity)rootActivity, (ExoSocialActivity)commentReply);
            }
        }
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments?expand=subComments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)(nbComments + nbComments * nbReplies), (int)collections.getEntities().size());
        this.startSessionAs("demo");
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        this.relationshipManager.confirm(this.rootIdentity, this.demoIdentity);
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)5, (int)collections.getEntities().size());
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/comments?expand=subComments", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)(nbComments + nbComments * nbReplies), (int)collections.getEntities().size());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testPostComment() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        String input = "{\"body\":comment1, \"title\":comment1}";
        ContainerResponse response = this.getResponse("POST", "/v1/social/activities/" + rootActivity.getId() + "/comments", input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CommentEntity result = this.getBaseEntity(response.getEntity(), CommentEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"comment1", (String)result.getTitle());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity).getSize());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testPostCommentReply() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        String input = "{\"body\":\"comment1 body\", \"title\":comment1}";
        ContainerResponse response = this.getResponse("POST", "/v1/social/activities/" + rootActivity.getId() + "/comments", input);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CommentEntity comment = this.getBaseEntity(response.getEntity(), CommentEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"comment1", (String)comment.getTitle());
        ActivityRestResourcesTest.assertEquals((String)"comment1 body", (String)comment.getBody());
        ActivityRestResourcesTest.assertNotNull((Object)comment.getId());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity).getSize());
        String commentReplyInput = "{\"body\":\"comment reply 1 body\", \"title\":\"comment reply 1\", \"parentCommentId\": " + comment.getId() + "}";
        response = this.getResponse("POST", "/v1/social/activities/" + rootActivity.getId() + "/comments", commentReplyInput);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CommentEntity commentReply = this.getBaseEntity(response.getEntity(), CommentEntity.class);
        ActivityRestResourcesTest.assertEquals((String)"comment reply 1", (String)commentReply.getTitle());
        ActivityRestResourcesTest.assertEquals((String)"comment reply 1 body", (String)commentReply.getBody());
        ActivityRestResourcesTest.assertEquals((String)comment.getId(), (String)commentReply.getParentCommentId());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity).getSize());
        ActivityRestResourcesTest.assertEquals((int)1, (int)this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity, true).getSize());
        ActivityRestResourcesTest.assertEquals((int)2, (int)((ExoSocialActivity[])this.activityManager.getCommentsWithListAccess((ExoSocialActivity)rootActivity, true).load(0, -1)).length);
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testGetLikes() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        ArrayList<String> likerIds = new ArrayList<String>();
        likerIds.add(this.demoIdentity.getId());
        rootActivity.setLikeIdentityIds(likerIds.toArray(new String[likerIds.size()]));
        this.activityManager.updateActivity((ExoSocialActivity)rootActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testPostLike() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        ArrayList<String> likerIds = new ArrayList<String>();
        likerIds.add(this.demoIdentity.getId());
        rootActivity.setLikeIdentityIds(likerIds.toArray(new String[likerIds.size()]));
        this.activityManager.updateActivity((ExoSocialActivity)rootActivity);
        ContainerResponse response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ArrayList<String> updatedLikes = new ArrayList<String>();
        updatedLikes.add(this.activityManager.getActivity(rootActivity.getId()).getLikeIdentityIds()[0]);
        updatedLikes.add(this.maryIdentity.getId());
        rootActivity.setLikeIdentityIds(updatedLikes.toArray(new String[updatedLikes.size()]));
        this.activityManager.updateActivity((ExoSocialActivity)rootActivity);
        response = this.service("GET", "/v1/social/activities/" + rootActivity.getId() + "/likes", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        ActivityRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testDeleteLike() throws Exception {
        this.startSessionAs("demo");
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ArrayList<String> likerIds = new ArrayList<String>();
        likerIds.add(this.demoIdentity.getId());
        demoActivity.setLikeIdentityIds(likerIds.toArray(new String[likerIds.size()]));
        this.activityManager.updateActivity((ExoSocialActivity)demoActivity);
        ContainerResponse response = this.service("DELETE", "/v1/social/activities/" + demoActivity.getId() + "/likes/demo", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        DataEntity activityEntity = (DataEntity)response.getEntity();
        ActivityRestResourcesTest.assertNotNull((Object)activityEntity);
        this.activityManager.deleteActivity((ExoSocialActivity)demoActivity);
    }

    public void testDeleteLikeWhenNoPermissionOnActivity() throws Exception {
        this.startSessionAs("root");
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        this.startSessionAs("demo");
        ContainerResponse response = this.service("DELETE", "/v1/social/activities/" + rootActivity.getId() + "/likes/demo", "", null, null);
        ActivityRestResourcesTest.assertNotNull((Object)response);
        ActivityRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
        DataEntity activityEntity = (DataEntity)response.getEntity();
        ActivityRestResourcesTest.assertNull((Object)activityEntity);
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    private Space getSpaceInstance(String prettyName, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName(prettyName);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + prettyName);
        space.setType("classic");
        space.setVisibility("private");
        space.setRegistration("validation");
        space.setPriority("2");
        this.spaceService.createSpace(space, creator);
        return space;
    }
}

