/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.users;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.mock.MockUploadService;
import org.exoplatform.social.rest.api.ErrorResource;
import org.exoplatform.social.rest.api.UserImportResultEntity;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.impl.user.UserRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class UserRestResourcesTest
extends AbstractResourceTest {
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private UserACL userACL;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;
    private UserStateService userStateService;
    private MockUploadService uploadService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.userACL = (UserACL)this.getContainer().getComponentInstanceOfType(UserACL.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.userStateService = (UserStateService)this.getContainer().getComponentInstanceOfType(UserStateService.class);
        this.uploadService = (MockUploadService)((Object)this.getContainer().getComponentInstanceOfType(UploadService.class));
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityManager.saveIdentity(this.rootIdentity);
        this.identityManager.saveIdentity(this.johnIdentity);
        this.identityManager.saveIdentity(this.maryIdentity);
        this.identityManager.saveIdentity(this.demoIdentity);
        this.addResource(UserRestResourcesV1.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(UserRestResourcesV1.class);
    }

    public void testGetAllUsers() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)4, (int)collections.getEntities().size());
    }

    public void testGetAllUsersWithExtraFields() throws Exception {
        Space spaceTest = this.getSpaceInstance(700, "root");
        spaceTest.getId();
        spaceTest.setMembers(new String[]{"mary", "john", "demo"});
        this.spaceService.updateSpace(spaceTest);
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.maryIdentity);
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.rootIdentity);
        this.relationshipManager.inviteToConnect(this.maryIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.maryIdentity);
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.johnIdentity);
        this.relationshipManager.confirm(this.johnIdentity, this.demoIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users?limit=5&offset=0&expand=all,connectionsCount,spacesCount,connectionsInCommonCount,relationshipStatus"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)4, (int)collections.getEntities().size());
        List entities = collections.getEntities();
        for (DataEntity dataEntity : entities) {
            String username = dataEntity.get((Object)"username").toString();
            if (StringUtils.equals((CharSequence)username, (CharSequence)"root")) continue;
            String connectionsCount = dataEntity.get((Object)"connectionsCount").toString();
            String spacesCount = dataEntity.get((Object)"spacesCount").toString();
            String connectionsInCommonCount = dataEntity.get((Object)"connectionsInCommonCount").toString();
            String relationshipStatus = dataEntity.get((Object)"relationshipStatus").toString();
            if (StringUtils.equals((CharSequence)username, (CharSequence)"john")) {
                UserRestResourcesTest.assertEquals((String)"3", (String)connectionsCount);
            } else {
                UserRestResourcesTest.assertEquals((String)"1", (String)connectionsCount);
            }
            UserRestResourcesTest.assertEquals((String)"1", (String)spacesCount);
            if (StringUtils.equals((CharSequence)username, (CharSequence)"john")) {
                UserRestResourcesTest.assertEquals((String)"CONFIRMED", (String)relationshipStatus);
            } else if (StringUtils.equals((CharSequence)username, (CharSequence)"mary")) {
                UserRestResourcesTest.assertEquals((String)"OUTGOING", (String)relationshipStatus);
            } else if (StringUtils.equals((CharSequence)username, (CharSequence)"demo")) {
                UserRestResourcesTest.assertEquals((String)"INCOMING", (String)relationshipStatus);
            }
            if (StringUtils.equals((CharSequence)username, (CharSequence)"john")) {
                UserRestResourcesTest.assertEquals((String)"0", (String)connectionsInCommonCount);
                continue;
            }
            UserRestResourcesTest.assertEquals((String)"1", (String)connectionsInCommonCount);
        }
    }

    public void testGetOnlineUsers() throws Exception {
        this.startSessionAs("root");
        long date = new Date().getTime();
        UserStateModel userModel = new UserStateModel("john", date, "available");
        UserStateModel userModel2 = new UserStateModel("mary", date, "available");
        this.userStateService.save(userModel);
        this.userStateService.save(userModel2);
        this.userStateService.ping(userModel.getUserId());
        this.userStateService.ping(userModel2.getUserId());
        ContainerResponse response = this.service("GET", this.getURLResource("users?status=online&limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
    }

    public void testGetOnlineUsersOfSpace() throws Exception {
        this.startSessionAs("root");
        long date = new Date().getTime();
        UserStateModel userModel = new UserStateModel("john", date, "available");
        UserStateModel userModel2 = new UserStateModel("mary", date, "available");
        this.userStateService.save(userModel);
        this.userStateService.save(userModel2);
        this.userStateService.ping(userModel.getUserId());
        this.userStateService.ping(userModel2.getUserId());
        Space spaceTest = this.getSpaceInstance(0, "root");
        String spaceId = spaceTest.getId();
        spaceTest.setMembers(new String[]{"john"});
        this.spaceService.updateSpace(spaceTest);
        ContainerResponse response = this.service("GET", this.getURLResource("users?status=online&spaceId=" + spaceId), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("users?status=online&spaceId=600"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        ErrorResource errorResource = (ErrorResource)response.getEntity();
        UserRestResourcesTest.assertEquals((String)"space not found", (String)errorResource.getDeveloperMessage());
        UserRestResourcesTest.assertEquals((String)"space 600 does not exist", (String)errorResource.getMessage());
    }

    public void testGetUserById() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/john"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        ProfileEntity userEntity = this.getBaseEntity(response.getEntity(), ProfileEntity.class);
        UserRestResourcesTest.assertEquals((String)"john", (String)userEntity.getUsername());
    }

    public void testGetConnectionsOfUser() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ContainerResponse response = this.service("GET", this.getURLResource("users/root/connections?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ProfileEntity userEntity = this.getBaseEntity(collections.getEntities().get(0), ProfileEntity.class);
        UserRestResourcesTest.assertEquals((String)"demo", (String)userEntity.getUsername());
    }

    public void testGetInvitationsOfUser() throws Exception {
        this.relationshipManager.inviteToConnect(this.demoIdentity, this.rootIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/connections/invitations?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ProfileEntity userEntity = this.getBaseEntity(collections.getEntities().get(0), ProfileEntity.class);
        UserRestResourcesTest.assertEquals((String)"demo", (String)userEntity.getUsername());
    }

    public void testGetPendingOfUser() throws Exception {
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/connections/pending?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        ProfileEntity userEntity = this.getBaseEntity(collections.getEntities().get(0), ProfileEntity.class);
        UserRestResourcesTest.assertEquals((String)"demo", (String)userEntity.getUsername());
    }

    public void testGetActivitiesOfUser() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        Thread.sleep(10L);
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl maryActivity = new ExoSocialActivityImpl();
        maryActivity.setTitle("mary activity");
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)maryActivity);
        this.end();
        this.begin();
        ContainerResponse response = this.service("GET", this.getURLResource("users/root/activities?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        ActivityEntity activityEntity = this.getBaseEntity(collections.getEntities().get(0), ActivityEntity.class);
        UserRestResourcesTest.assertEquals((String)"demo activity", (String)activityEntity.getTitle());
        activityEntity = this.getBaseEntity(collections.getEntities().get(1), ActivityEntity.class);
        UserRestResourcesTest.assertEquals((String)"root activity", (String)activityEntity.getTitle());
        this.activityManager.deleteActivity((ExoSocialActivity)maryActivity);
        this.activityManager.deleteActivity((ExoSocialActivity)demoActivity);
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }

    public void testGetSpacesOfUser() throws Exception {
        this.getSpaceInstance(0, "root");
        this.getSpaceInstance(1, "john");
        this.getSpaceInstance(2, "demo");
        this.getSpaceInstance(3, "demo");
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("users/root/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.startSessionAs("john");
        response = this.service("GET", this.getURLResource("users/john/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.startSessionAs("demo");
        response = this.service("GET", this.getURLResource("users/demo/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        this.startSessionAs("john");
        response = this.service("GET", this.getURLResource("users/demo/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)403, (int)response.getStatus());
        this.startSessionAs("root");
        response = this.service("GET", this.getURLResource("users/demo/spaces?limit=5&offset=0"), "", null, null);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
    }

    public void testAddActivityByUser() throws Exception {
        String input = "{\"title\":titleOfActivity,\"templateParams\":{\"param1\": value1,\"param2\":value2}}";
        this.startSessionAs("john");
        ContainerResponse response = this.getResponse("POST", this.getURLResource("users/john/activities"), input);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        DataEntity responseEntity = (DataEntity)response.getEntity();
        String title = (String)responseEntity.get((Object)"title");
        UserRestResourcesTest.assertNotNull((Object)title);
        UserRestResourcesTest.assertEquals((String)"titleOfActivity", (String)title);
        DataEntity templateParams = (DataEntity)responseEntity.get((Object)"templateParams");
        UserRestResourcesTest.assertNotNull((Object)templateParams);
        UserRestResourcesTest.assertEquals((int)2, (int)templateParams.size());
    }

    public void testUpdateProfileAtribute() throws Exception {
        this.startSessionAs("root");
        String email = "root@test.com";
        byte[] formData = ("name=email&value=" + email).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", "root");
        UserRestResourcesTest.assertNotNull((Object)identity);
        UserRestResourcesTest.assertEquals((String)email, (String)identity.getProfile().getEmail());
        response = this.service("PATCH", this.getURLResource("users/john/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)"User root shouldn't be able to modify john attributes", (int)401, (int)response.getStatus());
    }

    public void testUpdateProfileAvatar() throws Exception {
        this.startSessionAs("root");
        String uploadId = "testtest";
        byte[] formData = ("name=avatar&value=" + uploadId).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)500, (int)response.getStatus());
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("blank.gif");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "avatar.png", "image/png");
        response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", "root");
        UserRestResourcesTest.assertNotNull((Object)identity);
        UserRestResourcesTest.assertNotNull((Object)identity.getProfile().getAvatarLastUpdated());
        InputStream avatarInputStream = this.identityManager.getAvatarInputStream(identity);
        String storedContent = IOUtil.getStreamContentAsString((InputStream)avatarInputStream);
        String content = IOUtil.getStreamContentAsString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("blank.gif"));
        UserRestResourcesTest.assertEquals((String)content, (String)storedContent);
    }

    public void testUpdateProfileBanner() throws Exception {
        this.startSessionAs("root");
        String uploadId = "testtest";
        byte[] formData = ("name=banner&value=" + uploadId).getBytes();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ContainerResponse response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)500, (int)response.getStatus());
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("blank.gif");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "banner.png", "image/png");
        response = this.service("PATCH", this.getURLResource("users/root/"), "", (MultivaluedMap<String, String>)headers, formData);
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", "root");
        UserRestResourcesTest.assertNotNull((Object)identity);
        UserRestResourcesTest.assertNotNull((Object)identity.getProfile().getBannerLastUpdated());
        InputStream bannerInputStream = this.identityManager.getBannerInputStream(identity);
        String storedContent = IOUtil.getStreamContentAsString((InputStream)bannerInputStream);
        String content = IOUtil.getStreamContentAsString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("blank.gif"));
        UserRestResourcesTest.assertEquals((String)content, (String)storedContent);
    }

    public void testImportUsers() throws Exception {
        this.startSessionAs("root");
        String uploadId = "users-empty.csv";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        ContainerResponse response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-empty.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-empty.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((int)400, (int)response.getStatus());
        uploadId = "users.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&progress=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        UserImportResultEntity importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)4L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertEquals((long)importResultEntity.getCount(), (long)importResultEntity.getProcessedCount());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getWarnMessages());
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        UserRestResourcesTest.assertNotNull((Object)uploadResource);
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&clean=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)4L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertNull((Object)importResultEntity.getWarnMessages());
        uploadResource = this.uploadService.getUploadResource(uploadId);
        UserRestResourcesTest.assertNull((Object)uploadResource);
        uploadId = "users-errors.csv";
        resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("users-errors.csv");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "users-errors.csv", "text/csv");
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&sync=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        response = this.service("POST", this.getURLResource("users/csv"), "", (MultivaluedMap<String, String>)headers, ("uploadId=" + uploadId + "&progress=true").getBytes());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertNotNull((Object)response.getEntity());
        UserRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        UserRestResourcesTest.assertEquals(response.getEntity().getClass(), UserImportResultEntity.class);
        importResultEntity = (UserImportResultEntity)response.getEntity();
        UserRestResourcesTest.assertEquals((long)6L, (long)importResultEntity.getCount());
        UserRestResourcesTest.assertEquals((long)importResultEntity.getCount(), (long)importResultEntity.getProcessedCount());
        UserRestResourcesTest.assertNotNull((Object)importResultEntity.getErrorMessages());
        UserRestResourcesTest.assertEquals((int)3, (int)importResultEntity.getErrorMessages().size());
        UserRestResourcesTest.assertNotNull((Object)importResultEntity.getWarnMessages());
        UserRestResourcesTest.assertEquals((int)1, (int)importResultEntity.getWarnMessages().size());
    }

    public void testUpdateProfileAtributes() throws Exception {
        String firstName = "Johnny";
        String lastName = "Bravo";
        String fullName = "Johnny Bravo";
        String aboutMe = "AboutMe";
        String imType = "Skype";
        String imId = "johnnyB";
        String phoneType = "work";
        String phoneNumber = "123456";
        String url = "fakeURL";
        String email = "johnny@localhost.com";
        StringBuilder input = new StringBuilder("{");
        input.append("\"");
        input.append("firstname");
        input.append("\":\"");
        input.append(firstName);
        input.append("\",");
        input.append("\"");
        input.append("lastname");
        input.append("\":\"");
        input.append(lastName);
        input.append("\",");
        input.append("\"");
        input.append("fullname");
        input.append("\":\"");
        input.append(fullName);
        input.append("\",");
        input.append("\"");
        input.append("email");
        input.append("\":\"");
        input.append(email);
        input.append("\",");
        input.append("\"");
        input.append("aboutMe");
        input.append("\":\"");
        input.append(aboutMe);
        input.append("\",");
        input.append("\"");
        input.append("phones");
        input.append("\": [{\"phoneType\":\"");
        input.append(phoneType);
        input.append("\",\"phoneNumber\":\"");
        input.append(phoneNumber);
        input.append("\"}],");
        input.append("\"");
        input.append("ims");
        input.append("\": [{\"imType\":\"");
        input.append(imType);
        input.append("\", \"imId\":\"");
        input.append(imId);
        input.append("\"}],");
        input.append("\"");
        input.append("urls");
        input.append("\":[{\"url\":\"");
        input.append(url);
        input.append("\"}]");
        input.append("}");
        this.startSessionAs("john");
        ContainerResponse response = this.getResponse("PATCH", this.getURLResource("users/john/profile"), input.toString());
        UserRestResourcesTest.assertNotNull((Object)response);
        UserRestResourcesTest.assertEquals((String)String.valueOf(response.getEntity()), (int)204, (int)response.getStatus());
        Identity identity = this.identityManager.getOrCreateIdentity("organization", "john");
        UserRestResourcesTest.assertNotNull((Object)identity);
        UserRestResourcesTest.assertEquals((Object)firstName, (Object)identity.getProfile().getProperty("firstName"));
        UserRestResourcesTest.assertEquals((Object)lastName, (Object)identity.getProfile().getProperty("lastName"));
        UserRestResourcesTest.assertEquals((Object)fullName, (Object)identity.getProfile().getProperty("fullName"));
        List phones = identity.getProfile().getPhones();
        UserRestResourcesTest.assertNotNull((Object)phones);
        UserRestResourcesTest.assertEquals((int)1, (int)phones.size());
        UserRestResourcesTest.assertNotNull((String)phoneType, ((Map)phones.get(0)).get("key"));
        UserRestResourcesTest.assertNotNull((String)phoneNumber, ((Map)phones.get(0)).get("value"));
        List ims = (List)identity.getProfile().getProperty("ims");
        UserRestResourcesTest.assertNotNull((Object)ims);
        UserRestResourcesTest.assertEquals((int)1, (int)ims.size());
        UserRestResourcesTest.assertNotNull((String)imType, ((Map)ims.get(0)).get("key"));
        UserRestResourcesTest.assertNotNull((String)imId, ((Map)ims.get(0)).get("value"));
        List urls = (List)identity.getProfile().getProperty("urls");
        UserRestResourcesTest.assertNotNull((Object)urls);
        UserRestResourcesTest.assertEquals((int)1, (int)urls.size());
        UserRestResourcesTest.assertNotNull((String)url, ((Map)urls.get(0)).get("value"));
    }

    private Space getSpaceInstance(int number, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("public");
        space.setRegistration("validation");
        space.setPriority("2");
        space.setGroupId("/spaces/space" + number);
        String[] managers = new String[]{creator};
        String[] members = new String[]{creator};
        space.setManagers(managers);
        space.setMembers(members);
        space.setUrl(space.getPrettyName());
        this.spaceService.createSpace(space, creator);
        return space;
    }
}

