/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.List;
import java.util.Map;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.social.service.rest.LinkShare;
import org.exoplatform.social.service.rest.LinkShareRestService;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class LinkShareRestServiceTest
extends AbstractResourceTest {
    private final String RIGHT_LINK = "hTTp://google.com";
    private final String WRONG_LINK = "http://google.com/ahgo/ahgoeh";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.addResource(LinkShareRestService.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(LinkShareRestService.class);
    }

    public void testJsonRightLink() throws Exception {
        byte[] data = "{\"link\":\"hTTp://google.com\", \"lang\": \"en\"}".getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("POST", "/social/linkshare/show.json", "", (Map<String, List<String>>)h, data, (ContainerResponseWriter)writer);
        LinkShareRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        LinkShareRestServiceTest.assertEquals((String)"application/json;charset=utf-8", (String)response.getContentType().toString());
        LinkShare linkShare = (LinkShare)response.getEntity();
        LinkShareRestServiceTest.assertEquals((String)"hTTp://google.com", (String)linkShare.getLink());
        LinkShareRestServiceTest.assertNotNull((Object)linkShare.getTitle());
    }

    public void testXmlRightLink() throws Exception {
    }

    public void testJsonWrongLink() throws Exception {
        byte[] data = "{\"link\":\"http://google.com/ahgo/ahgoeh\", \"lang\": \"en\"}".getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("POST", "/social/linkshare/show.json", "", (Map<String, List<String>>)h, data, (ContainerResponseWriter)writer);
        LinkShareRestServiceTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testXmlWrongLink() throws Exception {
    }

    public void testBadRequest() throws Exception {
        ContainerResponse response = this.service("GET", "/social/linkshare/show.json", "", null, null);
        LinkShareRestServiceTest.assertEquals((int)405, (int)response.getStatus());
        response = this.service("POST", "/social/linkshare/show.json", "", null, null);
        LinkShareRestServiceTest.assertEquals((int)400, (int)response.getStatus());
    }
}

