/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.identity;

import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.impl.identity.IdentityRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class IdentityRestResourcesTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.identityManager.saveIdentity(new Identity("organization", "root"));
        this.identityManager.saveIdentity(new Identity("organization", "john"));
        this.identityManager.saveIdentity(new Identity("organization", "mary"));
        this.identityManager.saveIdentity(new Identity("organization", "demo"));
        this.addResource(IdentityRestResourcesV1.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(IdentityRestResourcesV1.class);
    }

    public void testGetIdentities() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", "/v1/social/identities?limit=5&offset=0", "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        IdentityRestResourcesTest.assertEquals((int)4, (int)collections.getEntities().size());
    }

    public void testGetCommonConnectionsWithIdentity() throws Exception {
        this.startSessionAs("root");
        Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        Identity johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        Identity maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary");
        this.relationshipManager.inviteToConnect(rootIdentity, johnIdentity);
        this.relationshipManager.inviteToConnect(johnIdentity, maryIdentity);
        this.relationshipManager.confirm(maryIdentity, johnIdentity);
        this.relationshipManager.confirm(johnIdentity, rootIdentity);
        ContainerResponse response = this.service("GET", "/v1/social/identities/" + maryIdentity.getId() + "/commonConnections?returnSize=true", "", null, null);
        IdentityRestResourcesTest.assertNotNull((Object)response);
        IdentityRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        IdentityRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }
}

