/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.ExoFeatureService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ActivityFile;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.ErrorResource;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.api.UserImportResultEntity;
import org.exoplatform.social.rest.api.UserRestResources;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.ExperienceEntity;
import org.exoplatform.social.rest.entity.IMEntity;
import org.exoplatform.social.rest.entity.PhoneEntity;
import org.exoplatform.social.rest.entity.ProfileEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.entity.URLEntity;
import org.exoplatform.social.rest.entity.UserEntity;
import org.exoplatform.social.service.rest.api.models.ActivityRestIn;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.json.JSONException;
import org.json.JSONObject;
import org.picocontainer.Startable;

@Path(value="v1/social/users")
@Api(tags={"v1/social/users"}, value="v1/social/users", description="Operations on users with their activities, connections and spaces")
public class UserRestResourcesV1
implements UserRestResources,
Startable {
    public static final String PROFILE_DEFAULT_BANNER_URL = "/skin/images/banner/DefaultUserBanner.png";
    public static final String PROFILE_DEFAULT_AVATAR_URL = "/skin/images/avatar/DefaultUserAvatar.png";
    private static final int DEFAULT_AVATAR_HASH = (int)(Math.random() * 2.147483647E9);
    private static final int DEFAULT_BANNER_HASH = (int)(Math.random() * 2.147483647E9);
    private static final String ONLINE = "online";
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final Date DEFAULT_IMAGES_LAST_MODIFED = new Date();
    private static final int CACHE_IN_SECONDS = 259200;
    private static final int CACHE_IN_MILLI_SECONDS = 259200000;
    public static final UserFieldValidator USERNAME_VALIDATOR = new UserFieldValidator("userName", true, false);
    public static final UserFieldValidator EMAIL_VALIDATOR = new UserFieldValidator("email", false, false);
    public static final UserFieldValidator LASTNAME_VALIDATOR = new UserFieldValidator("lastName", false, true);
    public static final UserFieldValidator FIRSTNAME_VALIDATOR = new UserFieldValidator("firstName", false, true);
    public static final UserFieldValidator PASSWORD_VALIDATOR = new UserFieldValidator("password", false, false, 8, 255);
    public static final List<UserFieldValidator> USER_FIELD_VALIDATORS = Arrays.asList(USERNAME_VALIDATOR, EMAIL_VALIDATOR, LASTNAME_VALIDATOR, FIRSTNAME_VALIDATOR, PASSWORD_VALIDATOR);
    private static Map<String, UserImportResultEntity> importUsersProcessing = new HashMap<String, UserImportResultEntity>();
    private UserACL userACL;
    private OrganizationService organizationService;
    private IdentityManager identityManager;
    private RelationshipManager relationshipManager;
    private UserStateService userStateService;
    private SpaceService spaceService;
    private static final String INVISIBLE = "invisible";
    private static final Log LOG = ExoLogger.getLogger(UserRestResourcesV1.class);
    private byte[] defaultUserAvatar = null;
    private byte[] defaultUserBanner = null;
    private UploadService uploadService;
    private ExecutorService importExecutorService = null;

    public UserRestResourcesV1(UserACL userACL, OrganizationService organizationService, IdentityManager identityManager, RelationshipManager relationshipManager, UserStateService userStateService, SpaceService spaceService, UploadService uploadService) {
        this.userACL = userACL;
        this.organizationService = organizationService;
        this.identityManager = identityManager;
        this.relationshipManager = relationshipManager;
        this.userStateService = userStateService;
        this.spaceService = spaceService;
        this.uploadService = uploadService;
        this.importExecutorService = Executors.newSingleThreadExecutor();
        CACHE_CONTROL.setMaxAge(259200);
    }

    public void start() {
    }

    public void stop() {
        this.importExecutorService.shutdownNow();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @GET
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets all users", httpMethod="GET", response=Response.class, notes="Using the query param \"q\" to filter the target users, ex: \"q=jo*\" returns all the users beginning by \"jo\".Using the query param \"status\" to filter the target users, ex: \"status=online*\" returns the visible online users.Using the query params \"status\" and \"spaceId\" together to filter the target users, ex: \"status=online*\" and \"spaceId=1*\" returns the visible online users who are member of space with id=1.The params \"status\" and \"spaceId\" cannot be used with \"q\" param since it will falsify the \"limit\" param which is 20 by default. If these 3 parameters are used together, the parameter \"q\" will be ignored")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUsers(@Context UriInfo uriInfo, @ApiParam(value="User name information to filter, ex: user name, last name, first name or full name", required=false) @QueryParam(value="q") String q, @ApiParam(value="User status to filter online users, ex: online", required=false) @QueryParam(value="status") String status, @ApiParam(value="Space id to filter only its members, ex: 1", required=false) @QueryParam(value="spaceId") String spaceId, @ApiParam(value="Exclude external", required=false, defaultValue="false") @QueryParam(value="excludeExternal") boolean excludeExternal, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of users found or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity[] identities;
        String userId;
        try {
            userId = ConversationState.getCurrent().getIdentity().getUserId();
        }
        catch (Exception e) {
            return Response.status((int)401).build();
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            return Response.status((int)401).build();
        }
        if (!(this.userACL.getSuperUser().equals(userId) || RestUtils.isMemberOfAdminGroup() || excludeExternal)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        int totalSize = 0;
        if (StringUtils.isNotBlank((CharSequence)status) && ONLINE.equals(status)) {
            Space space = null;
            if (StringUtils.isNotBlank((CharSequence)spaceId)) {
                space = this.spaceService.getSpaceById(spaceId);
                if (space == null) return EntityBuilder.getResponse(new ErrorResource("space " + spaceId + " does not exist", "space not found"), uriInfo, RestUtils.getJsonMediaType(), Response.Status.NOT_FOUND);
                identities = this.getOnlineIdentitiesOfSpace(userId, space, limit);
            } else {
                identities = this.getOnlineIdentities(userId, limit);
            }
        } else {
            ProfileFilter filter = new ProfileFilter();
            filter.setName(q == null || q.isEmpty() ? "" : q);
            filter.setPosition(q == null || q.isEmpty() ? "" : q);
            filter.setSkills(q == null || q.isEmpty() ? "" : q);
            filter.setExcludeExternal(excludeExternal);
            Identity[] list = this.identityManager.getIdentitiesByProfileFilter("organization", filter, false);
            identities = (Identity[])list.load(offset, limit);
            if (returnSize) {
                totalSize = list.getSize();
            }
        }
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        for (Identity identity : identities) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (!returnSize) return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        collectionUser.setSize(totalSize);
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates a new user", httpMethod="POST", response=Response.class, notes="This creates the user if the authenticated user is in the /platform/administrators group.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input")})
    public Response addUser(@Context UriInfo uriInfo, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="User object to be created, ex:<br />{<br />\"username\": \"john\",<br />\"password\": \"gtngtn\",<br />\"email\": \"john@exoplatform.com\",<br />\"firstname\": \"John\",<br />\"lastname\": \"Smith\"<br />}", required=true) UserEntity model) throws Exception {
        if (model.isNotValid()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Identity identity = this.identityManager.getOrCreateIdentity("organization", model.getUsername());
        if (identity != null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.getUserByEmail(model.getEmail()) != null) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.createUserInstance(model.getUsername());
        user.setFirstName(model.getFirstname());
        user.setLastName(model.getLastname());
        user.setEmail(model.getEmail());
        user.setPassword(model.getPassword() == null || model.getPassword().isEmpty() ? "exo" : model.getPassword());
        userHandler.createUser(user, true);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(model.getUsername(), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific user by user name", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUserById(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity identity = this.identityManager.getOrCreateIdentity("organization", id);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="email/{email}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets a specific user by user email", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUserByEmail(@Context UriInfo uriInfo, @ApiParam(value="User email", required=true) @PathParam(value="email") String email) throws JSONException {
        User user = this.getUserByEmail(email);
        if (user == null) {
            return Response.ok().entity((Object)("{\"id\":\"" + null + "\"}")).build();
        }
        Identity identity = this.identityManager.getOrCreateIdentity("organization", user.getUserName());
        JSONObject jsonProfile = new JSONObject();
        jsonProfile.put("avatarUrl", (Object)identity.getProfile().getAvatarUrl());
        jsonProfile.put("fullName", (Object)identity.getProfile().getFullName());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)identity.toString());
        jsonObject.put("profile", (Object)jsonProfile);
        jsonObject.put("providerId", (Object)identity.getProviderId());
        jsonObject.put("remoteId", (Object)identity.getRemoteId());
        return Response.ok((Object)jsonObject.toString()).build();
    }

    @GET
    @Path(value="{id}/avatar")
    @ApiOperation(value="Gets a specific user avatar by username", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUserAvatarById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @ApiParam(value="URL to default avatar Or '404' to return a 404 http code", required=false) @QueryParam(value="default") String defaultAvatar) throws IOException {
        InputStream stream;
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        Identity identity = isDefault ? null : this.identityManager.getOrCreateIdentity("organization", id);
        Long lastUpdated = null;
        Response.ResponseBuilder builder = null;
        if (!isDefault) {
            if (identity == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            Profile profile = identity.getProfile();
            if (profile != null) {
                lastUpdated = profile.getAvatarLastUpdated();
            }
        }
        EntityTag eTag = null;
        eTag = lastUpdated == null ? new EntityTag(String.valueOf(DEFAULT_AVATAR_HASH)) : new EntityTag(String.valueOf(lastUpdated.hashCode()));
        if (identity != null && identity.isEnable() && !identity.isDeleted() && (builder = request.evaluatePreconditions(eTag)) == null && lastUpdated != null && (stream = this.identityManager.getAvatarInputStream(identity)) != null) {
            builder = Response.ok((Object)stream, (String)"image/png");
        }
        if (builder == null || lastUpdated == null) {
            builder = this.getDefaultAvatarBuilder(defaultAvatar);
        }
        builder.tag(eTag);
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 259200000L));
        }
        return builder.build();
    }

    @GET
    @Path(value="{id}/banner")
    @ApiOperation(value="Gets a specific user banner by username", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=404, message="Resource not found"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=400, message="Invalid query input")})
    public Response getUserBannerById(@Context UriInfo uriInfo, @Context Request request, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @ApiParam(value="URL to default banner Or '404' to return a 404 http code", required=false) @QueryParam(value="default") String defaultBanner) throws IOException {
        InputStream stream;
        boolean isDefault = StringUtils.equals((CharSequence)"default-image", (CharSequence)id);
        Identity identity = isDefault ? null : this.identityManager.getOrCreateIdentity("organization", id);
        Long lastUpdated = null;
        Response.ResponseBuilder builder = null;
        if (!isDefault) {
            if (identity == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            Profile profile = identity.getProfile();
            if (profile != null) {
                lastUpdated = profile.getBannerLastUpdated();
            }
        }
        EntityTag eTag = null;
        eTag = lastUpdated == null ? new EntityTag(String.valueOf(DEFAULT_BANNER_HASH)) : new EntityTag(String.valueOf(lastUpdated.hashCode()));
        if (identity != null && identity.isEnable() && !identity.isDeleted() && (builder = request.evaluatePreconditions(eTag)) == null && lastUpdated != null && (stream = this.identityManager.getBannerInputStream(identity)) != null) {
            builder = Response.ok((Object)stream, (String)"image/png");
        }
        if (builder == null || lastUpdated == null) {
            builder = this.getDefaultBannerBuilder(defaultBanner);
        }
        builder.tag(eTag);
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(lastUpdated == null ? DEFAULT_IMAGES_LAST_MODIFED : new Date(lastUpdated));
        if (StringUtils.isNotBlank((CharSequence)lastModified)) {
            builder.expires(new Date(System.currentTimeMillis() + 259200000L));
        }
        return builder.build();
    }

    @PATCH
    @Path(value="{id}")
    @ApiOperation(value="Update user property", httpMethod="PATCH", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled but not content returned"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=403, message="Unothorized to modify user profile"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateUserProfileAttribute(@ApiParam(value="User name", required=true) @PathParam(value="id") String username, @ApiParam(value="User profile attribute name", required=true) @FormParam(value="name") String name, @ApiParam(value="User profile attribute value", required=true) @FormParam(value="value") String value) throws IOException {
        if (StringUtils.isBlank((CharSequence)name)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'name' parameter is mandatory").build();
        }
        if (value == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'value' parameter is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'username' path parameter is empty").build();
        }
        String currentUser = RestUtils.getCurrentUser();
        if (!StringUtils.equals((CharSequence)currentUser, (CharSequence)username)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Identity userIdentity = RestUtils.getUserIdentity(username);
        Profile profile = userIdentity.getProfile();
        try {
            String fieldName = ProfileEntity.getFieldName(name);
            this.updateProfileField(profile, fieldName, value, true);
        }
        catch (IdentityStorageException e) {
            return Response.serverError().entity((Object)e.getMessageKey()).build();
        }
        catch (Exception e) {
            return Response.serverError().entity((Object)("Can't update avatar, error = " + e.getMessage())).build();
        }
        return Response.noContent().build();
    }

    @PATCH
    @Path(value="{id}/profile")
    @ApiOperation(value="Update set of properties in user profile", httpMethod="PATCH", response=Response.class, notes="This can only be done by the logged in user.")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled but not content returned"), @ApiResponse(code=500, message="Internal server error due to data encoding"), @ApiResponse(code=403, message="Unothorized to modify user profile"), @ApiResponse(code=400, message="Invalid query input")})
    public Response updateUserProfileAttributes(@Context HttpServletRequest request, @ApiParam(value="User name", required=true) @PathParam(value="id") String username, @ApiParam(value="User profile attributes map", required=true) ProfileEntity profileEntity) throws Exception {
        String currentUser;
        String errorMessage;
        if (StringUtils.isBlank((CharSequence)username)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'username' path parameter is empty").build();
        }
        if (profileEntity == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Use profile entity is mandatory").build();
        }
        Locale locale = request == null ? Locale.ENGLISH : request.getLocale();
        String firstName = profileEntity.getFirstname();
        String lastName = profileEntity.getLastname();
        String email = profileEntity.getEmail();
        if (StringUtils.isNotBlank((CharSequence)firstName) && StringUtils.isNotBlank((CharSequence)(errorMessage = FIRSTNAME_VALIDATOR.validate(locale, firstName)))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("FIRSTNAME:" + errorMessage)).build();
        }
        if (StringUtils.isNotBlank((CharSequence)lastName) && StringUtils.isNotBlank((CharSequence)(errorMessage = LASTNAME_VALIDATOR.validate(locale, lastName)))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("LASTNAME:" + errorMessage)).build();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{email})) {
            errorMessage = EMAIL_VALIDATOR.validate(locale, email);
            if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("EMAIL:" + errorMessage)).build();
            }
            Query query = new Query();
            query.setEmail(email);
            ListAccess users = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
            if (users.getSize() > 0 && !StringUtils.equals((CharSequence)((User[])users.load(0, 1))[0].getUserName(), (CharSequence)username)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"EMAIL:ALREADY_EXISTS").build();
            }
        }
        if (!StringUtils.equals((CharSequence)(currentUser = RestUtils.getCurrentUser()), (CharSequence)username)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        String errorMessage2 = this.saveProfile(username, profileEntity);
        if (StringUtils.isNotBlank((CharSequence)errorMessage2)) {
            return Response.ok((Object)errorMessage2).build();
        }
        return Response.noContent().build();
    }

    @Override
    @DELETE
    @Path(value="{id}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Deletes a specific user by user name", httpMethod="DELETE", response=Response.class, notes="This deletes the user if the authenticated user is in the /platform/administrators group.")
    public Response deleteUserById(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        if (!RestUtils.isMemberOfAdminGroup()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        Identity identity = this.identityManager.getOrCreateIdentity("organization", id);
        if (identity == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        this.identityManager.hardDeleteIdentity(identity);
        identity.setDeleted(true);
        UserHandler userHandler = this.organizationService.getUserHandler();
        userHandler.removeUser(id, false);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Updates a specific user by user name", httpMethod="PUT", response=Response.class, notes="This updates the user if he is the authenticated user.")
    public Response updateUserById(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="User object to be updated, ex:<br />{<br />\"username\": \"john\",<br />\"password\": \"gtngtn\",<br />\"email\": \"john@exoplatform.com\",<br />\"firstname\": \"John\",<br />\"lastname\": \"Smith\"<br />}", required=true) UserEntity model) throws Exception {
        UserHandler userHandler = this.organizationService.getUserHandler();
        User user = userHandler.findUserByName(id);
        if (user == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!ConversationState.getCurrent().getIdentity().getUserId().equals(id)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (this.getUserByEmail(model.getEmail()) != null && !user.getUserName().equals(this.getUserByEmail(model.getEmail()).getUserName())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        this.fillUserFromModel(user, model);
        userHandler.saveUser(user, true);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityProfile(id, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/connections")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets connections of a specific user", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    public Response getConnectionsOfUser(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="User name information to filter, ex: user name, last name, first name or full name", required=false) @QueryParam(value="q") String q, @ApiParam(value="Returning the number of connections or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity[] identities;
        Identity target = this.identityManager.getOrCreateIdentity("organization", id);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        int limit = RestUtils.getLimit(uriInfo);
        int offset = RestUtils.getOffset(uriInfo);
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        ProfileFilter profileFilter = new ProfileFilter();
        profileFilter.setName(q);
        ListAccess listAccess = this.relationshipManager.getConnectionsByFilter(target, profileFilter);
        for (Identity identity : identities = (Identity[])listAccess.load(offset, limit)) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="connections/invitations")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets received invitations of current user", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    public Response getInvitationsOfUser(@Context UriInfo uriInfo, @ApiParam(value="Returning the number of connections or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity[] identities;
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity target = this.identityManager.getOrCreateIdentity("organization", currentUser);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        int limit = RestUtils.getLimit(uriInfo);
        int offset = RestUtils.getOffset(uriInfo);
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        ListAccess listAccess = this.relationshipManager.getIncomingWithListAccess(target);
        for (Identity identity : identities = (Identity[])listAccess.load(offset, limit)) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="connections/pending")
    @ApiOperation(value="Gets received invitations of current user", httpMethod="GET", response=Response.class, notes="This can only be done by the logged in user.")
    public Response getPendingOfUser(@Context UriInfo uriInfo, @ApiParam(value="Returning the number of connections or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity[] identities;
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity target = this.identityManager.getOrCreateIdentity("organization", currentUser);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        int limit = RestUtils.getLimit(uriInfo);
        int offset = RestUtils.getOffset(uriInfo);
        ArrayList<DataEntity> profileInfos = new ArrayList<DataEntity>();
        ListAccess listAccess = this.relationshipManager.getOutgoing(target);
        for (Identity identity : identities = (Identity[])listAccess.load(offset, limit)) {
            ProfileEntity profileInfo = EntityBuilder.buildEntityProfile(identity.getProfile(), uriInfo.getPath(), expand);
            profileInfos.add(profileInfo.getDataEntity());
        }
        CollectionEntity collectionUser = new CollectionEntity(profileInfos, "users", offset, limit);
        if (returnSize) {
            collectionUser.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionUser, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/spaces")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets spaces of a specific user", httpMethod="GET", response=Response.class, notes="This returns a list of spaces in the following cases: <br/><ul><li>the given user is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    public Response getSpacesOfUser(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of spaces or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: <em>members</em> or <em>managers</em>", required=false) @QueryParam(value="expand") String expand) throws Exception {
        Identity userIdentity;
        Identity authenticatedUserIdentity;
        Relationship relationship;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity target = this.identityManager.getOrCreateIdentity("organization", id);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!(this.userACL.getSuperUser().equals(authenticatedUser) || authenticatedUser.equals(id) || (relationship = this.relationshipManager.get(authenticatedUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser), userIdentity = this.identityManager.getOrCreateIdentity("organization", id))) != null && relationship.getStatus() == Relationship.Type.CONFIRMED)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ArrayList<DataEntity> spaceInfos = new ArrayList<DataEntity>();
        ListAccess listAccess = ((SpaceService)CommonsUtils.getService(SpaceService.class)).getMemberSpaces(id);
        for (Relationship space : (Relationship)listAccess.load(offset, limit)) {
            SpaceEntity spaceInfo = EntityBuilder.buildEntityFromSpace((Space)space, id, uriInfo.getPath(), expand);
            spaceInfos.add(spaceInfo.getDataEntity());
        }
        CollectionEntity collectionSpace = new CollectionEntity(spaceInfos, "spaces", offset, limit);
        if (returnSize) {
            collectionSpace.setSize(listAccess.getSize());
        }
        return EntityBuilder.getResponse(collectionSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{userId}/spaces/{profileId}")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets commons spaces of current user", httpMethod="GET", response=Response.class, notes="This returns a list of commons spaces in the following cases: <br/><ul><li>the given user is the authenticated user</li><li>the authenticated user is in the group /platform/administrators</li></ul>")
    public Response getCommonSpacesOfUser(@Context UriInfo uriInfo, @ApiParam(value="User Id", required=true) @PathParam(value="userId") String userId, @ApiParam(value="Profile Id", required=true) @PathParam(value="profileId") String profileId, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Returning the number of spaces or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: <em>members</em> or <em>managers</em>", required=false) @QueryParam(value="expand") String expand) throws Exception {
        SpaceEntity spaceInfo;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity currentUser = this.identityManager.getOrCreateIdentity("organization", userId);
        Identity userProfile = this.identityManager.getOrCreateIdentity("organization", profileId);
        if (currentUser == null || userProfile == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (!this.userACL.getSuperUser().equals(authenticatedUser) && !authenticatedUser.equals(userId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        ArrayList<String> userSpaceInfos = new ArrayList<String>();
        ArrayList<String> profileSpaceInfos = new ArrayList<String>();
        ArrayList<DataEntity> commonSpaceInfos = new ArrayList<DataEntity>();
        ListAccess cureentUserListAccess = ((SpaceService)CommonsUtils.getService(SpaceService.class)).getMemberSpaces(userId);
        ListAccess profileUserlistAccess = ((SpaceService)CommonsUtils.getService(SpaceService.class)).getMemberSpaces(profileId);
        for (Space space : (Space[])cureentUserListAccess.load(offset, limit)) {
            spaceInfo = EntityBuilder.buildEntityFromSpace(space, userId, uriInfo.getPath(), expand);
            userSpaceInfos.add(spaceInfo.getId());
        }
        for (Space space : (Space[])profileUserlistAccess.load(offset, limit)) {
            spaceInfo = EntityBuilder.buildEntityFromSpace(space, profileId, uriInfo.getPath(), expand);
            profileSpaceInfos.add(spaceInfo.getId());
        }
        List commonSpacesId = userSpaceInfos.stream().filter(profileSpaceInfos::contains).collect(Collectors.toList());
        for (String id : commonSpacesId) {
            SpaceEntity spaceInfo2 = EntityBuilder.buildEntityFromSpace(this.spaceService.getSpaceById(id), profileId, uriInfo.getPath(), expand);
            commonSpaceInfos.add(spaceInfo2.getDataEntity());
        }
        CollectionEntity collectionCommonSpace = new CollectionEntity(commonSpaceInfos, "spaces", offset, limit);
        if (returnSize) {
            collectionCommonSpace.setSize(commonSpaceInfos.size());
        }
        return EntityBuilder.getResponse(collectionCommonSpace, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @GET
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Gets activities of a specific user", httpMethod="GET", response=Response.class, notes="This returns an activity in the list in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li></ul>")
    public Response getActivitiesOfUser(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Activity stream type, ex: <em>owner, connections, spaces</em> or <em>all</em>", required=false, defaultValue="all") @QueryParam(value="type") String type, @ApiParam(value="Offset", required=false, defaultValue="0") @QueryParam(value="offset") int offset, @ApiParam(value="Limit", required=false, defaultValue="20") @QueryParam(value="limit") int limit, @ApiParam(value="Base time to load older activities (yyyy-MM-dd HH:mm:ss)", required=false) @QueryParam(value="before") String before, @ApiParam(value="Base time to load newer activities (yyyy-MM-dd HH:mm:ss)", required=false) @QueryParam(value="after") String after, @ApiParam(value="Returning the number of activities or not", defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @ApiParam(value="Asking for a full representation of a specific subresource, ex: <em>comments</em> or <em>likes</em>", required=false) @QueryParam(value="expand") String expand) throws Exception {
        ACTIVITY_STREAM_TYPE streamType;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        Identity target = this.identityManager.getOrCreateIdentity("organization", id);
        if (target == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            streamType = ACTIVITY_STREAM_TYPE.valueOf(type);
        }
        catch (Exception e) {
            streamType = ACTIVITY_STREAM_TYPE.all;
        }
        ActivityManager activityManager = (ActivityManager)CommonsUtils.getService(ActivityManager.class);
        RealtimeListAccess listAccess = null;
        List activities = null;
        switch (streamType) {
            case all: {
                listAccess = activityManager.getActivityFeedWithListAccess(target);
                break;
            }
            case owner: {
                listAccess = activityManager.getActivitiesWithListAccess(target);
                break;
            }
            case connections: {
                listAccess = activityManager.getActivitiesOfConnectionsWithListAccess(target);
                break;
            }
            case spaces: {
                listAccess = activityManager.getActivitiesOfUserSpacesWithListAccess(target);
                break;
            }
        }
        activities = after != null && RestUtils.getBaseTime(after) > 0L ? listAccess.loadNewer(Long.valueOf(RestUtils.getBaseTime(after)), limit) : (before != null && RestUtils.getBaseTime(before) > 0L ? listAccess.loadOlder(Long.valueOf(RestUtils.getBaseTime(before)), limit) : listAccess.loadAsList(offset, limit));
        Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ArrayList<DataEntity> activityEntities = new ArrayList<DataEntity>();
        for (ExoSocialActivity activity : activities) {
            DataEntity as = EntityBuilder.getActivityStream(activity, currentUser);
            if (as == null) continue;
            ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, uriInfo.getPath(), expand);
            activityEntity.setActivityStream(as);
            activityEntities.add(activityEntity.getDataEntity());
        }
        CollectionEntity collectionActivity = new CollectionEntity(activityEntities, "activities", offset, limit);
        if (returnSize) {
            if (before != null || after != null) {
                collectionActivity.setSize(activities.size());
            } else {
                collectionActivity.setSize(listAccess.getSize());
            }
        }
        return EntityBuilder.getResponse(collectionActivity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @Override
    @POST
    @Path(value="{id}/activities")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Creates an activity by a specific user", httpMethod="POST", response=Response.class, notes="This creates the activity if the given user is the authenticated user.")
    public Response addActivityByUser(@Context UriInfo uriInfo, @ApiParam(value="User name", required=true) @PathParam(value="id") String id, @ApiParam(value="Asking for a full representation of a specific subresource, ex: <em>comments</em> or <em>likes</em>", required=false) @QueryParam(value="expand") String expand, @ApiParam(value="Activity object to be created, in which the title of activity is required, ex: <br/>{\"title\": \"act4 posted\"}", required=true) ActivityRestIn model) throws Exception {
        if (model == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity target = this.identityManager.getOrCreateIdentity("organization", id);
        if (target == null || !ConversationState.getCurrent().getIdentity().getUserId().equals(id)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle(model.getTitle());
        activity.setBody(model.getBody());
        activity.setType(model.getType());
        activity.setUserId(target.getId());
        if (model.getFiles() != null) {
            activity.setFiles(model.getFiles().stream().map(fileModel -> new ActivityFile(fileModel.getId(), fileModel.getUploadId(), fileModel.getStorage(), fileModel.getDestinationFolder())).collect(Collectors.toList()));
        }
        activity.setTemplateParams(model.getTemplateParams());
        ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).saveActivityNoReturn(target, (ExoSocialActivity)activity);
        this.logMetrics((ExoSocialActivity)activity);
        return EntityBuilder.getResponse(EntityBuilder.buildEntityFromActivity((ExoSocialActivity)activity, uriInfo.getPath(), expand), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="csv")
    @RolesAllowed(value={"administrators"})
    @ApiOperation(value="Import users using CSV file that has a header defining user fields names.exemple of first line of CSV file: userName,firstName,lastName,password,email,groups,aboutMe,timeZone,company,position", httpMethod="POST", response=Response.class)
    public Response importUsers(@Context HttpServletRequest request, @ApiParam(value="CSV File uploadId retrieved after uploading", required=true) @FormParam(value="uploadId") String uploadId, @ApiParam(value="Get processing progress percentage of imported file", required=false, defaultValue="false") @FormParam(value="progress") boolean progress, @ApiParam(value="Whether clean file after processing or not", required=false, defaultValue="false") @FormParam(value="clean") boolean clean, @ApiParam(value="Whether process importing users in a sync or async way of current request", required=false, defaultValue="false") @FormParam(value="sync") boolean sync) {
        if (StringUtils.isBlank((CharSequence)uploadId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"UPLOAD_ID:MANDATORY").build();
        }
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"UPLOAD_ID:NOT_FOUND").build();
        }
        UserImportResultEntity existingImportResult = importUsersProcessing.get(uploadId);
        if (clean || progress) {
            if (existingImportResult == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"UPLOAD_ID_PROGRESS:NOT_FOUND").build();
            }
            if (clean) {
                this.uploadService.removeUploadResource(uploadId);
                importUsersProcessing.remove(uploadId);
            }
            return Response.ok((Object)existingImportResult.clone()).build();
        }
        if (existingImportResult != null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"UPLOAD_ID_PROCESSING:ALREADY_PROCESSING").build();
        }
        Locale locale = request == null ? Locale.ENGLISH : request.getLocale();
        StringBuilder url = new StringBuilder();
        url.append(request.getScheme()).append("://").append(request.getServerName());
        if (request.getServerPort() != 80 && request.getServerPort() != 443) {
            url.append(':').append(request.getServerPort());
        }
        PortalContainer container = PortalContainer.getCurrentInstance((ServletContext)request.getServletContext());
        url.append(container.getPortalContext().getContextPath());
        Response errorResponse = this.importUsers(uploadId, uploadResource.getStoreLocation(), locale, url, sync);
        return errorResponse == null ? Response.noContent().build() : errorResponse;
    }

    private Response importUsers(String uploadId, String fileLocation, Locale locale, StringBuilder url, boolean sync) {
        UserImportResultEntity userImportResultEntity = new UserImportResultEntity();
        importUsersProcessing.put(uploadId, userImportResultEntity);
        try (BufferedReader reader = new BufferedReader(new FileReader(fileLocation));){
            userImportResultEntity.setCount(reader.lines().count() - 1L);
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"UPLOAD_ID_FILE:NOT_FOUND").build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"ERROR_READING_FILE").build();
        }
        if (userImportResultEntity.getCount() < 1L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"BAD_FORMAT:FILE_EMPTY").build();
        }
        if (sync) {
            this.importUsers(fileLocation, userImportResultEntity, locale, url);
        } else {
            this.importUsersAsync(fileLocation, userImportResultEntity, locale, url);
        }
        return null;
    }

    private void importUsersAsync(String fileLocation, UserImportResultEntity userImportResultEntity, Locale locale, StringBuilder url) {
        this.importExecutorService.execute(() -> this.importUsers(fileLocation, userImportResultEntity, locale, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importUsers(String fileLocation, UserImportResultEntity userImportResultEntity, Locale locale, StringBuilder url) {
        try (BufferedReader reader = new BufferedReader(new FileReader(fileLocation));){
            String headerLine = null;
            headerLine = reader.readLine();
            if (StringUtils.isBlank((CharSequence)headerLine)) {
                return;
            }
            List<String> fields = Arrays.asList(headerLine.split(","));
            String userCSVLine = reader.readLine();
            while (userCSVLine != null) {
                block26: {
                    ExoContainerContext.setCurrentContainer((ExoContainer)PortalContainer.getInstance());
                    RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
                    String userName = null;
                    try {
                        userImportResultEntity.incrementProcessed();
                        if (StringUtils.isBlank((CharSequence)userCSVLine)) {
                            userCSVLine = reader.readLine();
                            continue;
                        }
                        userName = this.importUser(userImportResultEntity, locale, url, fields, userCSVLine);
                    }
                    catch (Throwable e) {
                        if (!StringUtils.isNotBlank(userName)) break block26;
                        userImportResultEntity.addErrorMessage(userName, "CREATE_USER_ERROR:" + e.getMessage());
                    }
                    finally {
                        RequestLifeCycle.end();
                        continue;
                    }
                }
                userCSVLine = reader.readLine();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while importing CSV file", (Throwable)e);
        }
    }

    private String importUser(UserImportResultEntity userImportResultEntity, Locale locale, StringBuilder url, List<String> fields, String userCSVLine) throws Exception {
        List<String> userProperties = Arrays.asList(userCSVLine.split(","));
        JSONObject userObject = new JSONObject();
        for (int i = 0; i < fields.size(); ++i) {
            if (i >= userProperties.size()) continue;
            userObject.put(fields.get(i), (Object)userProperties.get(i));
        }
        UserImpl user = EntityBuilder.fromJsonString(userObject.toString(), UserImpl.class);
        String userName = user.getUserName();
        if (StringUtils.isBlank((CharSequence)userName)) {
            userImportResultEntity.addErrorMessage(userName, "BAD_LINE_FORMAT:MISSING_USERNAME");
            return userName;
        }
        if (userProperties.size() != fields.size()) {
            userImportResultEntity.addErrorMessage(userName, "BAD_LINE_FORMAT");
            return userName;
        }
        String errorMessage = null;
        try {
            errorMessage = this.validateUser(userObject, locale);
        }
        catch (Exception e) {
            errorMessage = "USER_VALIDATION_ERROR:" + e.getMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            userImportResultEntity.addErrorMessage(userName, errorMessage);
            return userName;
        }
        boolean onboardUser = !userObject.isNull("onboardUser") && userObject.getString("onboardUser").equals("true");
        User existingUser = this.organizationService.getUserHandler().findUserByName(userName, UserStatus.ANY);
        if (existingUser != null) {
            this.organizationService.getUserHandler().saveUser((User)user, true);
            onboardUser = onboardUser && existingUser.isEnabled() && existingUser.getLastLoginTime().getTime() == existingUser.getCreatedDate().getTime();
        } else {
            existingUser = this.getUserByEmail(user.getEmail());
            if (existingUser != null) {
                userImportResultEntity.addErrorMessage(userName, "EMAIL:ALREADY_EXISTS");
                return userName;
            }
            try {
                this.organizationService.getUserHandler().createUser((User)user, true);
            }
            catch (Exception e) {
                userImportResultEntity.addErrorMessage(userName, "CREATE_USER_ERROR:" + e.getMessage());
                return userName;
            }
        }
        if (!userObject.isNull("groups")) {
            String groups = userObject.getString("groups");
            List<String> groupsList = Arrays.asList(groups.split(";"));
            for (String groupMembershipExpression : groupsList) {
                String membershipType = groupMembershipExpression.contains(":") ? StringUtils.trim((String)groupMembershipExpression.split(":")[0]) : "member";
                String groupId = groupMembershipExpression.contains(":") ? StringUtils.trim((String)groupMembershipExpression.split(":")[1]) : groupMembershipExpression;
                Group groupObject = this.organizationService.getGroupHandler().findGroupById(groupId);
                if (groupObject == null) {
                    userImportResultEntity.addWarnMessage(userName, "GROUP_NOT_EXISTS:" + groupId);
                    continue;
                }
                MembershipType membershipTypeObject = this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType);
                if (membershipTypeObject == null) {
                    userImportResultEntity.addWarnMessage(userName, "MEMBERSHIP_TYPE_NOT_EXISTS:" + membershipType);
                    continue;
                }
                try {
                    this.organizationService.getMembershipHandler().linkMembership((User)user, groupObject, membershipTypeObject, true);
                }
                catch (Exception e) {
                    userImportResultEntity.addWarnMessage(userName, "IMPORT_MEMBERSHIP_ERROR:" + e.getMessage());
                }
            }
        }
        if (onboardUser) {
            PasswordRecoveryService passwordRecoveryService = (PasswordRecoveryService)CommonsUtils.getService(PasswordRecoveryService.class);
            DataStorage dataStorage = (DataStorage)CommonsUtils.getService(DataStorage.class);
            String currentSiteName = CommonsUtils.getCurrentSite().getName();
            try {
                String currentSiteLocale = dataStorage.getPortalConfig(currentSiteName).getLocale();
                locale = new Locale(currentSiteLocale);
            }
            catch (Exception e) {
                LOG.error((Object)"Failure to retrieve portal config", (Throwable)e);
            }
            passwordRecoveryService.sendOnboardingEmail((User)user, locale, url);
        }
        userObject.remove("userName");
        userObject.remove("firstName");
        userObject.remove("lastName");
        userObject.remove("password");
        userObject.remove("email");
        userObject.remove("groups");
        ProfileEntity profileEntity = EntityBuilder.fromJsonString(userObject.toString(), ProfileEntity.class);
        String warnMessage = null;
        try {
            warnMessage = this.saveProfile(userName, profileEntity);
        }
        catch (Exception e) {
            warnMessage = "CREATE_USER_PROFILE_ERROR:" + e.getMessage();
        }
        if (warnMessage != null) {
            userImportResultEntity.addWarnMessage(userName, warnMessage);
        }
        return userName;
    }

    private String validateUser(JSONObject userObject, Locale locale) throws Exception {
        String errorMessage = null;
        Iterator<UserFieldValidator> iterator = USER_FIELD_VALIDATORS.iterator();
        while (iterator.hasNext() && errorMessage == null) {
            UserFieldValidator userFieldValidator = iterator.next();
            String fieldName = userFieldValidator.getField();
            String fieldValue = userObject.getString(fieldName);
            errorMessage = userFieldValidator.validate(locale, fieldValue);
        }
        return errorMessage;
    }

    private void logMetrics(ExoSocialActivity activity) {
        String activityType;
        ExoFeatureService featureService = (ExoFeatureService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoFeatureService.class);
        if (!featureService.isActiveFeature("new-composer")) {
            return;
        }
        if (activity == null) {
            return;
        }
        if (activity.getType() != null) {
            switch (activity.getType()) {
                case "files:spaces": {
                    activityType = "file";
                    break;
                }
                case "LINK_ACTIVITY": {
                    activityType = "link";
                    break;
                }
                default: {
                    activityType = "message";
                    break;
                }
            }
        } else {
            activityType = "message";
        }
        LOG.info("service=composer operation=post parameters=\"composer_type:new,activity_type:{},activity_id:{},user_id:{}\"", new Object[]{activityType, activity.getId(), activity.getPosterId()});
    }

    private String saveProfile(String username, ProfileEntity profileEntity) {
        Identity userIdentity = RestUtils.getUserIdentity(username);
        Profile profile = userIdentity.getProfile();
        try {
            Set profileEntries = profileEntity.getDataEntity().entrySet();
            for (Map.Entry entry : profileEntries) {
                String name = (String)entry.getKey();
                Object value = entry.getValue();
                String fieldName = ProfileEntity.getFieldName(name);
                this.updateProfileField(profile, fieldName, value, false);
            }
            this.identityManager.updateProfile(profile, true);
        }
        catch (IdentityStorageException e) {
            return e.getMessageKey();
        }
        catch (Exception e) {
            return "Can't update profile entities, error = " + e.getMessage();
        }
        return null;
    }

    private void fillUserFromModel(User user, UserEntity model) {
        if (model.getFirstname() != null && !model.getFirstname().isEmpty()) {
            user.setFirstName(model.getFirstname());
        }
        if (model.getLastname() != null && !model.getLastname().isEmpty()) {
            user.setLastName(model.getLastname());
        }
        if (model.getEmail() != null && !model.getEmail().isEmpty()) {
            user.setEmail(model.getEmail());
        }
        if (model.getPassword() != null && !model.getPassword().isEmpty()) {
            user.setPassword(model.getPassword());
        }
    }

    private Identity[] getOnlineIdentitiesOfSpace(String userId, Space space, int limit) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        String[] spaceMembers = space.getMembers();
        String superUserName = this.userACL.getSuperUser();
        for (String user : spaceMembers) {
            UserStateModel userModel = this.userStateService.getUserState(user);
            boolean isOnline = this.userStateService.isOnline(user);
            if (user.equals(userId) || user.equals(superUserName) || userModel == null || INVISIBLE.equals(userModel.getStatus()) || !isOnline) continue;
            Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", user, false);
            identities.add(userIdentity);
            if (identities.size() == limit) break;
        }
        return identities.toArray(new Identity[identities.size()]);
    }

    private Identity[] getOnlineIdentities(String userId, int limit) {
        ArrayList<Identity> identities = new ArrayList<Identity>();
        List users = this.userStateService.online();
        Collections.reverse(users);
        if (users.size() > limit) {
            users = users.subList(0, limit);
        }
        String superUserName = this.userACL.getSuperUser();
        for (UserStateModel userModel : users) {
            String user = userModel.getUserId();
            if (user.equals(userId) || user.equals(superUserName) || userModel == null || INVISIBLE.equals(userModel.getStatus())) continue;
            Identity userIdentity = this.identityManager.getOrCreateIdentity("organization", user, false);
            identities.add(userIdentity);
        }
        return identities.toArray(new Identity[identities.size()]);
    }

    private User getUserByEmail(String email) {
        if (email == null) {
            return null;
        }
        try {
            Query query = new Query();
            query.setEmail(email);
            User[] users = (User[])this.organizationService.getUserHandler().findUsersByQuery(query).load(0, 10);
            return users[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    private Response.ResponseBuilder getDefaultAvatarBuilder(String avatarUrl) throws IOException {
        if (avatarUrl != null) {
            if (avatarUrl.equals("404")) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            try {
                URL url = new URL(avatarUrl);
                String type = url.openConnection().getHeaderField("Content-Type");
                if (type != null && type.startsWith("image/")) {
                    InputStream input = url.openStream();
                    return Response.ok((Object)input, (String)type);
                }
            }
            catch (IOException e) {
                LOG.debug((Object)("Could NOT open the default url " + avatarUrl));
            }
        }
        if (this.defaultUserAvatar == null) {
            InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream(PROFILE_DEFAULT_AVATAR_URL);
            if (is == null) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            this.defaultUserAvatar = IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        return Response.ok((Object)new ByteArrayInputStream(this.defaultUserAvatar), (String)"image/png");
    }

    private Response.ResponseBuilder getDefaultBannerBuilder(String bannerUrl) throws IOException {
        if (bannerUrl != null) {
            if (bannerUrl.equals("404")) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            try {
                URL url = new URL(bannerUrl);
                String type = url.openConnection().getHeaderField("Content-Type");
                if (type != null && type.startsWith("image/")) {
                    InputStream input = url.openStream();
                    return Response.ok((Object)input, (String)type);
                }
            }
            catch (IOException e) {
                LOG.debug((Object)("Could NOT open the default url " + bannerUrl));
            }
        }
        if (this.defaultUserBanner == null) {
            InputStream is = PortalContainer.getInstance().getPortalContext().getResourceAsStream(PROFILE_DEFAULT_BANNER_URL);
            if (is == null) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            this.defaultUserBanner = IOUtil.getStreamContentAsBytes((InputStream)is);
        }
        return Response.ok((Object)new ByteArrayInputStream(this.defaultUserBanner), (String)"image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateProfileField(Profile profile, String name, Object value, boolean save) throws Exception {
        if ("avatar".equals(name) || "banner".equals(name)) {
            UploadResource uploadResource = this.uploadService.getUploadResource(value.toString());
            if (uploadResource == null) {
                throw new IllegalStateException("No uploaded resource found with uploadId = " + value);
            }
            String storeLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(storeLocation);){
                AvatarAttachment attachment = null;
                if ("avatar".equals(name)) {
                    attachment = new AvatarAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
                } else {
                    attachment = new BannerAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.BANNER));
                }
                profile.setProperty(name, (Object)attachment);
                if (!save) return;
                this.identityManager.updateProfile(profile, true);
                return;
            }
            finally {
                this.uploadService.removeUploadResource(value.toString());
            }
        } else if ("ims".equals(name)) {
            List imEntities = (List)value;
            if (imEntities == null || imEntities.isEmpty()) {
                profile.setProperty("ims", Collections.emptyList());
            } else {
                ArrayList imMaps = new ArrayList();
                for (IMEntity imEntity : imEntities) {
                    String imType = imEntity.getImType();
                    String imId = imEntity.getImId();
                    if (StringUtils.isBlank((CharSequence)imId) || StringUtils.isBlank((CharSequence)imType)) continue;
                    HashMap<String, String> imMap = new HashMap<String, String>();
                    imMap.put("key", imType);
                    imMap.put("value", imId);
                    imMaps.add(imMap);
                }
                profile.setProperty("ims", imMaps);
            }
            if (!save) return;
            this.identityManager.updateProfile(profile, true);
            return;
        } else if ("phones".equals(name)) {
            List phoneEntities = (List)value;
            if (phoneEntities == null || phoneEntities.isEmpty()) {
                profile.setProperty("phones", Collections.emptyList());
            } else {
                ArrayList phoneMaps = new ArrayList();
                for (PhoneEntity phoneEntity : phoneEntities) {
                    String phoneType = phoneEntity.getPhoneType();
                    String phoneNumber = phoneEntity.getPhoneNumber();
                    if (StringUtils.isBlank((CharSequence)phoneType) || StringUtils.isBlank((CharSequence)phoneNumber)) continue;
                    HashMap<String, String> phoneMap = new HashMap<String, String>();
                    phoneMap.put("key", phoneType);
                    phoneMap.put("value", phoneNumber);
                    phoneMaps.add(phoneMap);
                }
                profile.setProperty("phones", phoneMaps);
            }
            if (!save) return;
            this.identityManager.updateProfile(profile, true);
            return;
        } else if ("urls".equals(name)) {
            List urlEntities = (List)value;
            if (urlEntities == null || urlEntities.isEmpty()) {
                profile.setProperty("urls", Collections.emptyList());
            } else {
                ArrayList urlMaps = new ArrayList();
                for (URLEntity urlEntity : urlEntities) {
                    String url = urlEntity.getUrl();
                    if (StringUtils.isBlank((CharSequence)url)) continue;
                    HashMap<String, String> urlMap = new HashMap<String, String>();
                    urlMap.put("value", url);
                    urlMaps.add(urlMap);
                }
                profile.setProperty("urls", urlMaps);
            }
            if (!save) return;
            this.identityManager.updateProfile(profile, true);
            return;
        } else if ("experiences".equals(name)) {
            List experienceEntities = (List)value;
            if (experienceEntities == null || experienceEntities.isEmpty()) {
                profile.setProperty("experiences", Collections.emptyList());
            } else {
                ArrayList experienceMaps = new ArrayList();
                for (ExperienceEntity experienceEntity : experienceEntities) {
                    HashMap<String, Object> experienceMap = new HashMap<String, Object>();
                    experienceMap.put("id", experienceEntity.getId());
                    experienceMap.put("company", experienceEntity.getCompany());
                    experienceMap.put("description", experienceEntity.getDescription());
                    experienceMap.put("position", experienceEntity.getPosition());
                    experienceMap.put("skills", experienceEntity.getSkills());
                    experienceMap.put("isCurrent", experienceEntity.getIsCurrent());
                    experienceMap.put("startDate", experienceEntity.getStartDate());
                    experienceMap.put("endDate", experienceEntity.getEndDate());
                    experienceMaps.add(experienceMap);
                }
                profile.setProperty("experiences", experienceMaps);
            }
            if (!save) return;
            this.identityManager.updateProfile(profile, true);
            return;
        } else {
            profile.setProperty(name, value);
            if (!save) return;
            this.identityManager.updateProfile(profile, true);
        }
    }

    public static enum ACTIVITY_STREAM_TYPE {
        all,
        owner,
        connections,
        spaces;

    }
}

