/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import junit.framework.AssertionFailedError;
import org.exoplatform.services.rest.ContainerResponseWriter;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.tools.ByteArrayContainerResponseWriter;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.ActivityStorage;
import org.exoplatform.social.service.rest.PeopleRestService;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class PeopleRestServiceTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private RelationshipManager relationshipManager;
    private ActivityStorage activityStorage;
    private Identity rootIdentity;
    private Identity demoIdentity;
    private Identity maryIdentity;
    private Identity johnIdentity;
    private Identity enableIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.activityStorage = (ActivityStorage)this.getContainer().getComponentInstanceOfType(ActivityStorage.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root", false);
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo", false);
        this.maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary", false);
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john", true);
        this.enableIdentity = this.identityManager.getOrCreateIdentity("organization", "enable", false);
        this.addResource(PeopleRestService.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(PeopleRestService.class);
    }

    public void testSuggestUsernames() throws Exception {
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        String username = "root";
        h.putSingle((Object)"username", (Object)username);
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("GET", "/social/people/suggest.json?nameToSearch=R&currentUser=root", "", (Map<String, List<String>>)h, null, (ContainerResponseWriter)writer);
        PeopleRestServiceTest.assertNotNull((Object)response);
        PeopleRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        PeopleRestServiceTest.assertEquals((String)"application/json;charset=utf-8", (String)response.getContentType().toString());
        if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            throw new AssertionFailedError("Service not found");
        }
    }

    public void testUserMentionInComment() throws Exception {
        String TITLE = "activity on root stream";
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("activity on root stream");
        this.activityStorage.saveActivity(this.demoIdentity, (ExoSocialActivity)demoActivity);
        Relationship relationship = new Relationship(this.rootIdentity, this.maryIdentity);
        relationship.setStatus(Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship);
        MultivaluedMapImpl h2 = new MultivaluedMapImpl();
        String username = "root";
        h2.putSingle((Object)"username", (Object)username);
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("GET", "/social/people/suggest.json?nameToSearch=m&currentUser=root&typeOfRelation=mention_comment&activityId=" + demoActivity.getId() + "&spaceURL=null", "", (Map<String, List<String>>)h2, null, (ContainerResponseWriter)writer);
        PeopleRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        PeopleRestServiceTest.assertTrue((((ArrayList)response.getEntity()).size() == 2 ? 1 : 0) != 0);
        this.relationshipManager.delete(relationship);
    }

    public void testUserMentionInActivityStream() throws Exception {
        Relationship relationship = new Relationship(this.rootIdentity, this.maryIdentity);
        relationship.setStatus(Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship);
        MultivaluedMapImpl h3 = new MultivaluedMapImpl();
        String username = "root";
        h3.putSingle((Object)"username", (Object)username);
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("GET", "/social/people/suggest.json?nameToSearch=m&currentUser=root&typeOfRelation=mention_activity_stream&activityId=null&spaceURL=null", "", (Map<String, List<String>>)h3, null, (ContainerResponseWriter)writer);
        PeopleRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        PeopleRestServiceTest.assertTrue((((ArrayList)response.getEntity()).size() == 2 ? 1 : 0) != 0);
        this.relationshipManager.delete(relationship);
    }

    public void testUserMentionInSpaceComment() throws Exception {
        Relationship relationship = new Relationship(this.rootIdentity, this.maryIdentity);
        relationship.setStatus(Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship);
        Space space = new Space();
        space.setPrettyName("space1");
        space.setDisplayName("space1");
        space.setGroupId("/platform/users");
        space.setVisibility("public");
        space.setManagers(new String[]{this.rootIdentity.getRemoteId()});
        String[] spaceMembers = new String[]{this.rootIdentity.getRemoteId(), this.demoIdentity.getRemoteId()};
        space.setMembers(spaceMembers);
        this.spaceService.createSpace(space, this.rootIdentity.getRemoteId());
        String TITLE = "activity of root in the space activity stream";
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("activity of root in the space activity stream");
        this.activityStorage.saveActivity(this.demoIdentity, (ExoSocialActivity)demoActivity);
        MultivaluedMapImpl h4 = new MultivaluedMapImpl();
        String username = "root";
        h4.putSingle((Object)"username", (Object)username);
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("GET", "/social/people/suggest.json?nameToSearch=m&currentUser=root&typeOfRelation=mention_comment&activityId=" + demoActivity.getId() + "&spaceURL=" + space.getUrl(), "", (Map<String, List<String>>)h4, null, (ContainerResponseWriter)writer);
        PeopleRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        PeopleRestServiceTest.assertTrue((((ArrayList)response.getEntity()).size() == 2 ? 1 : 0) != 0);
        this.spaceService.deleteSpace(space);
        this.relationshipManager.delete(relationship);
    }

    public void testUserMentionInSpaceActivityStream() throws Exception {
        Relationship relationship = new Relationship(this.rootIdentity, this.maryIdentity);
        relationship.setStatus(Relationship.Type.CONFIRMED);
        this.relationshipManager.update(relationship);
        Space space = new Space();
        space.setPrettyName("space1");
        space.setDisplayName("space1");
        space.setGroupId("/platform/users");
        space.setVisibility("public");
        space.setManagers(new String[]{this.rootIdentity.getRemoteId()});
        String[] spaceMembers = new String[]{this.rootIdentity.getRemoteId(), this.demoIdentity.getRemoteId(), this.enableIdentity.getRemoteId()};
        space.setMembers(spaceMembers);
        this.spaceService.createSpace(space, this.rootIdentity.getRemoteId());
        MultivaluedMapImpl h4 = new MultivaluedMapImpl();
        String username = "root";
        h4.putSingle((Object)"username", (Object)username);
        ByteArrayContainerResponseWriter writer = new ByteArrayContainerResponseWriter();
        ContainerResponse response = this.service("GET", "/social/people/suggest.json?nameToSearch=m&currentUser=root&typeOfRelation=mention_activity_stream&activityId=null&spaceURL=" + space.getUrl(), "", (Map<String, List<String>>)h4, null, (ContainerResponseWriter)writer);
        PeopleRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        PeopleRestServiceTest.assertTrue((((ArrayList)response.getEntity()).size() == 2 ? 1 : 0) != 0);
        this.enableIdentity.setEnable(false);
        PeopleRestServiceTest.assertEquals((boolean)false, (boolean)this.enableIdentity.isEnable());
        response = this.service("GET", "/social/people/suggest.json?nameToSearch=enable&currentUser=root&typeOfRelation=mention_activity_stream&activityId=null&spaceURL=" + space.getUrl(), "", (Map<String, List<String>>)h4, null, (ContainerResponseWriter)writer);
        PeopleRestServiceTest.assertEquals((int)200, (int)response.getStatus());
        PeopleRestServiceTest.assertTrue((((ArrayList)response.getEntity()).size() == 0 ? 1 : 0) != 0);
        this.relationshipManager.delete(relationship);
        this.spaceService.deleteSpace(space);
    }
}

