/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest.api;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.service.rest.api.ActivityResources;
import org.exoplatform.social.service.rest.api.models.ActivityRestOut;
import org.exoplatform.social.service.rest.api.models.IdentityRestOut;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.json.JSONWriter;

public class ActivityResourcesTest
extends AbstractResourceTest {
    private final String RESOURCE_URL = "/api/social/v1-alpha3/portal/activity";
    private IdentityManager identityManager;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private SpaceService spaceService;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityManager.saveIdentity(this.rootIdentity);
        this.identityManager.saveIdentity(this.johnIdentity);
        this.identityManager.saveIdentity(this.maryIdentity);
        this.identityManager.saveIdentity(this.demoIdentity);
        this.addResource(ActivityResources.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        this.removeResource(ActivityResources.class);
        super.tearDown();
    }

    public void testGetActivityByIdGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity/1a2b3c4d5e.json";
        this.testAccessResourceAsAnonymous("GET", resourceUrl, null, null);
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl, null);
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/wrongPortalContainerName/activity/1a2b3c4d5e.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity/1a2b3c4d5e.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    public void testPostActivityGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity.json";
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().key("title").value((Object)"hello").endObject();
        byte[] data = writer.getBuffer().toString().getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        this.testAccessResourceAsAnonymous("POST", resourceUrl, (MultivaluedMap<String, String>)h, data);
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/wrongPortalContainerName/activity.json", (MultivaluedMap<String, String>)h, data, Response.Status.BAD_REQUEST.getStatusCode());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().key("title").value((Object)"").endObject();
        data = writer.getBuffer().toString().getBytes("UTF-8");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity.json", (MultivaluedMap<String, String>)h, data, Response.Status.BAD_REQUEST.getStatusCode());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().endObject();
        data = writer.getBuffer().toString().getBytes("UTF-8");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity.json", (MultivaluedMap<String, String>)h, data, Response.Status.BAD_REQUEST.getStatusCode());
        h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/xml");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity.xml", (MultivaluedMap<String, String>)h, data, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    public void testDeleteActivityGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity/12912903.json";
        this.testAccessResourceAsAnonymous("DELETE", resourceUrl, null, null);
        this.testStatusCodeOfResource("demo", "DELETE", "/api/social/v1-alpha3/wrongPortalContainerName/activity/128318387123.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "DELETE", "/api/social/v1-alpha3/portal/activity/2131445234213.json", null, null, Response.Status.NOT_FOUND.getStatusCode());
        this.testStatusCodeOfResource("demo", "DELETE", "/api/social/v1-alpha3/portal/activity/2131445234213.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        String resourceUrlPostDelete = "/api/social/v1-alpha3/portal/activity/destroy/12912903.json";
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)"0");
        this.testAccessResourceAsAnonymous("POST", resourceUrlPostDelete, (MultivaluedMap<String, String>)h, null);
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/wrongPortalContainerName/activity/destroy/128318387123.json", (MultivaluedMap<String, String>)h, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/destroy/2131445234213.json", (MultivaluedMap<String, String>)h, null, Response.Status.NOT_FOUND.getStatusCode());
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/destroy/2131445234213.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    public void testGetCommentsGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity/21381903819082/comments.json";
        this.testAccessResourceAsAnonymous("GET", resourceUrl, null, null);
        this.testAccessNotFoundResourceWithAuthentication("demo", "GET", resourceUrl, null);
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/wrongPortalContainerName/activity/1a2b3c4d5e/comments.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "GET", "/api/social/v1-alpha3/portal/activity/1a2b3c4d5e/comments.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    public void testPostCommentGeneralCase() throws Exception {
        this.createActivities(this.demoIdentity, this.demoIdentity, 1);
        ExoSocialActivity[] activities = (ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity/098129848752/comment.json";
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().key("text").value((Object)"comment for activity").endObject();
        byte[] data = writer.getBuffer().toString().getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        this.testAccessResourceAsAnonymous("POST", resourceUrl, (MultivaluedMap<String, String>)h, data);
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/wrongPortalContainerName/activity/231241312/comment.json", (MultivaluedMap<String, String>)h, data, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/" + activities[0].getId() + "/comment.xml", (MultivaluedMap<String, String>)h, data, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().key("text").value((Object)"").endObject();
        data = writer.getBuffer().toString().getBytes("UTF-8");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/" + activities[0].getId() + "/comment.json", (MultivaluedMap<String, String>)h, data, Response.Status.BAD_REQUEST.getStatusCode());
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().endObject();
        data = writer.getBuffer().toString().getBytes("UTF-8");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/" + activities[0].getId() + "/comment.json", (MultivaluedMap<String, String>)h, data, Response.Status.BAD_REQUEST.getStatusCode());
    }

    public void testDeleteCommentGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity/12912903/comment/293984912.json";
        this.testAccessResourceAsAnonymous("DELETE", resourceUrl, null, null);
        this.testStatusCodeOfResource("demo", "DELETE", "/api/social/v1-alpha3/wrongPortalContainerName/activity/128318387123/comment/2304982984.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "DELETE", "/api/social/v1-alpha3/portal/activity/128318387123/comment/2131445234213.json", null, null, Response.Status.NOT_FOUND.getStatusCode());
        this.testStatusCodeOfResource("demo", "DELETE", "/api/social/v1-alpha3/portal/activity/1a2b3c4d5e/comment/2131445234213.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        String resourceUrlPostDelete = "/api/social/v1-alpha3/portal/activity/24802934/comment/destroy/12912903.json";
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)"0");
        this.testAccessResourceAsAnonymous("POST", resourceUrlPostDelete, (MultivaluedMap<String, String>)h, null);
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/wrongPortalContainerName/activity/128318387123/comment/destroy/128318387123.json", (MultivaluedMap<String, String>)h, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/128318387123/comment/destroy/2131445234213.json", (MultivaluedMap<String, String>)h, null, Response.Status.NOT_FOUND.getStatusCode());
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/1a2b3c4d5e/comment/destroy/2131445234213.xml", (MultivaluedMap<String, String>)h, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    public void testPostLikeGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity/1a2b3c4e5e/like.json";
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)"0");
        this.testAccessResourceAsAnonymous("POST", resourceUrl, null, null);
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/wrongPortalContainerName/activity/1a2b3c4e5e/like.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/1a2b3c4d5e/like.xml", (MultivaluedMap<String, String>)h, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    public void testDeleteLikeGeneralCase() throws Exception {
        String resourceUrl = "/api/social/v1-alpha3/portal/activity/12912903/like.json";
        this.testAccessResourceAsAnonymous("DELETE", resourceUrl, null, null);
        this.testStatusCodeOfResource("demo", "DELETE", "/api/social/v1-alpha3/wrongPortalContainerName/activity/1a2b3c4e5e/like.json", null, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "DELETE", "/api/social/v1-alpha3/portal/activity/1a2b3c4e5e/like.xml", null, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
        String resourceUrlPostDelete = "/api/social/v1-alpha3/portal/activity/213123/like/destroy.json";
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)"0");
        this.testAccessResourceAsAnonymous("POST", resourceUrlPostDelete, (MultivaluedMap<String, String>)h, null);
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/wrongPortalContainerName/activity/13123123/like/destroy.json", (MultivaluedMap<String, String>)h, null, Response.Status.BAD_REQUEST.getStatusCode());
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/13123123/like/destroy.json", (MultivaluedMap<String, String>)h, null, Response.Status.NOT_FOUND.getStatusCode());
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity/1a2b3c4d5e/like/destroy.xml", (MultivaluedMap<String, String>)h, null, Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode());
    }

    public void testGetActivityByIdWithJsonFormat() throws Exception {
        this.createActivities(this.demoIdentity, this.demoIdentity, 1);
        ExoSocialActivity demoActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        this.activityManager.saveLike(demoActivity, this.demoIdentity);
        this.activityManager.saveLike(demoActivity, this.maryIdentity);
        this.activityManager.saveLike(demoActivity, this.johnIdentity);
        this.activityManager.saveLike(demoActivity, this.rootIdentity);
        this.createComment(demoActivity, this.demoIdentity, 30);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        String resourceUrl = "/api/social/v1-alpha3/portal/activity/" + demoActivity.getId() + ".json";
        demoActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        this.startSessionAs("demo");
        ContainerResponse containerResponse = this.service("GET", resourceUrl, "", null, null);
        ActivityResourcesTest.assertEquals((String)"containerResponse.getStatus() must return 200", (int)200, (int)containerResponse.getStatus());
        ActivityResourcesTest.assertTrue((String)("Type of response's content must be: " + MediaType.APPLICATION_JSON_TYPE), (boolean)containerResponse.getContentType().toString().startsWith(MediaType.APPLICATION_JSON_TYPE.toString()));
        HashMap entity = (HashMap)containerResponse.getEntity();
        this.compareActivity(demoActivity, entity);
        String posterIdentityResourceUrl = resourceUrl + "?poster_identity=true";
        this.startSessionAs("john");
        ContainerResponse containerResponse2 = this.service("GET", posterIdentityResourceUrl, "", null, null);
        ActivityResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        HashMap entity2 = (HashMap)containerResponse2.getEntity();
        this.compareActivity(demoActivity, entity2);
        this.compareIdentity(this.demoIdentity, (HashMap)entity2.get("posterIdentity"));
        this.startSessionAs("john");
        this.createComment(demoActivity, this.johnIdentity, 30);
        String numberOfCommentsResourceUrl = resourceUrl + "?number_of_comments=20";
        containerResponse2 = this.service("GET", numberOfCommentsResourceUrl, "", null, null);
        ActivityResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        entity2 = (HashMap)containerResponse2.getEntity();
        this.compareActivity(demoActivity, entity2);
        ArrayList comments = (ArrayList)entity2.get("comments");
        ActivityResourcesTest.assertEquals((int)20, (int)comments.size());
        posterIdentityResourceUrl = resourceUrl + "?activity_stream=1";
        this.startSessionAs("john");
        containerResponse2 = this.service("GET", posterIdentityResourceUrl, "", null, null);
        ActivityResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        entity2 = (HashMap)containerResponse2.getEntity();
        ActivityResourcesTest.assertNotNull((String)"entity must not be null", (Object)entity2);
        HashMap activityStream = (HashMap)entity2.get("activityStream");
        this.compareActivity(demoActivity, entity2);
        this.compareActivityStream(demoActivity.getActivityStream(), activityStream);
        posterIdentityResourceUrl = resourceUrl + "?number_of_likes=2";
        this.startSessionAs("john");
        containerResponse2 = this.service("GET", posterIdentityResourceUrl, "", null, null);
        ActivityResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        entity2 = (HashMap)containerResponse2.getEntity();
        ActivityResourcesTest.assertNotNull((String)"entity must not be null", (Object)entity2);
        ArrayList likedByIdentities = (ArrayList)entity2.get("likedByIdentities");
        this.compareActivity(demoActivity, entity2);
        this.compareNumberOfLikes(demoActivity, (ActivityRestOut)entity2, 2);
        this.startSessionAs("john");
        String allOfOptionalParamsResourceUrl = resourceUrl + "?poster_identity=true&number_of_comments=20&activity_stream=1&?number_of_likes=2";
        containerResponse2 = this.service("GET", allOfOptionalParamsResourceUrl, "", null, null);
        ActivityResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        entity2 = (HashMap)containerResponse2.getEntity();
        this.compareActivity(demoActivity, entity2);
        activityStream = (HashMap)entity2.get("activityStream");
        this.compareActivityStream(demoActivity.getActivityStream(), activityStream);
        ArrayList comments2 = (ArrayList)entity2.get("comments");
        ActivityResourcesTest.assertEquals((int)20, (int)comments2.size());
        for (HashMap comment : comments2) {
            IdentityRestOut identityRestOut = (IdentityRestOut)comment.get("posterIdentity");
            ActivityResourcesTest.assertEquals((String)"demo", (String)identityRestOut.getRemoteId());
        }
        this.createSpaces(1);
        Space space = this.spaceService.getSpaceByPrettyName("my_space_1");
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", "my_space_1", false);
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title");
        activity.setAppId("appId");
        activity.setType("type");
        activity.setPriority(Float.valueOf(0.5f));
        activity.setTitleId("title id");
        activity.setUserId(this.demoIdentity.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key1", "value1");
        params.put("key2", "value2");
        activity.setTemplateParams(params);
        this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        this.testStatusCodeOfResource("john", "GET", "/api/social/v1-alpha3/portal/activity/" + activity.getId() + ".json", null, null, Response.Status.FORBIDDEN.getStatusCode());
        this.startSessionAs("john");
        allOfOptionalParamsResourceUrl = resourceUrl + "?poster_identity=true&number_of_comments=-10&activity_stream=1&?number_of_likes=-10";
        containerResponse2 = this.service("GET", allOfOptionalParamsResourceUrl, "", null, null);
        ActivityResourcesTest.assertEquals((String)"containerResponse.getStatus() must return: 200", (int)200, (int)containerResponse2.getStatus());
        entity2 = (HashMap)containerResponse2.getEntity();
        this.compareActivity(demoActivity, entity2);
        activityStream = (HashMap)entity2.get("activityStream");
        this.compareActivityStream(demoActivity.getActivityStream(), activityStream);
        comments2 = (ArrayList)entity2.get("comments");
        ActivityResourcesTest.assertEquals((int)0, (int)comments2.size());
        this.compareNumberOfLikes(demoActivity, (ActivityRestOut)entity2, 0);
    }

    public void testCreateNewActivityForAccess() throws Exception {
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().key("title").value((Object)"hello world").endObject();
        byte[] data = writer.getBuffer().toString().getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity.json?identity_id=" + this.maryIdentity.getId(), (MultivaluedMap<String, String>)h, data, Response.Status.FORBIDDEN.getStatusCode());
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.testStatusCodeOfResource("demo", "POST", "/api/social/v1-alpha3/portal/activity.json?identity_id=" + this.maryIdentity.getId(), (MultivaluedMap<String, String>)h, data, Response.Status.OK.getStatusCode());
    }

    public void testDeleteActivityWithJsonFormat() throws Exception {
        this.startSessionAs("demo");
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title");
        activity.setAppId("appId");
        activity.setType("type");
        activity.setPriority(Float.valueOf(0.5f));
        activity.setTitleId("title id");
        activity.setUserId(this.demoIdentity.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key1", "value1");
        params.put("key2", "value2");
        activity.setTemplateParams(params);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivity got1 = this.activityManager.getActivity(activity.getId());
        ActivityResourcesTest.assertNotNull((Object)got1);
        this.testStatusCodeOfResource("mary", "DELETE", "/api/social/v1-alpha3/portal/activity/" + activity.getId() + ".json", null, null, Response.Status.FORBIDDEN.getStatusCode());
        this.startSessionAs("demo");
        ContainerResponse response = this.service("DELETE", "/api/social/v1-alpha3/portal/activity/" + activity.getId() + ".json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap activityRest = (HashMap)response.getEntity();
        ActivityResourcesTest.assertEquals((Object)got1.getId(), activityRest.get("id"));
        ActivityResourcesTest.assertEquals(null, (Object)this.activityManager.getActivity(activity.getId()));
    }

    public void testDeletePOSTActivityWithJsonFormat() throws Exception {
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        activity.setTitle("title");
        activity.setAppId("appId");
        activity.setType("type");
        activity.setPriority(Float.valueOf(0.5f));
        activity.setTitleId("title id");
        activity.setUserId(this.johnIdentity.getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("key1", "value1");
        params.put("key2", "value2");
        activity.setTemplateParams(params);
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)activity);
        ExoSocialActivity got1 = this.activityManager.getActivity(activity.getId());
        ActivityResourcesTest.assertNotNull((Object)got1);
        this.testStatusCodeOfResource("mary", "POST", "/api/social/v1-alpha3/portal/activity/destroy/" + activity.getId() + ".json", null, null, Response.Status.FORBIDDEN.getStatusCode());
        this.startSessionAs("john");
        this.connectIdentities(this.johnIdentity, this.rootIdentity, true);
        ContainerResponse response = this.service("POST", "/api/social/v1-alpha3/portal/activity/destroy/" + activity.getId() + ".json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap activityRest = (HashMap)response.getEntity();
        ActivityResourcesTest.assertEquals((Object)got1.getId(), activityRest.get("id"));
        try {
            ActivityResourcesTest.assertEquals(null, (Object)this.activityManager.getActivity(activity.getId()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testCreateNewActivityWithJsonFormat() throws Exception {
        this.startSessionAs("john");
        String title = "hello !";
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().key("title").value((Object)title).endObject();
        byte[] data = writer.getBuffer().toString().getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        ContainerResponse response = this.service("POST", "/api/social/v1-alpha3/portal/activity.json?identity_id=" + this.johnIdentity.getId(), "", (MultivaluedMap<String, String>)h, data);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        ActivityResourcesTest.assertNotNull((Object)response.getEntity());
        if (!(response.getEntity() instanceof HashMap)) {
            ActivityResourcesTest.fail();
        }
        HashMap got = (HashMap)response.getEntity();
        ActivityResourcesTest.assertNotNull(got.get("id"));
        ActivityResourcesTest.assertEquals((Object)this.johnIdentity.getId(), got.get("identityId"));
        ActivityResourcesTest.assertEquals((Object)title, got.get("title"));
    }

    public void testCreateLikeActivityById() throws Exception {
        this.createActivities(this.demoIdentity, this.demoIdentity, 1);
        ExoSocialActivity expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        this.startSessionAs("demo");
        ContainerResponse response = this.service("POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/like.json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        ActivityResourcesTest.assertEquals((String)"The activity liked array must contain Demo's IdentityID", (String)expectedActivity.getLikeIdentityIds()[0], (String)this.demoIdentity.getId());
        this.connectIdentities(this.demoIdentity, this.rootIdentity, true);
        this.startSessionAs("root");
        response = this.service("POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/like.json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap got = (HashMap)response.getEntity();
        ActivityResourcesTest.assertEquals((Object)true, got.get("liked"));
        expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        String[] likeIdentityIds = expectedActivity.getLikeIdentityIds();
        ActivityResourcesTest.assertEquals((int)2, (int)likeIdentityIds.length);
        ActivityResourcesTest.assertTrue((String)"The activity liked array must contain Demo's IdentityID", (boolean)Arrays.asList(likeIdentityIds).contains(this.demoIdentity.getId()));
        ActivityResourcesTest.assertTrue((String)"The activity liked array must contain Root's IdentityID", (boolean)Arrays.asList(likeIdentityIds).contains(this.rootIdentity.getId()));
        this.testStatusCodeOfResource("mary", "POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/like.json", null, null, Response.Status.FORBIDDEN.getStatusCode());
    }

    public void testGetLikedIdentities() throws Exception {
        this.createActivities(this.demoIdentity, this.demoIdentity, 1);
        ExoSocialActivity expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        this.activityManager.saveLike(expectedActivity, this.rootIdentity);
        this.activityManager.saveLike(expectedActivity, this.demoIdentity);
        this.activityManager.saveLike(expectedActivity, this.johnIdentity);
        this.activityManager.saveLike(expectedActivity, this.maryIdentity);
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/likes.json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap got = (HashMap)response.getEntity();
        ActivityResourcesTest.assertEquals((String)"Number of liked Identities must equal 4", (Object)4, got.get("totalNumberOfLikes"));
        ArrayList identityArrayList = (ArrayList)got.get("likesByIdentities");
        List likersIds = identityArrayList.stream().map(liker -> liker.get("id")).collect(Collectors.toList());
        ActivityResourcesTest.assertTrue((boolean)likersIds.contains(this.maryIdentity.getId()));
        ActivityResourcesTest.assertTrue((boolean)likersIds.contains(this.johnIdentity.getId()));
        ActivityResourcesTest.assertTrue((boolean)likersIds.contains(this.demoIdentity.getId()));
        ActivityResourcesTest.assertTrue((boolean)likersIds.contains(this.rootIdentity.getId()));
    }

    public void testDeleteLikeActivityById() throws Exception {
        String[] likedIdentityIds;
        this.testCreateLikeActivityById();
        ExoSocialActivity expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        this.startSessionAs("demo");
        ActivityResourcesTest.assertEquals((String)"Number of user liked this Activty must be 2", (int)2, (int)expectedActivity.getLikeIdentityIds().length);
        ContainerResponse response = this.service("DELETE", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/like.json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        ActivityResourcesTest.assertEquals((String)"Number of user liked this Activty must be 1", (int)1, (int)expectedActivity.getLikeIdentityIds().length);
        String demoIdentiyID = this.demoIdentity.getId();
        for (String likedUserIdentityID : likedIdentityIds = expectedActivity.getLikeIdentityIds()) {
            if (!likedUserIdentityID.equals(demoIdentiyID)) continue;
            ActivityResourcesTest.fail((String)"Demo's IdentityId must be deleted from getLikeIdentityIds");
        }
        this.testStatusCodeOfResource("mary", "DELETE", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/like.json", null, null, Response.Status.FORBIDDEN.getStatusCode());
        this.startSessionAs("root");
        response = this.service("POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/like/destroy.json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.demoIdentity).load(0, 1))[0];
        ActivityResourcesTest.assertEquals((String)"Number of user liked this Activty must be 0", (int)0, (int)expectedActivity.getLikeIdentityIds().length);
        HashMap got = (HashMap)response.getEntity();
        ActivityResourcesTest.assertEquals((Object)false, got.get("liked"));
        String rootIdentiyID = this.rootIdentity.getId();
        for (String likedUserIdentityID : likedIdentityIds = expectedActivity.getLikeIdentityIds()) {
            if (!likedUserIdentityID.equals(rootIdentiyID)) continue;
            ActivityResourcesTest.fail((String)"Root's IdentityId must be deleted from getLikeIdentityIds");
        }
        this.testStatusCodeOfResource("mary", "POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/like/destroy.json", null, null, Response.Status.FORBIDDEN.getStatusCode());
    }

    public void testCreateComment() throws Exception {
        this.createActivities(this.johnIdentity, this.maryIdentity, 1);
        this.connectIdentities(this.johnIdentity, this.maryIdentity, true);
        this.connectIdentities(this.demoIdentity, this.maryIdentity, true);
        this.connectIdentities(this.demoIdentity, this.johnIdentity, true);
        ExoSocialActivity expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.johnIdentity).load(0, 1))[0];
        this.startSessionAs("mary");
        StringWriter writer = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().key("text").value((Object)"mary comment to john's activity").endObject();
        byte[] data = writer.getBuffer().toString().getBytes("UTF-8");
        MultivaluedMapImpl h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        ContainerResponse response = this.service("POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/comment.json", "", (MultivaluedMap<String, String>)h, data);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap got = (HashMap)response.getEntity();
        ActivityResourcesTest.assertEquals((Object)"mary comment to john's activity", got.get("text"));
        this.startSessionAs("demo");
        writer = new StringWriter();
        jsonWriter = new JSONWriter((Writer)writer);
        jsonWriter.object().key("text").value((Object)"demo comment to john's activity").endObject();
        data = writer.getBuffer().toString().getBytes("UTF-8");
        h = new MultivaluedMapImpl();
        h.putSingle((Object)"content-type", (Object)"application/json");
        h.putSingle((Object)"content-length", (Object)("" + data.length));
        response = this.service("POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/comment.json", "", (MultivaluedMap<String, String>)h, data);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        this.testStatusCodeOfResource("root", "POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/comment.json", (MultivaluedMap<String, String>)h, data, Response.Status.FORBIDDEN.getStatusCode());
    }

    public void testGetComments() throws Exception {
        this.testCreateComment();
        ExoSocialActivity expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.maryIdentity).load(0, 1))[0];
        this.startSessionAs("john");
        ContainerResponse response = this.service("GET", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/comments.json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap resultEntity = (HashMap)response.getEntity();
        ArrayList comments = (ArrayList)resultEntity.get("comments");
        ActivityResourcesTest.assertEquals((String)"totalNumberOfComments of user liked this Activty must be 2", (Object)2, resultEntity.get("totalNumberOfComments"));
        ActivityResourcesTest.assertEquals((String)"Number of comments this Activty must be 2", (int)2, (int)comments.size());
        this.compareIdentity(this.maryIdentity, (HashMap)((HashMap)comments.get(0)).get("posterIdentity"));
        ActivityResourcesTest.assertEquals((String)"John's comment text must be \"mary comment to john's activity\"", (String)"mary comment to john's activity", (String)StringEscapeUtils.unescapeHtml((String)((HashMap)comments.get(0)).get("text").toString()));
        this.compareIdentity(this.demoIdentity, (HashMap)((HashMap)comments.get(1)).get("posterIdentity"));
        ActivityResourcesTest.assertEquals((String)"Demo's comment text must be \"demo comment to john's activity\"", (String)"demo comment to john's activity", (String)StringEscapeUtils.unescapeHtml((String)((HashMap)comments.get(1)).get("text").toString()));
    }

    public void testDeleteComment() throws Exception {
        this.testCreateComment();
        ExoSocialActivity expectedActivity = ((ExoSocialActivity[])this.activityManager.getActivitiesWithListAccess(this.maryIdentity).load(0, 1))[0];
        RealtimeListAccess commentActivitysListAccess = this.activityManager.getCommentsWithListAccess(expectedActivity);
        ActivityResourcesTest.assertEquals((String)"commentActivitys Size must be equal 2", (int)2, (int)commentActivitysListAccess.getSize());
        ExoSocialActivity[] commentActivitys = (ExoSocialActivity[])commentActivitysListAccess.load(0, 2);
        this.testStatusCodeOfResource("root", "POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/comment/destroy/" + commentActivitys[1].getId() + ".json", null, null, Response.Status.FORBIDDEN.getStatusCode());
        this.startSessionAs("mary");
        ContainerResponse response = this.service("DELETE", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/comment/" + commentActivitys[0].getId() + ".json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        HashMap entity = (HashMap)response.getEntity();
        ActivityResourcesTest.assertEquals((String)("The id of response activity must be equal: " + commentActivitys[0].getId()), (Object)commentActivitys[0].getId(), entity.get("id"));
        commentActivitysListAccess = this.activityManager.getCommentsWithListAccess(expectedActivity);
        ActivityResourcesTest.assertEquals((String)"commentActivitys Size must be equal 1", (int)1, (int)commentActivitysListAccess.getSize());
        this.startSessionAs("demo");
        response = this.service("POST", "/api/social/v1-alpha3/portal/activity/" + expectedActivity.getId() + "/comment/destroy/" + commentActivitys[1].getId() + ".json", "", null, null);
        ActivityResourcesTest.assertEquals((int)Response.Status.OK.getStatusCode(), (int)response.getStatus());
        entity = (HashMap)response.getEntity();
        ActivityResourcesTest.assertEquals((String)("The id of response activity must be equal: " + commentActivitys[0].getId()), (Object)commentActivitys[1].getId(), entity.get("id"));
        commentActivitysListAccess = this.activityManager.getCommentsWithListAccess(expectedActivity);
        ActivityResourcesTest.assertEquals((String)"commentActivitys Size must be equal 0", (int)0, (int)commentActivitysListAccess.getSize());
    }

    private void createActivities(Identity posterIdentity, Identity identityStream, int number) {
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
            activity.setType("exosocial:core");
            activity.setTitle("title " + i);
            activity.setUserId(posterIdentity.getId());
            this.activityManager.saveActivityNoReturn(identityStream, (ExoSocialActivity)activity);
            activity = this.activityManager.getActivity(activity.getId());
        }
    }

    private void createComment(ExoSocialActivity existingActivity, Identity posterIdentity, int number) {
        int maxActivities = 20;
        for (int i = 0; i < number; ++i) {
            ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
            comment.setTitle("comment " + i);
            comment.setUserId(posterIdentity.getId());
            this.activityManager.saveComment(existingActivity, (ExoSocialActivity)comment);
            comment = (ExoSocialActivity)this.activityManager.getCommentsWithListAccess(existingActivity).loadAsList(0, maxActivities).get(0);
        }
    }

    private void createSpaces(int number) {
        for (int i = 0; i < number; ++i) {
            Space space = new Space();
            space.setDisplayName("my space " + number);
            space.setPrettyName(space.getDisplayName());
            space.setRegistration("open");
            space.setDescription("add new space " + number);
            space.setType("classic");
            space.setVisibility("public");
            space.setRegistration("validation");
            space.setPriority("2");
            space.setGroupId("/space/space" + number);
            String[] managers = new String[]{"demo"};
            String[] members = new String[]{"demo", "mary"};
            String[] invitedUsers = new String[]{"john"};
            String[] pendingUsers = new String[]{};
            space.setInvitedUsers(invitedUsers);
            space.setPendingUsers(pendingUsers);
            space.setManagers(managers);
            space.setMembers(members);
            space.setUrl("/space/" + space.getPrettyName());
            try {
                this.spaceService.saveSpace(space, true);
                continue;
            }
            catch (SpaceException e) {
                ActivityResourcesTest.fail((String)"Could not create a new space");
            }
        }
    }

    private void connectIdentities(Identity senderIdentity, Identity receiverIdentity, boolean beConfirmed) {
        this.relationshipManager.inviteToConnect(senderIdentity, receiverIdentity);
        if (beConfirmed) {
            this.relationshipManager.confirm(receiverIdentity, senderIdentity);
        }
    }
}

