/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.space;

import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.space.spi.SpaceTemplateService;
import org.exoplatform.social.mock.MockUploadService;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.SpaceEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.rest.impl.space.SpaceRestResourcesV1;
import org.exoplatform.social.rest.impl.spacetemplates.SpaceTemplatesRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.exoplatform.upload.UploadService;

public class SpaceRestResourcesTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private OrganizationService organizationService;
    private UserACL userACL;
    private ActivityManager activityManager;
    private SpaceService spaceService;
    private SpaceRestResourcesV1 spaceRestResources;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;
    private Identity externalUserIdentity;
    private MockUploadService uploadService;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        this.organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        this.uploadService = (MockUploadService)((Object)this.getContainer().getComponentInstanceOfType(UploadService.class));
        this.rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root");
        this.johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john");
        this.maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary");
        this.demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo");
        this.spaceRestResources = new SpaceRestResourcesV1(new ActivityRestResourcesV1(this.activityManager, this.identityManager, this.spaceService, null), this.spaceService, this.identityManager, (UploadService)this.uploadService);
        this.registry(this.spaceRestResources);
        SpaceTemplatesRestResourcesV1 spaceTemplatesRestResourcesV1 = new SpaceTemplatesRestResourcesV1((SpaceTemplateService)this.getContainer().getComponentInstanceOfType(SpaceTemplateService.class), (ConfigurationManager)this.getContainer().getComponentInstanceOfType(ConfigurationManager.class));
        this.registry(spaceTemplatesRestResourcesV1);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(this.spaceRestResources.getClass());
    }

    public void testSpaceDisplayNameUpdateWithDifferentCases() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance(1, "root");
        ContainerResponse response = null;
        String inputWithCorrectName = "{\"displayName\":\"social\",\"visibility\":\"hidden\",\"subscription\":\"open\"}";
        String inputWithSpecialCharacter = "{\"displayName\":\"~#Social~#\",\"visibility\":\"hidden\",\"subscription\":\"open\"}";
        String inputWithAndCharacter = "{\"displayName\":\"social & social\",\"visibility\":\"hidden\",\"subscription\":\"open\"}";
        response = this.getResponse("PUT", this.getURLResource("spaces/" + space.getId()), inputWithCorrectName);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.getResponse("PUT", this.getURLResource("spaces/" + space.getId()), inputWithSpecialCharacter);
        SpaceRestResourcesTest.assertEquals((int)500, (int)response.getStatus());
        response = this.getResponse("PUT", this.getURLResource("spaces/" + space.getId()), inputWithAndCharacter);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testSpaceVisibilityUpdateWithDifferentCases() throws Exception {
        this.startSessionAs("root");
        Space space = this.getSpaceInstance(1, "root");
        HashMap<String, String> listOfResponses = new HashMap<String, String>(){
            {
                this.put("{\"displayName\":\"social\",\"visibility\":PRIVATE}", "private");
                this.put("{\"displayName\":\"social\",\"visibility\":private}", "private");
                this.put("{\"displayName\":\"social\",\"visibility\":PriVatE}", "private");
                this.put("{\"displayName\":\"social\",\"visibility\":HIDDEN}", "hidden");
                this.put("{\"displayName\":\"social\",\"visibility\":hidden}", "hidden");
                this.put("{\"displayName\":\"social\",\"visibility\":HiDdEn}", "hidden");
            }
        };
        ContainerResponse response = null;
        for (Map.Entry entry : listOfResponses.entrySet()) {
            String input = (String)entry.getKey();
            String expectedOutput = (String)entry.getValue();
            response = this.getResponse("PUT", this.getURLResource("spaces/" + space.getId()), input);
            SpaceRestResourcesTest.assertNotNull((Object)response);
            SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
            SpaceEntity spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
            SpaceRestResourcesTest.assertEquals((String)expectedOutput, (String)spaceEntity.getVisibility());
        }
    }

    public void testGetSpaces() throws Exception {
        Space rootSpace = this.getSpaceInstance(1, "root");
        Space johnSpace = this.getSpaceInstance(2, "john");
        Space demoSpace = this.getSpaceInstance(3, "demo");
        this.spaceService.addPendingUser(demoSpace, "john");
        this.spaceService.addPendingUser(rootSpace, "demo");
        this.spaceService.addPendingUser(johnSpace, "root");
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0"), "", null, null);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0&filterType=requests"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=1&filterType=requests"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0&filterType=member"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        HashSet<MembershipEntry> ms = new HashSet<MembershipEntry>();
        ms.add(new MembershipEntry("/platform/administrators"));
        this.startSessionAs("john", ms);
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0&filterType=member"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        this.startSessionAs("root", ms);
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0&filterType=member"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=1&filterType=member"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)0, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=1"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
    }

    public void testShouldUseCacheWhenSpacesDidNotChanged() throws Exception {
        this.getSpaceInstance(1, "root");
        this.getSpaceInstance(2, "john");
        this.getSpaceInstance(3, "demo");
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        EntityTag eTag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        SpaceRestResourcesTest.assertNotNull((Object)eTag);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"If-None-Match", (Object)("\"" + eTag.getValue() + "\""));
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0"), "", (MultivaluedMap<String, String>)headers, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)304, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces?limit=5&offset=0&filterType=member"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }

    public void testCreateSpace() throws Exception {
        this.startSessionAs("root");
        String input = "{\"displayName\":\"social\",\"visibility\":\"hidden\",\"subscription\":\"open\"}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("spaces/"), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceEntity spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        Space space = this.spaceService.getSpaceById(spaceEntity.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space);
        SpaceRestResourcesTest.assertEquals((String)"social", (String)space.getDisplayName());
    }

    public void testCreateSpaceWithNonLatinName() throws Exception {
        this.startSessionAs("root");
        String input = "{\"displayName\":\"\u0411\u043b\u0430\u0433\u043e\u0434\u0456\u0439\u043d\u0456\u0441\u0442\u044c\",\"visibility\":\"hidden\",\"subscription\":\"open\"}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("spaces/"), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceEntity spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        Space space = this.spaceService.getSpaceById(spaceEntity.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space);
        SpaceRestResourcesTest.assertEquals((String)"\u0411\u043b\u0430\u0433\u043e\u0434\u0456\u0439\u043d\u0456\u0441\u0442\u044c", (String)space.getDisplayName());
        SpaceRestResourcesTest.assertEquals((String)"blagodijnist", (String)space.getPrettyName());
        SpaceRestResourcesTest.assertEquals((String)"blagodijnist", (String)space.getUrl());
    }

    public void testGetSpaceAvatarForAnonymous() throws Exception {
        String user = "john";
        Space space = this.getSpaceInstance(1, user);
        this.uploadSpaceAvatar(user, space.getId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space.getAvatarUrl());
        String avatarUrl = space.getAvatarUrl().replace("/portal/rest", "");
        ContainerResponse response = this.service("GET", avatarUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/" + space.getPrettyName() + "/avatar"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/default-image/avatar"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        space.setVisibility("hidden");
        space = this.spaceService.updateSpace(space);
        avatarUrl = space.getAvatarUrl().replace("/portal/rest", "");
        response = this.service("GET", avatarUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testGetSpaceAvatarForAuthentiticatedUser() throws Exception {
        String user = "john";
        Space space = this.getSpaceInstance(1, user);
        this.uploadSpaceAvatar(user, space.getId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space.getAvatarUrl());
        this.startSessionAs("mary");
        String avatarUrl = space.getAvatarUrl().replace("/portal/rest", "");
        ContainerResponse response = this.service("GET", avatarUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/" + space.getPrettyName() + "/avatar"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/default-image/avatar"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        space.setVisibility("hidden");
        space = this.spaceService.updateSpace(space);
        avatarUrl = space.getAvatarUrl().replace("/portal/rest", "");
        response = this.service("GET", avatarUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        this.startSessionAs(user);
        response = this.service("GET", avatarUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSpaceBannerForAnonymous() throws Exception {
        String user = "john";
        Space space = this.getSpaceInstance(1, user);
        String bannerUrl = space.getBannerUrl().replace("/portal/rest", "");
        SpaceRestResourcesTest.assertTrue((boolean)bannerUrl.contains("spaceTemplates"));
        ContainerResponse response = this.service("GET", bannerUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        this.uploadSpaceBanner(user, space.getId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space.getBannerUrl());
        bannerUrl = space.getBannerUrl().replace("/portal/rest", "");
        response = this.service("GET", bannerUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/" + space.getPrettyName() + "/banner"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/default-image/banner"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        space.setVisibility("hidden");
        space = this.spaceService.updateSpace(space);
        this.restartTransaction();
        space = this.spaceService.getSpaceById(space.getId());
        bannerUrl = space.getBannerUrl().replace("/portal/rest", "");
        response = this.service("GET", bannerUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testGetSpaceBannerForAuthentiticatedUser() throws Exception {
        Space space = this.getSpaceInstance(1, "john");
        this.uploadSpaceBanner("john", space.getId());
        space = this.spaceService.getSpaceById(space.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space.getBannerUrl());
        this.startSessionAs("mary");
        String bannerUrl = space.getBannerUrl().replace("/portal/rest", "");
        ContainerResponse response = this.service("GET", bannerUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/" + space.getPrettyName() + "/banner"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/default-image/banner"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        space.setVisibility("hidden");
        space = this.spaceService.updateSpace(space);
        this.restartTransaction();
        space = this.spaceService.getSpaceById(space.getId());
        bannerUrl = space.getBannerUrl().replace("/portal/rest", "");
        response = this.service("GET", bannerUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)404, (int)response.getStatus());
        this.startSessionAs("john");
        response = this.service("GET", bannerUrl, "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
    }

    public void testGetSpaceById() throws Exception {
        this.startSessionAs("root");
        String input = "{\"displayName\":\"test space\",\"visibility\":\"hidden\",\"subscription\":\"open\"}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("spaces/"), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceEntity spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        Space space = this.spaceService.getSpaceById(spaceEntity.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space);
        response = this.service("GET", this.getURLResource("spaces/" + space.getId()), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        SpaceRestResourcesTest.assertNotNull((Object)spaceEntity);
        SpaceRestResourcesTest.assertEquals((String)"test space", (String)spaceEntity.getDisplayName());
        EntityTag eTag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        SpaceRestResourcesTest.assertNotNull((Object)eTag);
    }

    public void testGetSpaceByPrettyName() throws Exception {
        this.startSessionAs("root");
        String input = "{\"displayName\":\"test space\",\"visibility\":\"hidden\",\"subscription\":\"open\"}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("spaces/"), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceEntity spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        Space space = this.spaceService.getSpaceById(spaceEntity.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space);
        response = this.service("GET", this.getURLResource("spaces/byPrettyName/" + space.getPrettyName()), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        SpaceRestResourcesTest.assertNotNull((Object)spaceEntity);
        SpaceRestResourcesTest.assertEquals((String)"test space", (String)spaceEntity.getDisplayName());
        EntityTag eTag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        SpaceRestResourcesTest.assertNotNull((Object)eTag);
    }

    public void testGetSpaceByDisplayName() throws Exception {
        this.startSessionAs("root");
        String input = "{\"displayName\":\"test space\",\"visibility\":\"hidden\",\"subscription\":\"open\"}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("spaces/"), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceEntity spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        Space space = this.spaceService.getSpaceById(spaceEntity.getId());
        SpaceRestResourcesTest.assertNotNull((Object)space);
        response = this.service("GET", this.getURLResource("spaces/byDisplayName/" + space.getDisplayName().replaceAll(" ", "%20")), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        SpaceRestResourcesTest.assertNotNull((Object)spaceEntity);
        SpaceRestResourcesTest.assertEquals((String)"test space", (String)spaceEntity.getDisplayName());
        EntityTag eTag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        SpaceRestResourcesTest.assertNotNull((Object)eTag);
    }

    public void testGetUpdateDeleteSpaceById() throws Exception {
        Space space = this.getSpaceInstance(1, "root");
        space.setVisibility("hidden");
        space.setRegistration("closed");
        space = this.spaceService.updateSpace(space);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spaces/" + space.getId()), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceEntity spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        SpaceRestResourcesTest.assertEquals((String)"space1", (String)spaceEntity.getDisplayName());
        SpaceRestResourcesTest.assertEquals((String)"hidden", (String)spaceEntity.getVisibility());
        SpaceRestResourcesTest.assertEquals((String)"closed", (String)spaceEntity.getSubscription());
        EntityTag eTag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        SpaceRestResourcesTest.assertNotNull((Object)eTag);
        String spaceId = spaceEntity.getId();
        String input = "{\"displayName\":displayName_updated, \"description\":description_updated}";
        response = this.getResponse("PUT", this.getURLResource("spaces/" + spaceId), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        response = this.service("GET", this.getURLResource("spaces/" + spaceId), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        spaceEntity = this.getBaseEntity(response.getEntity(), SpaceEntity.class);
        SpaceRestResourcesTest.assertEquals((String)"displayName_updated", (String)spaceEntity.getDisplayName());
        SpaceRestResourcesTest.assertEquals((String)"description_updated", (String)spaceEntity.getDescription());
        SpaceRestResourcesTest.assertEquals((String)"hidden", (String)spaceEntity.getVisibility());
        SpaceRestResourcesTest.assertEquals((String)"closed", (String)spaceEntity.getSubscription());
        EntityTag updatedETag = (EntityTag)response.getHttpHeaders().getFirst((Object)"ETAG");
        SpaceRestResourcesTest.assertNotSame((Object)eTag, (Object)updatedETag);
        response = this.service("DELETE", this.getURLResource("spaces/" + space.getId()), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        space = this.spaceService.getSpaceById(spaceId);
        SpaceRestResourcesTest.assertNull((Object)space);
    }

    public void testGetUsersSpaceById() throws Exception {
        Space space = this.getSpaceInstance(1, "root");
        space.setMembers(new String[]{"root", "john"});
        space.setManagers(new String[]{"root"});
        space.setInvitedUsers(new String[]{"mary"});
        space.setPendingUsers(new String[]{"demo"});
        this.spaceService.updateSpace(space);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spaces/" + space.getId() + "/users"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces/" + space.getId() + "/users?role=manager"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces/" + space.getId() + "/users?role=invited"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spaces/" + space.getId() + "/users?role=pending"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceRestResourcesTest.assertEquals((int)1, (int)collections.getEntities().size());
    }

    public void testGetSpaceByIdWithDeletedDisableUsers() throws Exception {
        Space space = this.getSpaceInstance(255, "root");
        space.setMembers(new String[]{"root", "john", "mary", "demo"});
        space.setManagers(new String[]{"root", "john"});
        this.spaceService.updateSpace(space);
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spaces/" + space.getId() + "/users"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        List dataEntities = collections.getEntities();
        SpaceRestResourcesTest.assertEquals((int)4, (int)dataEntities.size());
        DataEntity rootDataEntity = dataEntities.stream().filter(data -> data.get((Object)"username").equals("root")).findFirst().orElse(null);
        SpaceRestResourcesTest.assertNotNull((Object)rootDataEntity);
        SpaceRestResourcesTest.assertTrue((rootDataEntity.size() >= 12 ? 1 : 0) != 0);
        SpaceRestResourcesTest.assertEquals((boolean)true, (boolean)rootDataEntity.containsKey((Object)"deleted"));
        SpaceRestResourcesTest.assertEquals((boolean)true, (boolean)rootDataEntity.containsKey((Object)"enabled"));
        SpaceRestResourcesTest.assertEquals((Object)this.rootIdentity.isDeleted(), (Object)rootDataEntity.get((Object)"deleted"));
        SpaceRestResourcesTest.assertEquals((Object)this.rootIdentity.isEnable(), (Object)rootDataEntity.get((Object)"enabled"));
        response = this.service("GET", this.getURLResource("spaces/" + space.getId() + "/users?role=manager"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        dataEntities = collections.getEntities();
        SpaceRestResourcesTest.assertEquals((int)2, (int)dataEntities.size());
        SpaceRestResourcesTest.assertTrue((rootDataEntity.size() >= 12 ? 1 : 0) != 0);
        SpaceRestResourcesTest.assertEquals((boolean)true, (boolean)rootDataEntity.containsKey((Object)"deleted"));
        SpaceRestResourcesTest.assertEquals((boolean)true, (boolean)rootDataEntity.containsKey((Object)"enabled"));
        SpaceRestResourcesTest.assertEquals((Object)this.johnIdentity.isDeleted(), (Object)rootDataEntity.get((Object)"deleted"));
        SpaceRestResourcesTest.assertEquals((Object)this.johnIdentity.isEnable(), (Object)rootDataEntity.get((Object)"enabled"));
    }

    public void testSpacesApplications() throws Exception {
        this.startSessionAs("root");
        List spacesApplications = this.spaceService.getSpacesApplications();
        SpaceRestResourcesTest.assertNotNull((Object)spacesApplications);
        SpaceRestResourcesTest.assertEquals((int)0, (int)spacesApplications.size());
        String input = "{\"applicationName\":\"app\",\"contentId\":\"social/app\"}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("spaces/applications"), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        spacesApplications = this.spaceService.getSpacesApplications();
        SpaceRestResourcesTest.assertNotNull((Object)spacesApplications);
        SpaceRestResourcesTest.assertEquals((int)1, (int)spacesApplications.size());
        response = this.service("GET", this.getURLResource("spaces/applications"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        List applications = (List)response.getEntity();
        SpaceRestResourcesTest.assertNotNull((Object)applications);
        SpaceRestResourcesTest.assertEquals((int)1, (int)applications.size());
        this.restartTransaction();
        response = this.service("DELETE", this.getURLResource("spaces/applications/app"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)204, (int)response.getStatus());
        spacesApplications = this.spaceService.getSpacesApplications();
        SpaceRestResourcesTest.assertNotNull((Object)spacesApplications);
        SpaceRestResourcesTest.assertEquals((int)0, (int)spacesApplications.size());
    }

    private Space getSpaceInstance(int number, String creator) throws Exception {
        Space space = new Space();
        space.setDisplayName("space" + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setType("classic");
        space.setVisibility("private");
        space.setRegistration("validation");
        space.setPriority("2");
        space = this.spaceService.createSpace(space, creator);
        return space;
    }

    private List<ExoSocialActivity> getCreatedSpaceActivities(Space space) {
        Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName(), false);
        RealtimeListAccess listAccess = this.activityManager.getActivitiesOfSpaceWithListAccess(spaceIdentity);
        return listAccess.loadAsList(0, 10);
    }

    private void uploadSpaceBanner(String user, String spaceId) throws Exception {
        this.startSessionAs(user);
        String uploadId = "testtest";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("blank.gif");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "banner.png", "image/png");
        String input = "{\"id\":\"" + spaceId + "\",\"bannerId\":\"" + uploadId + "\"}";
        ContainerResponse response = this.getResponse("PUT", this.getURLResource("spaces/" + spaceId), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        this.endSession();
    }

    private void uploadSpaceAvatar(String user, String spaceId) throws Exception {
        this.startSessionAs(user);
        String uploadId = "testtest";
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Content-Type", (Object)"application/x-www-form-urlencoded");
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource("blank.gif");
        this.uploadService.createUploadResource(uploadId, resource.getFile(), "avatar.png", "image/png");
        String input = "{\"id\":\"" + spaceId + "\",\"avatarId\":\"" + uploadId + "\"}";
        ContainerResponse response = this.getResponse("PUT", this.getURLResource("spaces/" + spaceId), input);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        this.endSession();
    }

    public void testIsSpaceContainsExternals() throws Exception {
        this.startSessionAs("root");
        User external = this.organizationService.getUserHandler().createUserInstance("externalUser");
        this.organizationService.getUserHandler().createUser(external, false);
        this.externalUserIdentity = this.identityManager.getOrCreateIdentity("organization", "externalUser");
        this.externalUserIdentity.getProfile().setProperty("username", (Object)"externalUser");
        this.externalUserIdentity.getProfile().setProperty("external", (Object)"true");
        this.identityManager.updateProfile(this.externalUserIdentity.getProfile());
        Space space = this.getSpaceInstance(10, "root");
        ContainerResponse response = this.service("GET", this.getURLResource("spaces/" + space.getId() + "/checkExternals"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceRestResourcesTest.assertEquals((Object)"false", (Object)response.getEntity());
        this.spaceService.addMember(space, "externalUser");
        response = this.service("GET", this.getURLResource("spaces/" + space.getId() + "/checkExternals"), "", null, null);
        SpaceRestResourcesTest.assertNotNull((Object)response);
        SpaceRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceRestResourcesTest.assertEquals((Object)"true", (Object)response.getEntity());
        this.endSession();
    }
}

