/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.websocket;

import org.apache.commons.lang3.StringUtils;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.notification.model.SpaceWebNotificationItem;
import org.exoplatform.social.notification.service.SpaceWebNotificationService;
import org.exoplatform.social.websocket.entity.WebSocketMessage;
import org.exoplatform.social.websocket.listener.SpaceWebNotificationWebSocketServerListener;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;
import org.picocontainer.Startable;

public class SpaceWebNotificationWebSocketService
implements Startable {
    public static final String COMETD_CHANNEL = "/SpaceWebNotification";
    private PortalContainer container;
    private SpaceWebNotificationService spaceWebNotificationService;
    private ContinuationService continuationService;
    private EXoContinuationBayeux continuationBayeux;
    private SpaceService spaceService;
    private IdentityManager identityManager;

    public SpaceWebNotificationWebSocketService(PortalContainer container, SpaceWebNotificationService spaceWebNotificationService, ContinuationService continuationService, EXoContinuationBayeux continuationBayeux, SpaceService spaceService, IdentityManager identityManager) {
        this.container = container;
        this.spaceWebNotificationService = spaceWebNotificationService;
        this.continuationService = continuationService;
        this.continuationBayeux = continuationBayeux;
        this.spaceService = spaceService;
        this.identityManager = identityManager;
    }

    public void start() {
        ServerChannel serverChannel = (ServerChannel)this.continuationBayeux.createChannelIfAbsent(COMETD_CHANNEL, new ConfigurableServerChannel.Initializer[0]).getReference();
        serverChannel.addListener((ConfigurableServerChannel.ServerChannelListener)new SpaceWebNotificationWebSocketServerListener(this.container, this, COMETD_CHANNEL));
    }

    public void stop() {
    }

    public void sendMessage(String eventName, SpaceWebNotificationItem spaceWebNotificationItem) {
        long userId = spaceWebNotificationItem.getUserId();
        Identity identity = this.identityManager.getIdentity(String.valueOf(userId));
        if (identity != null && !identity.isDeleted() && identity.isEnable() && this.continuationService.isPresent(identity.getRemoteId())) {
            String wsMessage = new WebSocketMessage(eventName, spaceWebNotificationItem).toJsonString();
            this.continuationService.sendMessage(identity.getRemoteId(), COMETD_CHANNEL, (Object)wsMessage);
        }
    }

    public void receiveMessage(String wsClientId, String eventName, SpaceWebNotificationItem spaceWebNotificationItem) throws Exception {
        if (spaceWebNotificationItem == null) {
            throw new IllegalArgumentException("Message is empty");
        }
        long userId = spaceWebNotificationItem.getUserId();
        if (userId == 0L) {
            throw new IllegalArgumentException("Empty userId");
        }
        long spaceId = spaceWebNotificationItem.getSpaceId();
        if (spaceId == 0L) {
            throw new IllegalArgumentException("Empty spaceId");
        }
        Identity identity = this.identityManager.getIdentity(String.valueOf(userId));
        if (identity == null || identity.isDeleted() || !identity.isEnable()) {
            throw new IllegalAccessException("User Identity with id " + userId + " isn't valid");
        }
        String username = identity.getRemoteId();
        if (!this.continuationBayeux.isSubscribed(username, wsClientId)) {
            throw new IllegalAccessException("User " + username + " isn't subscribed with a valid WebSocket token.");
        }
        Space space = this.spaceService.getSpaceById(String.valueOf(spaceId));
        if (space == null) {
            throw new IllegalArgumentException("Space with id " + spaceId + " doesn't exists");
        }
        if (!this.spaceService.isMember(space, username)) {
            throw new IllegalAccessException("User " + username + " isn't member of space " + space.getDisplayName());
        }
        if (StringUtils.equals((CharSequence)eventName, (CharSequence)"notification.unread.item")) {
            this.spaceWebNotificationService.markAsUnread(spaceWebNotificationItem);
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"notification.read.item")) {
            this.spaceWebNotificationService.markAsRead(spaceWebNotificationItem);
        } else if (StringUtils.equals((CharSequence)eventName, (CharSequence)"notification.read.allItems")) {
            this.spaceWebNotificationService.markAllAsRead(userId, spaceId);
        }
    }
}

