/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.service.rest;

import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.impl.activity.ActivityRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class FieldsResponseFilterTest
extends AbstractResourceTest {
    private IdentityStorage identityStorage;
    private ActivityManager activityManager;
    private RelationshipManager relationshipManager;
    private Identity rootIdentity;
    private Identity johnIdentity;
    private Identity maryIdentity;
    private Identity demoIdentity;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityStorage = (IdentityStorage)this.getContainer().getComponentInstanceOfType(IdentityStorage.class);
        this.activityManager = (ActivityManager)this.getContainer().getComponentInstanceOfType(ActivityManager.class);
        this.relationshipManager = (RelationshipManager)this.getContainer().getComponentInstanceOfType(RelationshipManager.class);
        this.rootIdentity = new Identity("organization", "root");
        this.johnIdentity = new Identity("organization", "john");
        this.maryIdentity = new Identity("organization", "mary");
        this.demoIdentity = new Identity("organization", "demo");
        this.identityStorage.saveIdentity(this.rootIdentity);
        this.identityStorage.saveIdentity(this.johnIdentity);
        this.identityStorage.saveIdentity(this.maryIdentity);
        this.identityStorage.saveIdentity(this.demoIdentity);
        this.addResource(ActivityRestResourcesV1.class, null);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(ActivityRestResourcesV1.class);
    }

    public void testGetActivitiesWithFields() throws Exception {
        this.startSessionAs("root");
        this.relationshipManager.inviteToConnect(this.rootIdentity, this.demoIdentity);
        this.relationshipManager.confirm(this.demoIdentity, this.rootIdentity);
        ExoSocialActivityImpl rootActivity = new ExoSocialActivityImpl();
        rootActivity.setTitle("root activity");
        this.activityManager.saveActivityNoReturn(this.rootIdentity, (ExoSocialActivity)rootActivity);
        ExoSocialActivityImpl demoActivity = new ExoSocialActivityImpl();
        demoActivity.setTitle("demo activity");
        this.activityManager.saveActivityNoReturn(this.demoIdentity, (ExoSocialActivity)demoActivity);
        ExoSocialActivityImpl maryActivity = new ExoSocialActivityImpl();
        maryActivity.setTitle("mary activity");
        this.activityManager.saveActivityNoReturn(this.maryIdentity, (ExoSocialActivity)maryActivity);
        ContainerResponse response = this.service("GET", this.getURLResource("activities?limit=5&offset=0"), "", null, null);
        FieldsResponseFilterTest.assertNotNull((Object)response);
        FieldsResponseFilterTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        FieldsResponseFilterTest.assertEquals((int)2, (int)collections.getEntities().size());
        ActivityEntity activityEntity = this.getBaseEntity(collections.getEntities().get(0), ActivityEntity.class);
        FieldsResponseFilterTest.assertEquals((String)"demo activity", (String)activityEntity.getTitle());
        activityEntity = this.getBaseEntity(collections.getEntities().get(1), ActivityEntity.class);
        FieldsResponseFilterTest.assertEquals((String)"root activity", (String)activityEntity.getTitle());
        response = this.service("GET", this.getURLResource("activities?limit=5&offset=0&fields=id,title"), "", null, null);
        FieldsResponseFilterTest.assertNotNull((Object)response);
        FieldsResponseFilterTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        activityEntity = this.getBaseEntity(collections.getEntities().get(0), ActivityEntity.class);
        FieldsResponseFilterTest.assertNotNull((Object)activityEntity.getId());
        FieldsResponseFilterTest.assertNotNull((Object)activityEntity.getTitle());
        this.activityManager.deleteActivity((ExoSocialActivity)maryActivity);
        this.activityManager.deleteActivity((ExoSocialActivity)demoActivity);
        this.activityManager.deleteActivity((ExoSocialActivity)rootActivity);
    }
}

