/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.spacemembership;

import java.util.stream.Stream;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.ArrayUtils;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.impl.spacemembership.SpaceMembershipRestResourcesV1;
import org.exoplatform.social.service.test.AbstractResourceTest;

public class SpaceMembershipRestResourcesTest
extends AbstractResourceTest {
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private SpaceMembershipRestResourcesV1 membershipRestResources;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gatein.email.domain.url", "localhost:8080");
        this.identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
        this.spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
        Identity rootIdentity = this.identityManager.getOrCreateIdentity("organization", "root", true);
        Identity johnIdentity = this.identityManager.getOrCreateIdentity("organization", "john", true);
        Identity maryIdentity = this.identityManager.getOrCreateIdentity("organization", "mary", true);
        Identity demoIdentity = this.identityManager.getOrCreateIdentity("organization", "demo", true);
        Stream.of(rootIdentity, johnIdentity, maryIdentity, demoIdentity).forEach(identity -> {
            identity.setDeleted(false);
            identity.setEnable(true);
            this.identityManager.updateIdentity(identity);
        });
        this.createSpaceIfNotExist(1, "root");
        this.createSpaceIfNotExist(2, "root");
        this.createSpaceIfNotExist(3, "john");
        this.createSpaceIfNotExist(4, "mary");
        this.createSpaceIfNotExist(5, "mary");
        this.createSpaceIfNotExist(6, "mary");
        this.membershipRestResources = new SpaceMembershipRestResourcesV1(this.spaceService, this.identityManager);
        this.registry(this.membershipRestResources);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource(this.membershipRestResources.getClass());
    }

    public void testGetSpaceMembersShipOfCurrentUser() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)4, (int)collections.getEntities().size());
        response = this.service("GET", this.getURLResource("spacesMemberships?user=root"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)4, (int)collections.getEntities().size());
        this.startSessionAs("john");
        response = this.service("GET", this.getURLResource("spacesMemberships?space=space3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
    }

    public void testGetSpaceMembershipsOfAnotherUserAsANonSpacesAdministrator() throws Exception {
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?user=john"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testGetSpaceMembershipsOfAnotherUserAsASpacesAdministrator() throws Exception {
        this.startSessionAs("root");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?user=mary"), "", null, null, "root");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)6, (int)collections.getEntities().size());
    }

    public void testGetSpaceMembershipsOfASpaceAsANonMember() throws Exception {
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?space=space1"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)401, (int)response.getStatus());
    }

    public void testGetSpaceMembershipsOfASpaceAsAManager() throws Exception {
        this.startSessionAs("mary");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?space=space4"), "", null, null, "mary");
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)2, (int)collections.getEntities().size());
    }

    public void testAddSpaceMemberShip() throws Exception {
        this.startSessionAs("root");
        String input = "{\"space\":space1, \"user\":demo}";
        ContainerResponse response = this.getResponse("POST", this.getURLResource("spacesMemberships"), input);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        Space space = this.spaceService.getSpaceByPrettyName("space1");
        SpaceMembershipRestResourcesTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getMembers(), (Object)"demo"));
        input = "{\"space\":space1, \"user\":john, \"role\":redactor}";
        response = this.getResponse("POST", this.getURLResource("spacesMemberships"), input);
        space = this.spaceService.getSpaceByPrettyName("space1");
        SpaceMembershipRestResourcesTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getRedactors(), (Object)"john"));
        SpaceMembershipRestResourcesTest.assertFalse((boolean)ArrayUtils.contains((Object[])space.getRedactors(), (Object)"demo"));
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)space.getRedactors().length);
        input = "{\"space\":space1, \"user\":demo, \"role\":publisher}";
        response = this.getResponse("POST", this.getURLResource("spacesMemberships"), input);
        space = this.spaceService.getSpaceByPrettyName("space1");
        SpaceMembershipRestResourcesTest.assertTrue((boolean)ArrayUtils.contains((Object[])space.getPublishers(), (Object)"demo"));
        SpaceMembershipRestResourcesTest.assertFalse((boolean)ArrayUtils.contains((Object[])space.getPublishers(), (Object)"john"));
        SpaceMembershipRestResourcesTest.assertEquals((int)1, (int)space.getPublishers().length);
        this.startSessionAs("demo");
        input = "{\"space\":space1, \"user\":mary}";
        response = this.getResponse("POST", this.getURLResource("spacesMemberships"), input);
        SpaceMembershipRestResourcesTest.assertEquals((int)Response.Status.UNAUTHORIZED.getStatusCode(), (int)response.getStatus());
    }

    public void testGetUpdateDeleteSpaceMembership() throws Exception {
        this.spaceService.addMember(this.spaceService.getSpaceByPrettyName("space1"), "demo");
        this.startSessionAs("root");
        String id = "space1:demo:member";
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships/" + id), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        String input = "{\"role\":manager}";
        response = this.getResponse("PUT", this.getURLResource("spacesMemberships/" + id), input);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceMembershipRestResourcesTest.assertTrue((boolean)this.spaceService.isManager(this.spaceService.getSpaceByPrettyName("space1"), "demo"));
        response = this.service("DELETE", this.getURLResource("spacesMemberships/" + id), "", null, null);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceMembershipRestResourcesTest.assertFalse((boolean)this.spaceService.isMember(this.spaceService.getSpaceByPrettyName("space1"), "demo"));
        this.spaceService.addRedactor(this.spaceService.getSpaceByPrettyName("space1"), "demo");
        id = "space1:demo:redactor";
        response = this.service("DELETE", this.getURLResource("spacesMemberships/" + id), "", null, null);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceMembershipRestResourcesTest.assertFalse((boolean)this.spaceService.isRedactor(this.spaceService.getSpaceByPrettyName("space1"), "demo"));
        this.spaceService.addPublisher(this.spaceService.getSpaceByPrettyName("space1"), "demo");
        id = "space1:demo:publisher";
        response = this.service("DELETE", this.getURLResource("spacesMemberships/" + id), "", null, null);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        SpaceMembershipRestResourcesTest.assertFalse((boolean)this.spaceService.isPublisher(this.spaceService.getSpaceByPrettyName("space1"), "demo"));
    }

    public void testGetInvitedSpaceMemberships() throws Exception {
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName("space1"), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName("space2"), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName("space3"), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName("space4"), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName("space5"), "demo");
        this.spaceService.addMember(this.spaceService.getSpaceByPrettyName("space6"), "demo");
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?status=invited&returnSize=true&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        SpaceMembershipRestResourcesTest.assertEquals((int)4, (int)collections.getSize());
    }

    public void testGetPendingSpaceMemberships() throws Exception {
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName("space1"), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName("space2"), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName("space3"), "demo");
        this.spaceService.addPendingUser(this.spaceService.getSpaceByPrettyName("space4"), "demo");
        this.spaceService.addInvitedUser(this.spaceService.getSpaceByPrettyName("space5"), "demo");
        this.spaceService.addMember(this.spaceService.getSpaceByPrettyName("space6"), "demo");
        this.startSessionAs("demo");
        ContainerResponse response = this.service("GET", this.getURLResource("spacesMemberships?status=pending&returnSize=true&limit=3"), "", null, null);
        SpaceMembershipRestResourcesTest.assertNotNull((Object)response);
        SpaceMembershipRestResourcesTest.assertEquals((int)200, (int)response.getStatus());
        CollectionEntity collections = (CollectionEntity)response.getEntity();
        SpaceMembershipRestResourcesTest.assertEquals((int)3, (int)collections.getEntities().size());
        SpaceMembershipRestResourcesTest.assertEquals((int)4, (int)collections.getSize());
    }

    private void createSpaceIfNotExist(int number, String creator) throws Exception {
        String spaceName = "space" + number;
        if (this.spaceService.getSpaceByPrettyName(spaceName) == null) {
            Space space = new Space();
            space.setDisplayName(spaceName);
            space.setPrettyName(space.getDisplayName());
            space.setRegistration("open");
            space.setDescription("add new space " + number);
            space.setType("classic");
            space.setVisibility("private");
            space.setRegistration("validation");
            space.setPriority("2");
            this.spaceService.createSpace(space, creator);
        }
    }
}

