/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.Described;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.webui.page.UIPageSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.webui.space.TreeNode;
import org.exoplatform.social.webui.space.UISpaceNavigationManagement;
import org.exoplatform.social.webui.space.UISpaceNavigationNodeSelector;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.IdentifierValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.form.validator.Validator;

public class UIPageNodeForm
extends UIFormTabPane {
    private TreeNode pageNode_;
    private Object selectedParent;
    private UserNavigation contextPageNavigation;
    private static final String SHOW_PUBLICATION_DATE = "showPublicationDate";
    private static final String START_PUBLICATION_DATE = "startPublicationDate";
    private static final String END_PUBLICATION_DATE = "endPublicationDate";
    private static final String VISIBLE = "visible";
    private Map<String, Described.State> cachedLabels;
    private String selectedLocale;
    private static final String I18N_LABEL = "i18nizedLabel";
    private static final String LANGUAGES = "languages";
    private static final String LANGUAGES_ONCHANGE = "ChangeLanguage";
    private static final String SWITCH_MODE = "switchmode";
    private static final String SWITCH_MODE_ONCHANGE = "SwitchLabelMode";
    private static final String LABEL = "label";
    private static final String HTML_ATTRIBUTE_TITLE = "title";

    public UIPageNodeForm() throws Exception {
        super("UIPageNodeForm");
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        UIFormInputSet uiSettingSet = new UIFormInputSet("PageNodeSetting");
        UIFormCheckBoxInput uiDateInputCheck = new UIFormCheckBoxInput(SHOW_PUBLICATION_DATE, null, (Object)false);
        uiDateInputCheck.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIPageNodeForm.label.showPublicationDate"));
        UIFormCheckBoxInput uiVisibleCheck = new UIFormCheckBoxInput(VISIBLE, null, (Object)true);
        uiVisibleCheck.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIPageNodeForm.label.visible"));
        UIFormCheckBoxInput uiSwitchLabelMode = new UIFormCheckBoxInput(SWITCH_MODE, null, (Object)true);
        uiSwitchLabelMode.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIPageNodeForm.label.switchMode"));
        uiDateInputCheck.setOnChange("SwitchPublicationDate");
        uiVisibleCheck.setOnChange("SwitchVisible");
        uiSwitchLabelMode.setOnChange(SWITCH_MODE_ONCHANGE);
        UIFormSelectBox uiFormLanguagesSelectBox = new UIFormSelectBox(LANGUAGES, null, null);
        this.initLanguageSelectBox(uiFormLanguagesSelectBox);
        uiFormLanguagesSelectBox.setOnChange(LANGUAGES_ONCHANGE);
        UIFormStringInput uri = new UIFormStringInput("URI", "URI", null);
        uri.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIPageNodeForm.label.uri"));
        uiSettingSet.addUIFormInput((UIFormInput)uri.setEditable(false));
        UIFormStringInput name = new UIFormStringInput("name", "name", null);
        name.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIPageNodeForm.label.name"));
        uiSettingSet.addUIFormInput((UIFormInput)name.addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 30}).addValidator(IdentifierValidator.class, new Object[0])).addUIFormInput((UIFormInput)uiSwitchLabelMode);
        UIFormStringInput label = new UIFormStringInput(LABEL, LABEL, null);
        label.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIPageNodeForm.label.label"));
        uiSettingSet.addUIFormInput((UIFormInput)label.addValidator(StringLengthValidator.class, new Object[]{3, 120})).addUIFormInput((UIFormInput)uiFormLanguagesSelectBox);
        UIFormStringInput i18nLabel = new UIFormStringInput(I18N_LABEL, null, null);
        i18nLabel.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UIPageNodeForm.label.i18nLabel"));
        uiSettingSet.addUIFormInput((UIFormInput)i18nLabel.setMaxLength(255).addValidator(StringLengthValidator.class, new Object[]{3, 120})).addUIFormInput((UIFormInput)uiVisibleCheck.setChecked(true)).addUIFormInput((UIFormInput)uiDateInputCheck).addUIFormInput((UIFormInput)new UIFormDateTimeInput(START_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0])).addUIFormInput((UIFormInput)new UIFormDateTimeInput(END_PUBLICATION_DATE, null, null).addValidator(DateTimeValidator.class, new Object[0]));
        this.addUIFormInput(uiSettingSet);
        this.setSelectedTab(uiSettingSet.getId());
        UIPageSelector uiPageSelector = (UIPageSelector)this.createUIComponent(UIPageSelector.class, null, null);
        uiPageSelector.configure("UIPageSelector", "pageRef");
        this.addUIFormInput((UIFormInput)uiPageSelector);
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector("Icon", "icon");
        this.addUIFormInput((UIFormInput)uiIconSelector);
        this.setActions(new String[]{"Save", "Back"});
    }

    public TreeNode getPageNode() {
        return this.pageNode_;
    }

    public void setValues(TreeNode pageNode) throws Exception {
        this.pageNode_ = pageNode;
        this.selectedLocale = (String)this.getUIFormSelectBox(LANGUAGES).getValue();
        this.cachedLabels = new HashMap<String, Described.State>();
        if (pageNode == null) {
            this.getUIStringInput("name").setEditable(true);
            ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon("Default");
            this.setShowPublicationDate(false);
            this.switchLabelMode(false);
            return;
        }
        this.getUIStringInput("name").setEditable(false);
        this.invokeGetBindingBean(this.pageNode_);
    }

    private void initLanguageSelectBox(UIFormSelectBox langSelectBox) {
        ArrayList<SelectItemOption> lang = new ArrayList<SelectItemOption>();
        LocaleConfigService localeService = (LocaleConfigService)this.getApplicationComponent(LocaleConfigService.class);
        Locale currentLocale = ((PortletRequestContext)WebuiRequestContext.getCurrentInstance()).getLocale();
        Iterator i = localeService.getLocalConfigs().iterator();
        String displayName = null;
        String language = null;
        String country = null;
        String defaultValue = null;
        while (i.hasNext()) {
            LocaleConfig config = (LocaleConfig)i.next();
            Locale locale = config.getLocale();
            language = locale.getLanguage();
            country = locale.getCountry();
            if (country != null && country.length() > 0) {
                language = language + "_" + country;
            }
            displayName = null;
            try {
                String translation;
                ResourceBundle localeResourceBundle = this.getResourceBundle(currentLocale);
                String key = "Locale." + language;
                displayName = translation = localeResourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                displayName = this.capitalizeFirstLetter(locale.getDisplayName(currentLocale));
            }
            catch (Exception e) {
                // empty catch block
            }
            SelectItemOption option = new SelectItemOption(displayName, (Object)language);
            if (locale.getDisplayName().equals(currentLocale.getDisplayName())) {
                option.setSelected(true);
                defaultValue = language;
            }
            lang.add(option);
        }
        Collections.sort(lang, new LanguagesComparator());
        langSelectBox.setOptions(lang);
        langSelectBox.setValue(defaultValue);
    }

    private ResourceBundle getResourceBundle(Locale locale) throws Exception {
        ExoContainer appContainer = ExoContainerContext.getCurrentContainer();
        ResourceBundleService service = (ResourceBundleService)appContainer.getComponentInstanceOfType(ResourceBundleService.class);
        ResourceBundle res = service.getResourceBundle("locale.portal.webui", locale);
        return res;
    }

    private String capitalizeFirstLetter(String word) {
        if (word == null) {
            return null;
        }
        if (word.length() == 0) {
            return word;
        }
        StringBuilder result = new StringBuilder(word);
        result.replace(0, 1, result.substring(0, 1).toUpperCase());
        return result.toString();
    }

    public void invokeGetBindingBean(Object bean) throws Exception {
        super.invokeGetBindingBean(bean);
        TreeNode pageNode = (TreeNode)bean;
        String icon = pageNode.getIcon();
        if (icon == null || icon.length() < 0) {
            icon = "Default";
        }
        ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(icon);
        this.getUIStringInput(LABEL).setValue((Object)pageNode.getLabel());
        Map<Locale, Described.State> i18nizedLabels = pageNode.getI18nizedLabels();
        if (i18nizedLabels != null) {
            for (Locale key : i18nizedLabels.keySet()) {
                String locale = key.getCountry() != null && !key.getCountry().isEmpty() ? key.getLanguage() + "_" + key.getCountry() : key.getLanguage();
                this.cachedLabels.put(locale, i18nizedLabels.get(key));
            }
        }
        if (this.cachedLabels.get(this.selectedLocale) != null) {
            this.getUIStringInput(I18N_LABEL).setValue((Object)this.cachedLabels.get(this.selectedLocale).getName());
        }
        if (pageNode.getVisibility() == Visibility.SYSTEM) {
            UIFormInputSet uiSettingSet = (UIFormInputSet)this.getChildById("PageNodeSetting");
            uiSettingSet.removeChildById(VISIBLE);
            uiSettingSet.removeChildById(SHOW_PUBLICATION_DATE);
            uiSettingSet.removeChildById(START_PUBLICATION_DATE);
            uiSettingSet.removeChildById(END_PUBLICATION_DATE);
        } else {
            Visibility visibility = pageNode.getVisibility();
            boolean isVisible = visibility == null || EnumSet.of(Visibility.DISPLAYED, Visibility.TEMPORAL).contains(visibility);
            this.getUIFormCheckBoxInput(VISIBLE).setChecked(isVisible);
            this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE).setChecked(Visibility.TEMPORAL.equals((Object)visibility));
            this.setShowCheckPublicationDate(isVisible);
            Calendar cal = Calendar.getInstance();
            if (pageNode.getStartPublicationTime() != -1L) {
                cal.setTime(new Date(pageNode.getStartPublicationTime()));
                this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setCalendar(cal);
            } else {
                this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setValue(null);
            }
            if (pageNode.getEndPublicationTime() != -1L) {
                cal.setTime(new Date(pageNode.getEndPublicationTime()));
                this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setCalendar(cal);
            } else {
                this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setValue(null);
            }
        }
        boolean isExtendedMode = true;
        if (pageNode.getNode().getLabel() != null && pageNode.getNode().getLabel().trim().length() > 0) {
            isExtendedMode = false;
        }
        this.getUIFormCheckBoxInput(SWITCH_MODE).setChecked(isExtendedMode);
        this.switchLabelMode(isExtendedMode);
    }

    public void invokeSetBindingBean(Object bean) throws Exception {
        super.invokeSetBindingBean(bean);
        TreeNode node = (TreeNode)bean;
        if (node.getVisibility() != Visibility.SYSTEM) {
            UIFormCheckBoxInput showPubDate;
            Visibility visibility = this.getUIFormCheckBoxInput(VISIBLE).isChecked() ? ((showPubDate = this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE)).isChecked() ? Visibility.TEMPORAL : Visibility.DISPLAYED) : Visibility.HIDDEN;
            node.setVisibility(visibility);
            Calendar cal = this.getUIFormDateTimeInput(START_PUBLICATION_DATE).getCalendar();
            Date date = cal != null ? cal.getTime() : null;
            node.setStartPublicationTime(date == null ? -1L : date.getTime());
            cal = this.getUIFormDateTimeInput(END_PUBLICATION_DATE).getCalendar();
            date = cal != null ? cal.getTime() : null;
            node.setEndPublicationTime(date == null ? -1L : date.getTime());
        }
        this.cachedLabels.put((String)this.getUIFormSelectBox(LANGUAGES).getValue(), new Described.State((String)this.getUIStringInput(I18N_LABEL).getValue(), null));
        HashMap<Locale, Described.State> labels = new HashMap<Locale, Described.State>(this.cachedLabels.size());
        this.getUIFormSelectBox(LANGUAGES).getValue();
        for (String strLocale : this.cachedLabels.keySet()) {
            String[] arr;
            Locale locale = strLocale.contains("_") ? ((arr = strLocale.split("_")).length > 2 ? new Locale(arr[0], arr[1], arr[2]) : new Locale(arr[0], arr[1])) : new Locale(strLocale);
            labels.put(locale, this.cachedLabels.get(strLocale));
        }
        node.setI18nizedLabels(labels);
        if (this.getUIFormCheckBoxInput(SWITCH_MODE).getValue().toString().equals("true")) {
            node.setLabel(null);
        }
    }

    public void setShowCheckPublicationDate(boolean show) {
        this.getUIFormCheckBoxInput(VISIBLE).setChecked(show);
        UIFormCheckBoxInput uiForm = this.getUIFormCheckBoxInput(SHOW_PUBLICATION_DATE);
        uiForm.setRendered(show);
        this.setShowPublicationDate(show && uiForm.isChecked());
    }

    public void setShowPublicationDate(boolean show) {
        this.getUIFormDateTimeInput(START_PUBLICATION_DATE).setRendered(show);
        this.getUIFormDateTimeInput(END_PUBLICATION_DATE).setRendered(show);
    }

    public Object getSelectedParent() {
        return this.selectedParent;
    }

    public void setSelectedParent(Object obj) {
        this.selectedParent = obj;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        UIPageSelector uiPageSelector = (UIPageSelector)this.getChild(UIPageSelector.class);
        if (uiPageSelector == null) {
            return;
        }
        UIPopupWindow uiPopupWindowPage = (UIPopupWindow)uiPageSelector.getChild(UIPopupWindow.class);
        if (uiPopupWindowPage == null) {
            return;
        }
        uiPopupWindowPage.processRender(context);
    }

    public String getOwner() {
        return this.contextPageNavigation.getKey().getName();
    }

    public SiteType getOwnerType() {
        return this.contextPageNavigation.getKey().getType();
    }

    public void setContextPageNavigation(UserNavigation _contextPageNav) {
        this.contextPageNavigation = _contextPageNav;
    }

    public UserNavigation getContextPageNavigation() {
        return this.contextPageNavigation;
    }

    private String getLabelOnLocale(String locale) {
        if (this.cachedLabels.get(locale) != null) {
            return this.cachedLabels.get(locale).getName();
        }
        return null;
    }

    private void updateCachedLabels(String locale, String label) {
        this.cachedLabels.put(locale, new Described.State(label, null));
    }

    public void setSelectedLocale(String selectedLocale) {
        this.selectedLocale = selectedLocale;
    }

    public String getSelectedLocale() {
        return this.selectedLocale;
    }

    private void switchLabelMode(boolean isExtendedMode) {
        this.getUIStringInput(LABEL).setRendered(!isExtendedMode);
        this.getUIStringInput(I18N_LABEL).setRendered(isExtendedMode);
        this.getUIFormSelectBox(LANGUAGES).setRendered(isExtendedMode);
    }

    public static class CreatePageActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            DataStorage dataService;
            Page existPage;
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            UIPageSelector pageSelector = (UIPageSelector)uiForm.findFirstComponentOfType(UIPageSelector.class);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UIFormInputSet uiInputSet = (UIFormInputSet)pageSelector.getChild(UIFormInputSet.class);
            List children = uiInputSet.getChildren();
            for (UIComponent uiChild : children) {
                List validators;
                UIFormInputBase uiInput;
                if (!(uiChild instanceof UIFormInputBase) || !(uiInput = (UIFormInputBase)uiChild).isValid() || (validators = uiInput.getValidators()) == null) continue;
                try {
                    for (Validator validator : validators) {
                        validator.validate((UIFormInput)uiInput);
                    }
                }
                catch (MessageException ex) {
                    uiPortalApp.addMessage(ex.getDetailMessage());
                    return;
                }
                catch (Exception ex) {
                    uiPortalApp.addMessage(new ApplicationMessage(ex.getMessage(), null));
                    return;
                }
            }
            UserACL userACL = (UserACL)uiForm.getApplicationComponent(UserACL.class);
            String ownerId = uiForm.getOwner();
            String[] accessPermission = new String[]{"*:" + ownerId};
            String editPermission = userACL.getMakableMT() + ":" + ownerId;
            if (SiteType.PORTAL.equals((Object)uiForm.getOwnerType())) {
                UIPortal uiPortal = Util.getUIPortal();
                accessPermission = uiPortal.getAccessPermissions();
                editPermission = uiPortal.getEditPermission();
            }
            UIFormStringInput uiPageName = (UIFormStringInput)uiInputSet.getChildById("pageName");
            UIFormStringInput uiPageTitle = (UIFormStringInput)uiInputSet.getChildById("pageTitle");
            Page page = new Page();
            page.setOwnerType(uiForm.getOwnerType().getName());
            page.setOwnerId(ownerId);
            page.setName((String)uiPageName.getValue());
            String title = (String)uiPageTitle.getValue();
            if (title == null || title.trim().length() < 1) {
                title = page.getName();
            }
            page.setTitle(title);
            page.setShowMaxWindow(Boolean.valueOf(false));
            page.setAccessPermissions(accessPermission);
            page.setEditPermission(editPermission);
            userACL.hasPermission(page);
            page.setModifiable(true);
            if (page.getChildren() == null) {
                page.setChildren(new ArrayList());
            }
            if ((existPage = (dataService = (DataStorage)uiForm.getApplicationComponent(DataStorage.class)).getPage(page.getPageId())) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageForm.msg.sameName", null));
                pcontext.addUIComponentToUpdateByAjax((UIComponent)uiPortalApp.getUIPopupMessages());
                return;
            }
            pageSelector.setValue(page.getId());
        }
    }

    public static class ClearPageActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            UIPageSelector pageSelector = (UIPageSelector)uiForm.findFirstComponentOfType(UIPageSelector.class);
            pageSelector.setPage(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)pageSelector);
        }
    }

    public static class SwitchLabelModeActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            boolean isExtendedMode = uiForm.getUIFormCheckBoxInput(UIPageNodeForm.SWITCH_MODE).isChecked();
            uiForm.switchLabelMode(isExtendedMode);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class SwitchVisibleActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            boolean isCheck = uiForm.getUIFormCheckBoxInput(UIPageNodeForm.VISIBLE).isChecked();
            uiForm.setShowCheckPublicationDate(isCheck);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class SwitchPublicationDateActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            boolean isCheck = uiForm.getUIFormCheckBoxInput(UIPageNodeForm.SHOW_PUBLICATION_DATE).isChecked();
            uiForm.setShowPublicationDate(isCheck);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class ChangeLanguageActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageNodeForm uiForm = (UIPageNodeForm)((Object)event.getSource());
            UIFormSelectBox languageSelection = uiForm.getUIFormSelectBox(UIPageNodeForm.LANGUAGES);
            UIFormStringInput label = uiForm.getUIStringInput(UIPageNodeForm.I18N_LABEL);
            uiForm.updateCachedLabels(uiForm.getSelectedLocale(), (String)label.getValue());
            uiForm.setSelectedLocale((String)languageSelection.getValue());
            label.setValue((Object)uiForm.getLabelOnLocale(uiForm.getSelectedLocale()));
        }
    }

    public static class BackActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
        }
    }

    public static class SaveActionListener
    extends EventListener<UIPageNodeForm> {
        public void execute(Event<UIPageNodeForm> event) throws Exception {
            UIPageSelector pageSelector;
            WebuiRequestContext ctx = event.getRequestContext();
            UIPageNodeForm uiPageNodeForm = (UIPageNodeForm)((Object)event.getSource());
            UserNavigation contextNavigation = uiPageNodeForm.getContextPageNavigation();
            UIApplication uiPortalApp = ctx.getUIApplication();
            TreeNode pageNode = uiPageNodeForm.getPageNode();
            if (pageNode == null || pageNode.getVisibility() != Visibility.SYSTEM && uiPageNodeForm.getUIFormCheckBoxInput(UIPageNodeForm.SHOW_PUBLICATION_DATE).isChecked()) {
                Date endDate;
                Calendar currentCalendar = Calendar.getInstance();
                currentCalendar.set(currentCalendar.get(1), currentCalendar.get(2), currentCalendar.get(5), 0, 0, 0);
                Date currentDate = currentCalendar.getTime();
                Calendar startCalendar = uiPageNodeForm.getUIFormDateTimeInput(UIPageNodeForm.START_PUBLICATION_DATE).getCalendar();
                Date startDate = startCalendar != null ? startCalendar.getTime() : currentDate;
                Calendar endCalendar = uiPageNodeForm.getUIFormDateTimeInput(UIPageNodeForm.END_PUBLICATION_DATE).getCalendar();
                Date date = endDate = endCalendar != null ? endCalendar.getTime() : null;
                if (currentDate.after(startDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.currentDateBeforeStartDate", args, 1));
                    return;
                }
                if (endCalendar != null && startCalendar != null && startDate.after(endDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.startDateBeforeEndDate", args, 1));
                    return;
                }
                if (endCalendar != null && currentDate.after(endDate)) {
                    Object[] args = new Object[]{};
                    uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.currentDateBeforeEndDate", args, 1));
                    return;
                }
            }
            UIFormStringInput nameInput = uiPageNodeForm.getUIStringInput("name");
            String nodeName = (String)nameInput.getValue();
            TreeNode selectedParent = (TreeNode)uiPageNodeForm.getSelectedParent();
            if (pageNode == null && selectedParent.getChild(nodeName) != null) {
                uiPortalApp.addMessage(new ApplicationMessage("UIPageNodeForm.msg.SameName", null));
                return;
            }
            if (pageNode == null) {
                pageNode = selectedParent.addChild(nodeName);
                uiPageNodeForm.pageNode_ = pageNode;
            }
            if ((pageSelector = (UIPageSelector)uiPageNodeForm.getChild(UIPageSelector.class)).getPage() == null) {
                pageSelector.setValue(null);
            } else {
                Page page;
                DataStorage storage = (DataStorage)uiPageNodeForm.getApplicationComponent(DataStorage.class);
                if (storage.getPage((page = storage.getPage(pageSelector.getPage().getKey().format())).getPageId()) == null) {
                    storage.create(page);
                    pageSelector.setValue(page.getPageId());
                }
            }
            if (pageNode.getLabel() == null) {
                pageNode.setLabel(pageNode.getName());
            }
            uiPageNodeForm.invokeSetBindingBean(pageNode);
            UIFormInputIconSelector uiIconSelector = (UIFormInputIconSelector)uiPageNodeForm.getChild(UIFormInputIconSelector.class);
            if (uiIconSelector.getSelectedIcon().equals("Default")) {
                pageNode.setIcon("DefaultPageIcon");
            } else {
                pageNode.setIcon(uiIconSelector.getSelectedIcon());
            }
            UIPopupWindow uiPopup = (UIPopupWindow)uiPageNodeForm.getParent();
            UISpaceNavigationManagement uiSpaceNav = (UISpaceNavigationManagement)uiPopup.getParent();
            UISpaceNavigationNodeSelector uiNodeSelector = (UISpaceNavigationNodeSelector)uiSpaceNav.getChild(UISpaceNavigationNodeSelector.class);
            uiNodeSelector.save();
            uiSpaceNav.setOwner(contextNavigation.getKey().getName());
            uiSpaceNav.setOwnerType(contextNavigation.getKey().getTypeName());
            uiNodeSelector.setEdittedNavigation(contextNavigation);
            uiNodeSelector.initTreeData();
            uiPopup.setShow(false);
            SpaceUtils.updateWorkingWorkSpace();
        }
    }

    private class LanguagesComparator
    implements Comparator<SelectItemOption<String>> {
        private LanguagesComparator() {
        }

        @Override
        public int compare(SelectItemOption<String> o1, SelectItemOption<String> o2) {
            return o1.getLabel().compareToIgnoreCase(o2.getLabel());
        }
    }
}

