/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/space/UISpacePermission.gtmpl", events={@EventConfig(listeners={SaveActionListener.class})})
public class UISpacePermission
extends UIForm {
    private static final String SPACE_VISIBILITY = "UIVisibility";
    private static final String SPACE_REGISTRATION = "UIRegistration";
    private String spaceId;

    public UISpacePermission() throws Exception {
        ArrayList<SelectItemOption> spaceVisibility = new ArrayList<SelectItemOption>(2);
        spaceVisibility.add(new SelectItemOption((Object)"private"));
        spaceVisibility.add(new SelectItemOption((Object)"hidden"));
        UIFormRadioBoxInput uiRadioVisibility = new UIFormRadioBoxInput(SPACE_VISIBILITY, null, spaceVisibility);
        this.addUIFormInput((UIFormInput)uiRadioVisibility);
        ArrayList<SelectItemOption> spaceRegistration = new ArrayList<SelectItemOption>(3);
        spaceRegistration.add(new SelectItemOption((Object)"open"));
        spaceRegistration.add(new SelectItemOption((Object)"validation"));
        spaceRegistration.add(new SelectItemOption((Object)"close"));
        UIFormRadioBoxInput uiRadioRegistration = new UIFormRadioBoxInput(SPACE_REGISTRATION, null, spaceRegistration);
        this.addUIFormInput((UIFormInput)uiRadioRegistration);
    }

    public void setValue(Space space) throws Exception {
        String visibility = space.getVisibility();
        ((UIFormRadioBoxInput)this.getChildById(SPACE_VISIBILITY)).setValue((Object)visibility);
        String registration = space.getRegistration();
        ((UIFormRadioBoxInput)this.getChildById(SPACE_REGISTRATION)).setValue((Object)registration);
        this.spaceId = space.getId();
    }

    public static class SaveActionListener
    extends EventListener<UISpacePermission> {
        public void execute(Event<UISpacePermission> event) throws Exception {
            UISpacePermission uiSpacePermission = (UISpacePermission)((Object)event.getSource());
            SpaceService spaceSrc = (SpaceService)uiSpacePermission.getApplicationComponent(SpaceService.class);
            WebuiRequestContext requestContext = event.getRequestContext();
            String visibility = (String)((UIFormRadioBoxInput)uiSpacePermission.getChildById(UISpacePermission.SPACE_VISIBILITY)).getValue();
            String registration = (String)((UIFormRadioBoxInput)uiSpacePermission.getChildById(UISpacePermission.SPACE_REGISTRATION)).getValue();
            Space space = spaceSrc.getSpaceById(uiSpacePermission.spaceId);
            space.setVisibility(visibility);
            space.setRegistration(registration);
            spaceSrc.saveSpace(space, false);
            UIApplication uiApp = requestContext.getUIApplication();
            uiApp.addMessage(new ApplicationMessage("UISpacePermission.msg.update-success", null, 2));
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpacePermission);
        }
    }
}

