/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import javax.annotation.PreDestroy;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceAccessType;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="war:/groovy/social/webui/space/UISpaceAccess.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={RequestToJoinActionListener.class}), @EventConfig(listeners={RefuseActionListener.class}), @EventConfig(listeners={JoinActionListener.class})})
public class UISpaceAccess
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UISpaceAccess.class);
    private static final String ALL_SPACE_LINK = "all-spaces";
    private String status = null;
    private String spacePrettyName = null;
    private String spaceDisplayName = null;
    private String redirectURI = null;

    public UISpaceAccess() throws Exception {
        this.init();
    }

    public void init() {
        try {
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            Object statusObject = pcontext.getRequest().getSession().getAttribute("social.accessed.space.type.key");
            Object spacePrettyNameObj = pcontext.getRequest().getSession().getAttribute("social.accessed.space.key");
            if (spacePrettyNameObj == null) {
                this.status = statusObject != null ? statusObject.toString() : "";
                this.spaceDisplayName = "";
                this.spacePrettyName = "";
                this.redirectURI = statusObject != null ? Utils.getURI(ALL_SPACE_LINK) : "";
                return;
            }
            this.status = statusObject.toString();
            this.spacePrettyName = spacePrettyNameObj.toString();
            Space space = Utils.getSpaceService().getSpaceByPrettyName(this.spacePrettyName);
            this.spaceDisplayName = space.getDisplayName();
            if (SpaceAccessType.NO_AUTHENTICATED.toString().equals(this.status)) {
                this.redirectToSpaceHome(space);
            }
            if (SpaceAccessType.NOT_ACCESS_WIKI_SPACE.toString().equals(this.status)) {
                Object wikiPageObj = pcontext.getRequest().getSession().getAttribute("social.accessed.space.wiki.page.key");
                pcontext.sendRedirect(this.getPermanWikiLink(this.spacePrettyName, wikiPageObj.toString()));
                return;
            }
            this.redirectURI = "";
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void redirectToSpaceHome(Space space) {
        WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        JavascriptManager jsManager = ctx.getJavascriptManager();
        jsManager.addJavascript((CharSequence)("try { window.location.href='" + Utils.getSpaceHomeURL(space) + "' } catch(e) {" + "window.location.href('" + Utils.getSpaceHomeURL(space) + "') }"));
    }

    public String getStatus() {
        return this.status;
    }

    public String getSpacePrettyName() {
        return this.spacePrettyName;
    }

    public String getSpaceDisplayName() {
        return this.spaceDisplayName;
    }

    public String getRedirectURI() {
        return this.redirectURI;
    }

    private String getPermanWikiLink(String spacePrettyName, String wikiPage) {
        StringBuilder sb = new StringBuilder("wiki/group/spaces/").append(spacePrettyName).append("/").append(wikiPage);
        RequestContext ctx = RequestContext.getCurrentInstance();
        NodeURL nodeURL = (NodeURL)ctx.createURL(NodeURL.TYPE);
        NavigationResource resource = new NavigationResource(SiteType.PORTAL, Util.getPortalRequestContext().getPortalOwner(), sb.toString());
        return nodeURL.setResource(resource).toString();
    }

    @PreDestroy
    public void cleanSession() {
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        pcontext.getRequest().getSession().removeAttribute("social.accessed.space.key");
        pcontext.getRequest().getSession().removeAttribute("social.accessed.space.type.key");
    }

    public static class JoinActionListener
    extends EventListener<UISpaceAccess> {
        public void execute(Event<UISpaceAccess> event) throws Exception {
            UISpaceAccess uiSpaceAccess = (UISpaceAccess)((Object)event.getSource());
            String remoteId = Utils.getOwnerRemoteId();
            SpaceService s = Utils.getSpaceService();
            Space space = s.getSpaceByPrettyName(uiSpaceAccess.getSpacePrettyName());
            s.addMember(space, remoteId);
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            String originalRequest = pcontext.getRequest().getSession().getAttribute("social.accessed.space.request.path.key").toString();
            pcontext.getRequest().getSession().removeAttribute("social.accessed.space.request.path.key");
            event.getRequestContext().getJavascriptManager().getRequireJS().addScripts("(function(){ window.location.href = '" + originalRequest + "';})();");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSpaceAccess.getParent());
        }
    }

    public static class RefuseActionListener
    extends EventListener<UISpaceAccess> {
        public void execute(Event<UISpaceAccess> event) throws Exception {
            UISpaceAccess uiSpaceAccess = (UISpaceAccess)((Object)event.getSource());
            String remoteId = Utils.getOwnerRemoteId();
            SpaceService s = Utils.getSpaceService();
            Space space = s.getSpaceByPrettyName(uiSpaceAccess.getSpacePrettyName());
            s.removeInvitedUser(space, remoteId);
            event.getRequestContext().getJavascriptManager().getRequireJS().addScripts("(function(){ window.location.href = '" + Utils.getURI(UISpaceAccess.ALL_SPACE_LINK) + "';})();");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSpaceAccess.getParent());
        }
    }

    public static class RequestToJoinActionListener
    extends EventListener<UISpaceAccess> {
        public void execute(Event<UISpaceAccess> event) throws Exception {
            UISpaceAccess uiSpaceAccess = (UISpaceAccess)((Object)event.getSource());
            String remoteId = Utils.getOwnerRemoteId();
            SpaceService s = Utils.getSpaceService();
            Space space = s.getSpaceByPrettyName(uiSpaceAccess.getSpacePrettyName());
            s.addPendingUser(space, remoteId);
            event.getRequestContext().getJavascriptManager().getRequireJS().addScripts("(function(){ window.location.href = '" + Utils.getSpaceHomeURL(space) + "';})();");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSpaceAccess.getParent());
        }
    }

    public static class AcceptActionListener
    extends EventListener<UISpaceAccess> {
        public void execute(Event<UISpaceAccess> event) throws Exception {
            UISpaceAccess uiSpaceAccess = (UISpaceAccess)((Object)event.getSource());
            String remoteId = Utils.getOwnerRemoteId();
            SpaceService s = Utils.getSpaceService();
            Space space = s.getSpaceByPrettyName(uiSpaceAccess.getSpacePrettyName());
            s.addMember(space, remoteId);
            event.getRequestContext().getJavascriptManager().getRequireJS().addScripts("(function(){ window.location.href = '" + Utils.getSpaceHomeURL(space) + "';})();");
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSpaceAccess.getParent());
        }
    }
}

