/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.UIAvatarUploadContent;
import org.exoplatform.social.webui.UIAvatarUploader;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.space.UISpaceApplication;
import org.exoplatform.social.webui.space.UISpaceMember;
import org.exoplatform.social.webui.space.UISpacePermission;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="war:/groovy/social/webui/space/UISpaceInfo.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}, phase=Event.Phase.PROCESS), @EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UISpaceInfo
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(UISpaceInfo.class);
    private static final String SPACE_ID = "id";
    private static final String SPACE_DISPLAY_NAME = "displayName";
    private static final String SPACE_DESCRIPTION = "description";
    private static final String SPACE_TAG = "tag";
    private SpaceService spaceService = null;
    private final String POPUP_AVATAR_UPLOADER = "UIPopupAvatarUploader";
    private static final String MSG_DEFAULT_SPACE_DESCRIPTION = "UISpaceAddForm.msg.default_space_description";
    private static final String HTML_ATTRIBUTE_TITLE = "title";
    private static final String HTML_ATTRIBUTE_PLACEHOLDER = "placeholder";

    public UISpaceInfo() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ResourceBundle resourceBundle = requestContext.getApplicationResourceBundle();
        UIFormStringInput spaceId = (UIFormStringInput)new UIFormStringInput(SPACE_ID, SPACE_ID, null).setRendered(false);
        spaceId.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UISpaceInfo.label.SpaceId"));
        this.addUIFormInput((UIFormInput)spaceId);
        UIFormStringInput spaceDisplayName = new UIFormStringInput(SPACE_DISPLAY_NAME, SPACE_DISPLAY_NAME, null);
        spaceDisplayName.setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, resourceBundle.getString("UISpaceSettings.label.spaceDisplayName"));
        this.addUIFormInput((UIFormInput)spaceDisplayName.addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^([\\p{L}\\d']+[\\s]?)+$", "UISpaceInfo.msg.name-invalid"}).addValidator(StringLengthValidator.class, new Object[]{3, 30}));
        UIFormTextAreaInput description = new UIFormTextAreaInput(SPACE_DESCRIPTION, SPACE_DESCRIPTION, null);
        description.setHTMLAttribute(HTML_ATTRIBUTE_PLACEHOLDER, resourceBundle.getString("UISpaceSettings.label.spaceDescription"));
        this.addUIFormInput((UIFormInput)description.addValidator(StringLengthValidator.class, new Object[]{0, 255}));
        UIFormStringInput tag = (UIFormStringInput)new UIFormStringInput(SPACE_TAG, SPACE_TAG, null).setRendered(false);
        tag.setHTMLAttribute(HTML_ATTRIBUTE_TITLE, resourceBundle.getString("UISpaceInfo.label.tag"));
        this.addUIFormInput((UIFormInput)tag);
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAvatarUploader");
        uiPopup.setWindowSize(500, 0);
        this.addChild((UIComponent)uiPopup);
    }

    protected void setCurrentSpace(Space space) throws Exception {
        UITabPane uiTabPane = (UITabPane)this.getAncestorOfType(UITabPane.class);
        uiTabPane.setSelectedTab(1);
        UISpaceInfo uiSpaceInfo = (UISpaceInfo)uiTabPane.getChild(UISpaceInfo.class);
        uiSpaceInfo.setValue(space);
        UISpaceMember uiSpaceMember = (UISpaceMember)uiTabPane.getChild(UISpaceMember.class);
        uiSpaceMember.setValue(space.getId());
        uiSpaceMember.setSpaceURL(space.getUrl());
        UISpaceApplication uiSpaceApplication = (UISpaceApplication)uiTabPane.getChild(UISpaceApplication.class);
        uiSpaceApplication.setValue(space);
        UISpacePermission uiSpacePermission = (UISpacePermission)uiTabPane.getChild(UISpacePermission.class);
        uiSpacePermission.setValue(space);
    }

    public void setValue(Space space) throws Exception {
        this.invokeGetBindingBean(space);
        UIFormTextAreaInput description = this.getUIFormTextAreaInput(SPACE_DESCRIPTION);
        description.setValue((Object)StringEscapeUtils.unescapeHtml((String)((String)description.getValue())));
        this.getUIStringInput(SPACE_TAG).setValue((Object)space.getTag());
    }

    public void saveAvatar(UIAvatarUploadContent uiAvatarUploadContent, Space space) throws Exception {
        SpaceService spaceService = this.getSpaceService();
        space.setAvatarAttachment(uiAvatarUploadContent.getAvatarAttachment());
        spaceService.updateSpace(space);
        space.setEditor(Utils.getViewerRemoteId());
        spaceService.updateSpaceAvatar(space);
    }

    protected String getImageSource() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        String id = (String)this.getUIStringInput(SPACE_ID).getValue();
        Space space = spaceService.getSpaceById(id);
        return space.getAvatarUrl();
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    public OrganizationService getOrganizationService() {
        return (OrganizationService)this.getApplicationComponent(OrganizationService.class);
    }

    public DataStorage getDataSource() {
        return (DataStorage)this.getApplicationComponent(DataStorage.class);
    }

    private UserNode renamePageNode(String newNodeLabel, Space space) {
        UserPortalConfigService configService = (UserPortalConfigService)this.getApplicationComponent(UserPortalConfigService.class);
        DataStorage dataService = (DataStorage)this.getApplicationComponent(DataStorage.class);
        try {
            UserNode renamedNode = SpaceUtils.getSpaceUserNode((Space)space);
            UserNode parentNode = renamedNode.getParent();
            String newNodeName = SpaceUtils.cleanString((String)newNodeLabel);
            if (parentNode.getChild(newNodeName) != null) {
                newNodeName = newNodeName + "_" + System.currentTimeMillis();
            }
            renamedNode.setLabel(newNodeLabel);
            renamedNode.setName(newNodeName);
            Page page = dataService.getPage(renamedNode.getPageRef().format());
            if (page != null) {
                page.setTitle(newNodeLabel);
                dataService.save(page);
            }
            SpaceUtils.getUserPortal().saveNode(parentNode, null);
            space.setUrl(newNodeName);
            SpaceUtils.changeSpaceUrlPreference((UserNode)renamedNode, (Space)space, (String)newNodeLabel);
            ArrayList userNodes = new ArrayList(renamedNode.getChildren());
            for (UserNode childNode : userNodes) {
                SpaceUtils.changeSpaceUrlPreference((UserNode)childNode, (Space)space, (String)newNodeLabel);
            }
            return renamedNode;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static class ChangeAvatarActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceInfo.getChild(UIPopupWindow.class);
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)uiSpaceInfo.createUIComponent(UIAvatarUploader.class, null, null);
            uiPopup.setUIComponent((UIComponent)uiAvatarUploader);
            uiPopup.setShow(true);
        }
    }

    public static class SaveActionListener
    extends EventListener<UISpaceInfo> {
        public void execute(Event<UISpaceInfo> event) throws Exception {
            UISpaceInfo uiSpaceInfo = (UISpaceInfo)((Object)event.getSource());
            SpaceService spaceService = uiSpaceInfo.getSpaceService();
            UIPortal uiPortal = Util.getUIPortal();
            String id = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_ID).getValue();
            String name = (String)uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_DISPLAY_NAME).getValue();
            Space space = spaceService.getSpaceById(id);
            String oldDisplayName = space.getDisplayName();
            String existingDescription = space.getDescription();
            if (space == null) {
                event.getRequestContext().sendRedirect(Utils.getURI("all-spaces"));
                return;
            }
            UserNode selectedNode = uiPortal.getSelectedUserNode();
            UserNode renamedNode = null;
            boolean nameChanged = !space.getDisplayName().equals(name);
            UIPortletApplication uiApp = (UIPortletApplication)uiSpaceInfo.getAncestorOfType(UIPortletApplication.class);
            if (nameChanged) {
                String cleanedString = SpaceUtils.cleanString((String)name);
                if (spaceService.getSpaceByUrl(cleanedString) != null) {
                    uiSpaceInfo.getUIStringInput(UISpaceInfo.SPACE_DISPLAY_NAME).setValue((Object)oldDisplayName);
                    uiSpaceInfo.getUIFormTextAreaInput(UISpaceInfo.SPACE_DESCRIPTION).setValue((Object)existingDescription);
                    uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.current-name-exist", null, 2));
                    return;
                }
                renamedNode = uiSpaceInfo.renamePageNode(name, space);
                if (renamedNode == null) {
                    return;
                }
            }
            uiSpaceInfo.invokeSetBindingBean(space);
            String spaceDescription = space.getDescription();
            if (spaceDescription == null || spaceDescription.trim().length() == 0) {
                ResourceBundle resourceBundle = event.getRequestContext().getApplicationResourceBundle();
                space.setDescription(resourceBundle.getString(UISpaceInfo.MSG_DEFAULT_SPACE_DESCRIPTION));
                uiSpaceInfo.getUIFormTextAreaInput(UISpaceInfo.SPACE_DESCRIPTION).setValue((Object)space.getDescription());
            } else {
                space.setDescription(StringEscapeUtils.escapeHtml((String)space.getDescription()));
                if (!existingDescription.equals(spaceDescription)) {
                    space.setField(Space.UpdatedField.DESCRIPTION);
                }
            }
            space.setEditor(Utils.getViewerRemoteId());
            if (nameChanged) {
                space.setDisplayName(oldDisplayName);
                String remoteId = Utils.getViewerRemoteId();
                spaceService.renameSpace(remoteId, space, name);
                OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                GroupHandler groupHandler = organizationService.getGroupHandler();
                Group group = groupHandler.findGroupById(space.getGroupId());
                group.setLabel(space.getDisplayName());
                groupHandler.saveGroup(group, true);
            } else {
                spaceService.updateSpace(space);
            }
            if (nameChanged) {
                if (renamedNode != null) {
                    selectedNode = renamedNode;
                    PortalRequestContext prContext = Util.getPortalRequestContext();
                    ((NodeURL)prContext.createURL(NodeURL.TYPE)).setNode(selectedNode);
                    event.getRequestContext().sendRedirect(Utils.getSpaceURL(selectedNode));
                    return;
                }
            } else {
                uiApp.addMessage(new ApplicationMessage("UISpaceInfo.msg.update-success", null, 2));
            }
        }
    }
}

