/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.connections.UIUpdateRelationship;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(template="war:/groovy/social/webui/connections/UIAllPeople.gtmpl", events={@EventConfig(listeners={ConnectActionListener.class}), @EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={IgnoreActionListener.class}), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={LoadMorePeopleActionListener.class})})
public class UIAllPeople
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIAllPeople.class);
    private static final String INVITATION_REVOKED_INFO = "UIAllPeople.label.RevokedInfo";
    private static final String INVITATION_ESTABLISHED_INFO = "UIAllPeople.label.InvitationEstablishedInfo";
    private static final Integer PEOPLE_PER_PAGE = 45;
    private static final String ALL_FILTER = "All";
    public static final String SEARCH = "Search";
    private static final char EMPTY_CHARACTER = '\u0000';
    UIProfileUserSearch uiProfileUserSearch = null;
    private boolean loadAtEnd = false;
    private int currentLoadIndex;
    private boolean enableLoadNext;
    private int loadingCapacity;
    private List<Identity> peopleList;
    private ListAccess<Identity> peopleListAccess;
    private int peopleNum;
    String selectedChar = null;
    private Identity lastOwner = null;

    public final String getSelectedChar() {
        return this.selectedChar;
    }

    public final void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public UIAllPeople() throws Exception {
        this.addChild(UIUpdateRelationship.class, null, null);
        this.uiProfileUserSearch = (UIProfileUserSearch)this.addChild(UIProfileUserSearch.class, null, null);
        this.uiProfileUserSearch.setHasConnectionLink(false);
        this.setSelectedChar(ALL_FILTER);
        this.init();
    }

    public void init() {
        try {
            this.setLoadAtEnd(false);
            this.enableLoadNext = false;
            this.currentLoadIndex = 0;
            this.loadingCapacity = PEOPLE_PER_PAGE;
            this.peopleList = new ArrayList<Identity>();
            ArrayList<Identity> excludedIdentityList = new ArrayList<Identity>();
            excludedIdentityList.add(Utils.getViewerIdentity());
            this.uiProfileUserSearch.getProfileFilter().setExcludedIdentityList(excludedIdentityList);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setLoadingCapacity(int loadingCapacity) {
        this.loadingCapacity = loadingCapacity;
    }

    public boolean isEnableLoadNext() {
        return this.enableLoadNext;
    }

    public void setEnableLoadNext(boolean enableLoadNext) {
        this.enableLoadNext = enableLoadNext;
    }

    public boolean isLoadAtEnd() {
        return this.loadAtEnd;
    }

    public void setLoadAtEnd(boolean loadAtEnd) {
        this.loadAtEnd = loadAtEnd;
    }

    public List<Identity> getPeopleList() throws Exception {
        this.peopleList = this.loadPeople(0, this.currentLoadIndex + this.loadingCapacity);
        int realPeopleListSize = this.peopleList.size();
        this.setEnableLoadNext(realPeopleListSize >= PEOPLE_PER_PAGE && realPeopleListSize < this.getPeopleNum());
        return this.peopleList;
    }

    public void setPeopleList(List<Identity> peopleList) {
        this.peopleList = peopleList;
    }

    public int getPeopleNum() {
        return this.peopleNum;
    }

    public void setPeopleNum(int peopleNum) {
        this.peopleNum = peopleNum;
    }

    public ListAccess<Identity> getPeopleListAccess() {
        return this.peopleListAccess;
    }

    public void setPeopleListAccess(ListAccess<Identity> peopleListAccess) {
        this.peopleListAccess = peopleListAccess;
    }

    public void increaseOffset() throws Exception {
        this.currentLoadIndex += this.loadingCapacity;
    }

    public void loadSearch() throws Exception {
        this.currentLoadIndex = 0;
        this.setPeopleList(this.loadPeople(this.currentLoadIndex, this.loadingCapacity));
    }

    private List<Identity> loadPeople(int index, int length) throws Exception {
        this.lastOwner = Utils.getOwnerIdentity();
        ProfileFilter filter = this.uiProfileUserSearch.getProfileFilter();
        ListAccess listAccess = Utils.getIdentityManager().getIdentitiesByProfileFilter(this.lastOwner.getProviderId(), filter, false);
        Identity[] identities = (Identity[])listAccess.load(index, length);
        this.setPeopleNum(listAccess.getSize());
        this.setPeopleListAccess((ListAccess<Identity>)listAccess);
        this.uiProfileUserSearch.setPeopleNum(listAccess.getSize());
        return Arrays.asList(identities);
    }

    protected boolean isNewOwner() {
        Identity current = Utils.getOwnerIdentity();
        if (this.lastOwner == null || current == null) {
            return false;
        }
        return !this.lastOwner.getRemoteId().equals(current.getRemoteId());
    }

    public Relationship getRelationship(Identity identity) throws Exception {
        if (identity.equals((Object)Utils.getViewerIdentity())) {
            return null;
        }
        return Utils.getRelationshipManager().get(identity, Utils.getViewerIdentity());
    }

    public static class SearchActionListener
    extends EventListener<UIAllPeople> {
        public void execute(Event<UIAllPeople> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIAllPeople uiAllPeople = (UIAllPeople)((Object)event.getSource());
            UIProfileUserSearch uiSearch = uiAllPeople.uiProfileUserSearch;
            String charSearch = ctx.getRequestParameter("objectId");
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultNameVal = resApp.getString(uiSearch.getId() + ".label.Name");
            String defaultPosVal = resApp.getString(uiSearch.getId() + ".label.Position");
            String defaultSkillsVal = resApp.getString(uiSearch.getId() + ".label.Skills");
            ProfileFilter filter = uiAllPeople.uiProfileUserSearch.getProfileFilter();
            try {
                uiAllPeople.setSelectedChar(charSearch);
                if (charSearch != null) {
                    ((UIFormStringInput)uiSearch.getChildById(UIAllPeople.SEARCH)).setValue((Object)defaultNameVal);
                    ((UIFormStringInput)uiSearch.getChildById("position")).setValue((Object)defaultPosVal);
                    ((UIFormStringInput)uiSearch.getChildById("skills")).setValue((Object)defaultSkillsVal);
                    filter.setName(charSearch);
                    filter.setPosition("");
                    filter.setSkills("");
                    filter.setFirstCharacterOfName(charSearch.toCharArray()[0]);
                    if (UIAllPeople.ALL_FILTER.equals(charSearch)) {
                        filter.setFirstCharacterOfName('\u0000');
                        filter.setName("");
                    }
                    uiSearch.setRawSearchConditional("");
                } else if (UIAllPeople.ALL_FILTER.equals(uiSearch.getRawSearchConditional())) {
                    uiAllPeople.setSelectedChar(UIAllPeople.ALL_FILTER);
                }
                uiSearch.setProfileFilter(filter);
                uiSearch.setNewSearch(true);
            }
            catch (Exception e) {
                uiSearch.setIdentityList(new ArrayList<Identity>());
            }
            uiAllPeople.loadSearch();
            uiAllPeople.setLoadAtEnd(false);
        }
    }

    public static class IgnoreActionListener
    extends EventListener<UIAllPeople> {
        public void execute(Event<UIAllPeople> event) throws Exception {
            UIAllPeople uiAllPeople = (UIAllPeople)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity inviIdentityIdentity = Utils.getIdentityManager().getIdentity(userId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, inviIdentityIdentity);
            if (relationship == null) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIAllPeople.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            uiAllPeople.setLoadAtEnd(false);
            if (relationship.getStatus() == Relationship.Type.CONFIRMED) {
                Utils.getRelationshipManager().delete(relationship);
            } else {
                Utils.getRelationshipManager().deny(inviIdentityIdentity, invitingIdentity);
            }
            Utils.clearCacheOnUserPopup();
            UIUpdateRelationship updateUserRelationship = (UIUpdateRelationship)uiAllPeople.getChild(UIUpdateRelationship.class);
            updateUserRelationship.setIdentity(inviIdentityIdentity).setRelationship(null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)updateUserRelationship);
        }
    }

    public static class ConfirmActionListener
    extends EventListener<UIAllPeople> {
        public void execute(Event<UIAllPeople> event) throws Exception {
            UIAllPeople uiAllPeople = (UIAllPeople)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(userId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            uiAllPeople.setLoadAtEnd(false);
            if (relationship == null || relationship.getStatus() != Relationship.Type.PENDING) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIAllPeople.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Utils.getRelationshipManager().confirm(invitedIdentity, invitingIdentity);
            Utils.clearCacheOnUserPopup();
            relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            UIUpdateRelationship updateUserRelationship = (UIUpdateRelationship)uiAllPeople.getChild(UIUpdateRelationship.class);
            updateUserRelationship.setIdentity(invitedIdentity).setRelationship(relationship);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)updateUserRelationship);
        }
    }

    public static class ConnectActionListener
    extends EventListener<UIAllPeople> {
        public void execute(Event<UIAllPeople> event) throws Exception {
            UIAllPeople uiAllPeople = (UIAllPeople)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            Identity invitedIdentity = Utils.getIdentityManager().getIdentity(userId, true);
            Identity invitingIdentity = Utils.getViewerIdentity();
            Relationship relationship = Utils.getRelationshipManager().get(invitingIdentity, invitedIdentity);
            uiAllPeople.setLoadAtEnd(false);
            if (relationship != null) {
                UIApplication uiApplication = event.getRequestContext().getUIApplication();
                uiApplication.addMessage(new ApplicationMessage(UIAllPeople.INVITATION_ESTABLISHED_INFO, null, 2));
                return;
            }
            relationship = Utils.getRelationshipManager().inviteToConnect(invitingIdentity, invitedIdentity);
            Utils.clearCacheOnUserPopup();
            UIUpdateRelationship updateUserRelationship = (UIUpdateRelationship)uiAllPeople.getChild(UIUpdateRelationship.class);
            updateUserRelationship.setIdentity(invitedIdentity).setRelationship(relationship);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)updateUserRelationship);
        }
    }

    public static class LoadMorePeopleActionListener
    extends EventListener<UIAllPeople> {
        public void execute(Event<UIAllPeople> event) throws Exception {
            UIAllPeople uiAllPeople = (UIAllPeople)((Object)event.getSource());
            if (uiAllPeople.currentLoadIndex < uiAllPeople.peopleNum) {
                uiAllPeople.increaseOffset();
            } else {
                uiAllPeople.setEnableLoadNext(false);
            }
        }
    }
}

