/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.StringListAccess;
import org.exoplatform.social.webui.UIUserInvitation;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.organization.account.UIUserSelector;

@ComponentConfigs(value={@ComponentConfig(template="war:/groovy/social/webui/space/UISpaceMember.gtmpl", events={@EventConfig(listeners={RevokeInvitedUserActionListener.class}), @EventConfig(listeners={DeclineUserActionListener.class}), @EventConfig(listeners={ValidateUserActionListener.class}), @EventConfig(listeners={RemoveUserActionListener.class}), @EventConfig(listeners={ToggleLeadershipActionListener.class})})})
public class UISpaceMember
extends UIContainer {
    private static final String MSG_ERROR_SELF_REMOVE_LEADER = "UISpaceMember.msg.error_self_remove_leader";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_YOU = "UISpaceMember.msg.error_self_remove_leader_you";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_ARE = "UISpaceMember.msg.error_self_remove_leader_are";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_IS = "UISpaceMember.msg.error_self_remove_leader_is";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_LEAVING_IT = "UISpaceMember.msg.error_self_remove_leader_leaving_it";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER_REMOVING_THE_RIGHTS = "UISpaceMember.msg.error_self_remove_leader_removing_the_rights";
    private static final int FIRST_PAGE = 1;
    private String spaceId;
    private SpaceService spaceService = null;
    private UIPageIterator iteratorPendingUsers;
    private UIPageIterator iteratorInvitedUsers;
    private UIPageIterator iteratorExistingUsers;
    private final String iteratorPendingID = "UIIteratorPendding";
    private final String iteratorInvitedID = "UIIteratorInvited";
    private final String iteratorExistingID = "UIIteratorExisting";
    private final Integer PENDING_PER_PAGE = 10;
    private final Integer INVITATION_PER_PAGE = 10;
    private final Integer MEMBERS_PER_PAGE = 20;
    private static final String USER_TO_INVITE = "user_to_invite";
    String typeOfRelation = null;
    String spaceURL = null;
    private boolean hasErr = false;
    private boolean isNewSearch;

    public UISpaceMember() throws Exception {
        this.addChild(UIUserInvitation.class, null, null);
        this.iteratorPendingUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorPendding");
        this.iteratorInvitedUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorInvited");
        this.iteratorExistingUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorExisting");
        this.addChild((UIComponent)this.iteratorPendingUsers);
        this.addChild((UIComponent)this.iteratorInvitedUsers);
        this.addChild((UIComponent)this.iteratorExistingUsers);
        this.setTypeOfRelation(USER_TO_INVITE);
    }

    public UIPageIterator getUIPageIteratorPendingUsers() {
        return this.iteratorPendingUsers;
    }

    public UIPageIterator getUIPageIteratorInvitedUsers() {
        return this.iteratorInvitedUsers;
    }

    public UIPageIterator getUIPageIteratorExistingUsers() {
        return this.iteratorExistingUsers;
    }

    public void setValue(String spaceId) throws Exception {
        this.spaceId = spaceId;
    }

    public String getTypeOfRelation() {
        return this.typeOfRelation;
    }

    public void setTypeOfRelation(String typeOfRelation) {
        this.typeOfRelation = typeOfRelation;
    }

    public String getSpaceURL() {
        return this.spaceURL;
    }

    public void setSpaceURL(String spaceURL) {
        this.spaceURL = spaceURL;
    }

    public boolean isHasErr() {
        return this.hasErr;
    }

    public void setHasErr(boolean hasErr) {
        this.hasErr = hasErr;
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    protected String getRestContextName() {
        return PortalContainer.getCurrentRestContextName();
    }

    protected String getPortalName() {
        return PortalContainer.getCurrentPortalContainerName();
    }

    public List<String> getPendingUsers() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] pendingUsers = space.getPendingUsers();
        if (pendingUsers == null || pendingUsers.length == 0) {
            return new ArrayList<String>();
        }
        int currentPage = this.iteratorPendingUsers.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(Arrays.asList(pendingUsers)), this.PENDING_PER_PAGE.intValue());
        this.iteratorPendingUsers.setPageList((PageList)pageList);
        int pageCount = this.iteratorPendingUsers.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorPendingUsers.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorPendingUsers.setCurrentPage(currentPage - 1);
        }
        return this.iteratorPendingUsers.getCurrentPageData();
    }

    public List<String> getInvitedUsers() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] invitedUsers = space.getInvitedUsers();
        if (invitedUsers == null || invitedUsers.length == 0) {
            return new ArrayList<String>();
        }
        int currentPage = this.iteratorInvitedUsers.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(Arrays.asList(invitedUsers)), this.INVITATION_PER_PAGE.intValue());
        this.iteratorInvitedUsers.setPageList((PageList)pageList);
        int pageCount = this.iteratorInvitedUsers.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorInvitedUsers.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorInvitedUsers.setCurrentPage(currentPage - 1);
        }
        return this.iteratorInvitedUsers.getCurrentPageData();
    }

    public List<String> getExistingUsers() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] memberUsers = space.getMembers();
        if (memberUsers == null || memberUsers.length == 0) {
            return new ArrayList<String>();
        }
        int currentPage = this.iteratorExistingUsers.getCurrentPage();
        HashSet<String> users = new HashSet<String>(Arrays.asList(memberUsers));
        users.addAll(SpaceUtils.findMembershipUsersByGroupAndTypes((String)space.getGroupId(), (String[])new String[]{"*"}));
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(new ArrayList<String>(users)), this.MEMBERS_PER_PAGE.intValue());
        this.iteratorExistingUsers.setPageList((PageList)pageList);
        if (this.isNewSearch()) {
            this.iteratorExistingUsers.setCurrentPage(1);
        } else {
            this.iteratorExistingUsers.setCurrentPage(currentPage);
        }
        this.setNewSearch(false);
        return this.iteratorExistingUsers.getCurrentPageData();
    }

    public void setUsersName(String userName) {
    }

    public String getUsersName() {
        return null;
    }

    public boolean isSuperUser() throws Exception {
        return this.getRemoteUser().equals(this.getUserACL().getSuperUser());
    }

    public String getHomeSpaceUrl() throws Exception {
        Space space = this.getSpaceService().getSpaceById(this.spaceId);
        return Utils.getSpaceHomeURL(space);
    }

    public String getManageSpacesUrl() throws Exception {
        return Utils.getURI("spaces");
    }

    public boolean isLeader(String userName) throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        return spaceService.isManager(space, userName);
    }

    protected boolean hasWildCardMembership(String userId) {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        return SpaceUtils.isUserHasMembershipTypesInGroup((String)userId, (String)space.getGroupId(), (String)"*");
    }

    public boolean isCurrentUser(String userName) throws Exception {
        return this.getRemoteUser().equals(userName);
    }

    protected boolean isMember(String userId) {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        try {
            if (ArrayUtils.contains((Object[])space.getMembers(), (Object)userId)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private UserACL getUserACL() throws Exception {
        return (UserACL)this.getApplicationComponent(UserACL.class);
    }

    private String getRemoteUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public String getFullName(String userId) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        Identity identity = idm.getOrCreateIdentity("organization", userId, true);
        if (identity == null) {
            return "";
        }
        return StringEscapeUtils.escapeHtml((String)identity.getProfile().getFullName());
    }

    public boolean isNewSearch() {
        return this.isNewSearch;
    }

    public void setNewSearch(boolean isNewSearch) {
        this.isNewSearch = isNewSearch;
    }

    private String[] makeParamSelfRemoveLeaderErrorMessage(String userName, String currentUser) {
        if (userName == null || currentUser == null) {
            return null;
        }
        if (currentUser.equals(userName)) {
            return new String[]{MSG_ERROR_SELF_REMOVE_LEADER_YOU, MSG_ERROR_SELF_REMOVE_LEADER_ARE, MSG_ERROR_SELF_REMOVE_LEADER_LEAVING_IT};
        }
        return new String[]{this.getFullName(userName), MSG_ERROR_SELF_REMOVE_LEADER_IS, MSG_ERROR_SELF_REMOVE_LEADER_REMOVING_THE_RIGHTS};
    }

    public static class CloseActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)event.getSource();
            UISpaceMember uiSpaceMember = (UISpaceMember)uiForm.getAncestorOfType(UISpaceMember.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            uiPopup.setUIComponent(null);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class ToggleLeadershipActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext rcontext = event.getRequestContext();
            String targetUser = rcontext.getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            space.setEditor(Utils.getViewerRemoteId());
            boolean success = false;
            if (spaceService.isManager(space, targetUser)) {
                if (spaceService.isOnlyManager(space, targetUser)) {
                    UIApplication uiApp = rcontext.getUIApplication();
                    String currentUser = rcontext.getRemoteUser();
                    uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_SELF_REMOVE_LEADER, (Object[])uiSpaceMember.makeParamSelfRemoveLeaderErrorMessage(targetUser, currentUser), 1));
                    return;
                }
                spaceService.setManager(space, targetUser, false);
                success = true;
            } else if (spaceService.isMember(space, targetUser)) {
                spaceService.setManager(space, targetUser, true);
                success = true;
            }
            if (success) {
                ((WebuiRequestContext)rcontext.getParentAppRequestContext()).setResponseComplete(true);
            }
        }
    }

    public static class ValidateUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            spaceService.addMember(spaceService.getSpaceById(uiSpaceMember.spaceId), userName);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class RemoveUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            boolean useAjax = prContext.useAjax();
            UIApplication uiApp = requestContext.getUIApplication();
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            String currentUser = requestContext.getRemoteUser();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            if (!useAjax) {
                userName = currentUser;
            }
            if (spaceService.isOnlyManager(space, userName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_SELF_REMOVE_LEADER, (Object[])uiSpaceMember.makeParamSelfRemoveLeaderErrorMessage(userName, currentUser), 1));
                return;
            }
            spaceService.removeMember(space, userName);
            spaceService.setManager(spaceService.getSpaceById(space.getId()), userName, false);
            if (!useAjax) {
                prContext = Util.getPortalRequestContext();
                prContext.setResponseComplete(true);
                StringBuffer url = new StringBuffer();
                if (uiSpaceMember.isSuperUser()) {
                    url.append(Utils.getSpaceHomeURL(space)).append("/SpaceSettingPortlet");
                } else {
                    url.append(Utils.getURI("spaces"));
                }
                prContext.getResponse().sendRedirect(url.toString());
                return;
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class DeclineUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            spaceService.removePendingUser(spaceService.getSpaceById(uiSpaceMember.spaceId), userName);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    public static class RevokeInvitedUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            spaceService.removeInvitedUser(spaceService.getSpaceById(uiSpaceMember.spaceId), userName);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }
}

